/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.controller.handler;

import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamsHandler {
    private static final Logger log = LoggerFactory.getLogger(ParamsHandler.class);

    public static ParamsHandler build() {
        return new ParamsHandler();
    }

    public void print(Map<Integer, Object> params) {
        this.handle(params, this::printHandler);
    }

    public void handle(Map<Integer, Object> params) {
        this.printHandler(params);
        this.handler(params, this::simpleFormHandler);
    }

    public void handle(Map<Integer, Object> params, FormHandler formHandler) {
        this.handler(params, formHandler);
    }

    private Object printHandler(Object obj) {
        LogUtils.info((Logger)log, (String)"\u8bf7\u6c42\u53c2\u6570: {}", (Object)JsonUtils.objToStr((Object)obj));
        return obj;
    }

    private Object simpleFormHandler(Object arg) {
        if (ClassUtils.isBaseDataType(arg.getClass())) {
            if (arg instanceof String) {
                return this.handleStringField(arg);
            }
            return arg;
        }
        List fields = ClassUtils.getAllFields(arg.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            Object fieldValue = this.fetchFieldValue(arg, field);
            if (null == fieldValue || !(fieldValue instanceof String)) continue;
            String newValue = this.handleStringField(fieldValue);
            this.updatePropertyValue(arg, field, newValue);
        }
        return arg;
    }

    private String handleStringField(Object fieldValue) {
        return this.decodeChinese(String.valueOf(fieldValue));
    }

    private Object fetchFieldValue(Object arg, Field field) {
        Object fieldValue = null;
        try {
            fieldValue = field.get(arg);
        }
        catch (IllegalAccessException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
        }
        return fieldValue;
    }

    private String decodeChinese(String valueStr) {
        try {
            return URLDecoder.decode(valueStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
            return valueStr;
        }
    }

    private void updatePropertyValue(Object arg, Field field, String value) {
        try {
            PropertyUtils.setSimpleProperty((Object)arg, (String)field.getName(), (Object)value);
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace((Throwable)e);
        }
    }

    private void handler(Map<Integer, Object> params, FormHandler formHandler) {
        for (Map.Entry<Integer, Object> entry : params.entrySet()) {
            Object arg = entry.getValue();
            Object value = formHandler.handle(arg);
            params.put(entry.getKey(), value);
        }
    }

    private ParamsHandler() {
    }

    private static interface FormHandler {
        public Object handle(Object var1);
    }
}

