/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.controller.handler;

import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.controller.handler.ParamsHandler;
import com.bruce.tool.controller.handler.ParamsListener;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerAspect.class);

    public Object deeperAround(ProceedingJoinPoint pjp) throws Throwable {
        Map<Integer, Object> params = this.fetchParams(pjp);
        if (params.isEmpty()) {
            return this.printResultInfo(pjp);
        }
        ParamsHandler.build().handle(params);
        int length = pjp.getArgs().length;
        for (int i = 0; i < length; ++i) {
            if (!Objects.nonNull(params.get(i))) continue;
            pjp.getArgs()[i] = params.get(i);
        }
        return this.printResultInfo(pjp);
    }

    public Object deeperAround(ProceedingJoinPoint pjp, ParamsListener listener) throws Throwable {
        Map<Integer, Object> params = this.fetchParams(pjp);
        if (params.isEmpty()) {
            return this.printResultInfo(pjp);
        }
        listener.on(params);
        int length = pjp.getArgs().length;
        for (int i = 0; i < length; ++i) {
            if (!Objects.nonNull(params.get(i))) continue;
            pjp.getArgs()[i] = params.get(i);
        }
        return this.printResultInfo(pjp);
    }

    private Object printResultInfo(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed(pjp.getArgs());
        LogUtils.info((Logger)log, (String)"\u8fd4\u56de\u7ed3\u679c: {}", (Object)result);
        return result;
    }

    private Map<Integer, Object> fetchParams(ProceedingJoinPoint pjp) {
        String[] formPackages = this.fetchFormPackage();
        HashMap<Integer, Object> params = new HashMap<Integer, Object>(0);
        if (null == formPackages || formPackages.length == 0) {
            return params;
        }
        int length = pjp.getArgs().length;
        for (int i = 0; i < length; ++i) {
            Object arg = pjp.getArgs()[i];
            if (null == arg) continue;
            Class<?> clazz = arg.getClass();
            if (ClassUtils.isBaseDataType(clazz)) {
                params.put(i, arg);
                continue;
            }
            this.fetchByPackage(formPackages, params, i, arg);
        }
        return params;
    }

    private String[] fetchFormPackage() {
        Form form = this.getClass().getAnnotation(Form.class);
        return form.packages();
    }

    private void fetchByPackage(String[] formPackage, Map<Integer, Object> params, int i, Object arg) {
        String clsPackage = arg.getClass().getPackage().getName();
        for (String packageName : formPackage) {
            if (!clsPackage.contains(packageName)) continue;
            params.put(i, arg);
            break;
        }
    }

    @Inherited
    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Form {
        public String[] packages() default {""};
    }
}

