/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.controller.config;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConfigurationProperties(prefix="tool.cors")
public class CorsProperties {
    private String mapping = "/**";
    private String[] allowedOrigins = new String[]{"127.0.0.1"};
    private String[] allowedMethods = new String[]{"POST", "GET", "PUT", "OPTIONS", "DELETE"};
    private Boolean allowCredentials = true;
    private String[] allowedHeaders = new String[]{"Cache-Control", "Content-Language", "Content-Type", "Expires", "Last-Modified", "Pragma"};
    private String[] exposedHeaders = new String[0];
    private Integer maxAge = 3600;

    public String getMapping() {
        return this.mapping;
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public String[] getAllowedMethods() {
        return this.allowedMethods;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public String[] getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public String[] getExposedHeaders() {
        return this.exposedHeaders;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setAllowedMethods(String[] allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setAllowedHeaders(String[] allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setExposedHeaders(String[] exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsProperties)) {
            return false;
        }
        CorsProperties other = (CorsProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mapping = this.getMapping();
        String other$mapping = other.getMapping();
        if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedMethods(), other.getAllowedMethods())) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedHeaders(), other.getAllowedHeaders())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExposedHeaders(), other.getExposedHeaders())) {
            return false;
        }
        Integer this$maxAge = this.getMaxAge();
        Integer other$maxAge = other.getMaxAge();
        return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CorsProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedMethods());
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedHeaders());
        result = result * 59 + Arrays.deepHashCode(this.getExposedHeaders());
        Integer $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        return result;
    }

    public String toString() {
        return "CorsProperties(mapping=" + this.getMapping() + ", allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedMethods=" + Arrays.deepToString(this.getAllowedMethods()) + ", allowCredentials=" + this.getAllowCredentials() + ", allowedHeaders=" + Arrays.deepToString(this.getAllowedHeaders()) + ", exposedHeaders=" + Arrays.deepToString(this.getExposedHeaders()) + ", maxAge=" + this.getMaxAge() + ")";
    }
}

