/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.valid;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.exception.ErrorCode;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidUtils {
    public static <T> boolean valid(T obj) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate(obj, new Class[0]);
        if (violations != null && !violations.isEmpty()) {
            throw new BaseRuntimeException((Object)ErrorCode.SYSTEM_ERROR, ((ConstraintViolation)violations.iterator().next()).getMessage());
        }
        return true;
    }

    private ValidUtils() {
    }
}

