/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.string;

import com.bruce.tool.common.exception.ExceptionUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String DEFAULT_SEPERATOR = ",";
    public static final String SEPERATOR_COMMA = ",";
    public static final String SEPERATOR_VERTICAL_BAR = "\\|";
    public static final String SEPERATOR_SEMICOLON = ";";

    public static List<String> splitToList(String source) {
        return StringUtils.splitToList(source, ",");
    }

    public static List<String> splitToList(String source, String seperator) {
        if (null == seperator) {
            seperator = ",";
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return Lists.newArrayList();
        }
        return Splitter.on((String)seperator).trimResults().splitToList((CharSequence)source);
    }

    public static String unicode2str(String unicode) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(unicode);
        while (matcher.find()) {
            String group = matcher.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = matcher.group(1);
            unicode = unicode.replace(group1, ch + "");
        }
        return unicode;
    }

    public static String str2Unicode(String string) {
        try {
            StringBuffer out = new StringBuffer();
            byte[] bytes = string.getBytes("unicode");
            for (int i = 0; i < bytes.length - 1; i += 2) {
                out.append("\\u");
                String str = Integer.toHexString(bytes[i + 1] & 0xFF);
                for (int j = str.length(); j < 2; ++j) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xFF);
                out.append(str1);
                out.append(str);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            ExceptionUtils.printStackTrace(e);
            return null;
        }
    }

    public static List<String> fetchMatchs(String ratesInfo, String regex) {
        ArrayList<String> colgroups = new ArrayList<String>();
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(ratesInfo);
        while (m1.find()) {
            for (int i = 0; i < m1.groupCount(); ++i) {
                String test1 = m1.group(i);
                colgroups.add(test1);
            }
        }
        return colgroups;
    }

    public static String formatJson(String content) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int index = 0; index < content.length(); ++index) {
            char ch = content.charAt(index);
            if (ch == '{' || ch == '[') {
                sb.append(ch);
                sb.append('\n');
                StringUtils.appendTabs(sb, ++count);
                continue;
            }
            if (ch == '}' || ch == ']') {
                sb.append('\n');
                StringUtils.appendTabs(sb, --count);
                sb.append(ch);
                continue;
            }
            if (ch == ',') {
                sb.append(ch);
                sb.append('\n');
                StringUtils.appendTabs(sb, count);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static void appendTabs(StringBuilder sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append('\t');
        }
    }
}

