/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.string;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMappingCustomer selfMapper = new ObjectMappingCustomer();
    private static ObjectMappingCustomer dynamicSelfMapper = new ObjectMappingCustomer();

    private JsonUtils() {
    }

    public static String objToStr(Object obj) {
        return JsonUtils.objToStr(obj, false);
    }

    public static String objToStr(Object obj, boolean writeNull) {
        return JsonUtils.objToStr(obj, writeNull, false);
    }

    public static String objToStr(Object obj, boolean writeNull, boolean pretty) {
        try {
            if (writeNull) {
                if (pretty) {
                    return selfMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
                }
                return selfMapper.writeValueAsString(obj);
            }
            if (pretty) {
                return dynamicSelfMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return dynamicSelfMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("Error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T strToObj(String str, Class<T> claz) {
        return JsonUtils.strToObj(str, claz, false);
    }

    public static <T> T strToObj(String str, Class<T> claz, boolean writeNull) {
        try {
            return (T)(writeNull ? selfMapper.readValue(str, claz) : dynamicSelfMapper.readValue(str, claz));
        }
        catch (Exception e) {
            log.error("Error: {},{}", (Object)str, (Object)e.getMessage());
            return null;
        }
    }

    static {
        dynamicSelfMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        dynamicSelfMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        dynamicSelfMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    public static class ObjectMappingCustomer
    extends ObjectMapper {
        private static final long serialVersionUID = 1L;

        private ObjectMappingCustomer() {
            this.getSerializerProvider().setNullKeySerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    gen.writeString("");
                }
            });
            this.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    gen.writeString("");
                }
            });
        }
    }
}

