/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.string;

import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.MapHandler;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnumHandler {
    public static String toJson(Object object) {
        return JsonUtils.objToStr(EnumHandler.toMap(object));
    }

    public static String toJson(Object ... enums) {
        return JsonUtils.objToStr(EnumHandler.toList(enums));
    }

    public static Map toMap(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isEnum()) {
            return null;
        }
        List<Field> selfFields = EnumHandler.fetchSelfFields(clazz);
        return EnumHandler.fetchFieldValues(selfFields, object);
    }

    public static List<Map> toList(Object ... enums) {
        if (Objects.isNull(enums)) {
            return Lists.newArrayList();
        }
        if (enums.length == 0) {
            return Lists.newArrayList();
        }
        Class<?> clazz = enums[0].getClass();
        if (!clazz.isEnum()) {
            return Lists.newArrayList();
        }
        List<Field> selfFields = EnumHandler.fetchSelfFields(clazz);
        ArrayList jsons = Lists.newArrayList();
        for (Object item : enums) {
            jsons.add(EnumHandler.fetchFieldValues(selfFields, item));
        }
        return jsons;
    }

    private static List<Field> fetchSelfFields(Class<?> clazz) {
        List<Field> fields = ClassUtils.getAllFields(clazz);
        ArrayList selfFields = Lists.newArrayList();
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            selfFields.add(field);
        }
        return selfFields;
    }

    private static MapHandler fetchFieldValues(List<Field> selfFields, Object item) {
        MapHandler handler = MapHandler.build();
        for (Field field : selfFields) {
            String name = field.getName();
            Object value = ClassUtils.getValue(item, name);
            handler.add(name, value);
        }
        return handler;
    }

    private EnumHandler() {
    }
}

