/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.sort;

import com.bruce.tool.common.util.ClassUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.CollectionUtils;

public class SortUtils {
    public static <E> List<E> tree(List<E> entities, String idKey, String pidKey) {
        Integer rootId = 0;
        ConcurrentMap parents = Maps.newConcurrentMap();
        ConcurrentMap nodes = Maps.newConcurrentMap();
        for (Object entity : entities) {
            Integer n = (Integer)ClassUtils.getValue(entity, idKey);
            Integer pid = (Integer)ClassUtils.getValue(entity, pidKey);
            if (rootId > pid) {
                rootId = pid;
            }
            nodes.put(n, entity);
            List childrens = (List)parents.get(pid);
            if (CollectionUtils.isEmpty((Collection)childrens)) {
                childrens = Lists.newArrayList();
                parents.put(pid, childrens);
            }
            childrens.add(entity);
        }
        if (CollectionUtils.isEmpty((Map)nodes)) {
            return entities;
        }
        ArrayList rootNodes = Lists.newArrayList();
        for (Map.Entry entry : nodes.entrySet()) {
            Object entity = entry.getValue();
            Integer pid = (Integer)ClassUtils.getValue(entity, pidKey);
            if (!rootId.equals(pid)) continue;
            rootNodes.add(entity);
        }
        ArrayList sorted = Lists.newArrayList();
        SortUtils.recursion(parents, rootNodes, idKey, sorted);
        return sorted;
    }

    private static <E> void recursion(Map<Integer, List<E>> parents, List<E> childrens, String idKey, List<E> sorted) {
        if (CollectionUtils.isEmpty(childrens)) {
            return;
        }
        for (E children : childrens) {
            sorted.add(children);
            Integer id = (Integer)ClassUtils.getValue(children, idKey);
            SortUtils.recursion(parents, parents.get(id), idKey, sorted);
        }
    }

    private SortUtils() {
    }
}

