/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.regex;

import com.bruce.tool.common.util.regex.Regex;
import com.google.common.collect.Lists;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtils {
    private static final Pattern LEGAL_PATTERN = Pattern.compile("^[\\u4e00-\\u9fa5\\w\\d_.%@!\uff01\\[\\]\\\\|\\-,/,\\[\\]\\s\uff0c\u3002;\uff1b:\uff1a\u201c\u201d?\uff1f]+$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern USER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9]{4,20}$");
    private static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^1[345789]\\d{9}$");
    private static final Pattern ALPHA_NUM = Pattern.compile("^[a-zA-Z0-9]+$");
    private static final Pattern EMPTY = Pattern.compile("^\\s*$");

    public static boolean containChinese(String s) {
        Matcher matcher;
        return s != null && !s.isEmpty() && (matcher = Pattern.compile(Regex.CHINESE.getValue()).matcher(s)).find();
    }

    public static boolean containChinese(String s, int length) {
        if (RegexUtils.containChinese(s)) {
            return s.length() <= length;
        }
        return false;
    }

    public static boolean overLengthLimit(String s, int length) {
        if (s != null) {
            return s.length() > length;
        }
        return false;
    }

    public static boolean notContainChinese(String s) {
        return !RegexUtils.containChinese(s);
    }

    public static boolean notContainIllegalParameter(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        Matcher matcher = LEGAL_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static boolean onlyIntegerNumber(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        Matcher matcher = NUMBER_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static boolean isPhoneNumber(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        Matcher matcher = PHONE_NUMBER_PATTERN.matcher(s);
        return matcher.matches();
    }

    public static boolean isUserName(String un) {
        if (StringUtils.isBlank((CharSequence)un)) {
            return false;
        }
        Matcher matcher = USER_NAME_PATTERN.matcher(un);
        return matcher.matches();
    }

    public static boolean onlyAlphaNum(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        Matcher matcher = ALPHA_NUM.matcher(s);
        return matcher.matches();
    }

    public static boolean isEmpty(String s) {
        if (null == s) {
            return true;
        }
        return EMPTY.matcher(s).matches();
    }

    public static String urlDecode(String param) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)param) && StringUtils.isNotBlank((CharSequence)(result = URLDecoder.decode(param)))) {
            return result;
        }
        return param;
    }

    public static String urlEncode(String param) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)param) && StringUtils.isNotBlank((CharSequence)(result = URLEncoder.encode(param)))) {
            return result;
        }
        return param;
    }

    public static String urlEncodeOneByOne(String param) {
        String[] list = param.split("");
        StringBuilder result = new StringBuilder();
        for (String item : list) {
            if (RegexUtils.containChinese(item)) {
                result.append(RegexUtils.urlEncode(item));
                continue;
            }
            result.append(item);
        }
        return result.toString();
    }

    public static boolean containsOne(String string, String regex) {
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(string);
        Integer count = 0;
        while (m1.find()) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            if (count <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsMore(String string, String regex, Integer time) {
        if (time <= 0) {
            return false;
        }
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(string);
        Integer count = 0;
        do {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            if (count <= time) continue;
            return true;
        } while (m1.find());
        return false;
    }

    public static List<String> gatherStringCount(String content, String regex) {
        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(content);
        ArrayList colgroups = Lists.newArrayList();
        while (m1.find()) {
            for (int i = 0; i < m1.groupCount(); ++i) {
                String test1 = m1.group(i);
                colgroups.add(test1);
            }
        }
        return colgroups;
    }

    private RegexUtils() {
    }
}

