/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util.file;

import java.io.Closeable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger log = LoggerFactory.getLogger(IOUtils.class);

    public static void closeQuietly(Closeable ... closeables) {
        if (null != closeables && closeables.length > 0) {
            for (Closeable closeable : closeables) {
                try {
                    if (!Objects.nonNull(closeable)) continue;
                    closeable.close();
                }
                catch (Exception e) {
                    log.error("Error while closing", (Throwable)e);
                }
            }
        }
    }

    private IOUtils() {
    }
}

