/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util;

import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.common.util.string.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public class IPUtils {
    private static final String UNKNOWN = "unknown";
    private static final String LOCAL = "127.0.0.1";

    public static String local() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            ExceptionUtils.printStackTrace(e);
            return LOCAL;
        }
    }

    public static String request(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        if (StringUtils.isBlank((CharSequence)ipAddress)) {
            return ipAddress;
        }
        if (ipAddress.equals(LOCAL) || ipAddress.equals("0:0:0:0:0:0:0:1")) {
            ipAddress = IPUtils.local();
        }
        if (ipAddress.length() <= 15) {
            return ipAddress;
        }
        if (ipAddress.contains(",")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(44));
            return ipAddress;
        }
        return ipAddress;
    }

    private IPUtils() {
    }
}

