/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static DateTime create() {
        return DateTime.now();
    }

    public static DateTime create(long timestamp) {
        return new DateTime(timestamp);
    }

    public static String format(DateTime dateTime) {
        return DateUtils.format(dateTime, Parttern.FORMAT_YYMMDDHMS_MID);
    }

    public static String format(DateTime dateTime, Parttern fmt) {
        return dateTime.toString(DateUtils.getFormatter(fmt));
    }

    public static String format(DateTime dateTime, String format) {
        return dateTime.toString(DateUtils.getFormatter(format));
    }

    public static DateTime parse(String date) {
        return DateUtils.parse(date, Parttern.FORMAT_YYMMDDHMS_MID);
    }

    public static DateTime parse(String date, Parttern fmt) {
        return DateUtils.getFormatter(fmt).parseDateTime(date);
    }

    public static DateTime parse(String date, String format) {
        return DateUtils.getFormatter(format).parseDateTime(date);
    }

    public static DateTime addSeconds(DateTime dateTime, int seconds) {
        return dateTime.plusSeconds(seconds);
    }

    public static DateTime addMinutes(DateTime dateTime, int minutes) {
        return dateTime.plusMinutes(minutes);
    }

    public static DateTime addHours(DateTime dateTime, int hours) {
        return dateTime.plusHours(hours);
    }

    public static DateTime addDays(DateTime dateTime, int days) {
        return dateTime.plusDays(days);
    }

    public static DateTime addWeeks(DateTime dateTime, int weeks) {
        return dateTime.plusWeeks(weeks);
    }

    public static DateTime addMonths(DateTime dateTime, int months) {
        return dateTime.plusMonths(months);
    }

    public static DateTime addYears(DateTime dateTime, int years) {
        return dateTime.plusYears(years);
    }

    public static int getDayOfWeek(DateTime dateTime) {
        return dateTime.getDayOfWeek();
    }

    public static int getWeekOfYear(DateTime dateTime) {
        return dateTime.getWeekOfWeekyear();
    }

    public static DateTime getDayOfBegin(DateTime dateTime) {
        return dateTime.withTimeAtStartOfDay();
    }

    public static DateTime getDayOfEnd(DateTime dateTime) {
        return dateTime.millisOfDay().withMaximumValue();
    }

    public static DateTime getWeekOfBegin(DateTime dateTime) {
        return dateTime.dayOfWeek().withMinimumValue();
    }

    public static DateTime getWeekOfEnd(DateTime dateTime) {
        return dateTime.dayOfWeek().withMaximumValue();
    }

    public static DateTime getMonthOfBegin(DateTime dateTime) {
        return dateTime.dayOfMonth().withMinimumValue();
    }

    public static DateTime getMonthOfEnd(DateTime dateTime) {
        return dateTime.dayOfMonth().withMaximumValue();
    }

    public static DateTime getYearOfBegin(DateTime dateTime) {
        return dateTime.dayOfYear().withMinimumValue();
    }

    public static DateTime getYearOfEnd(DateTime dateTime) {
        return dateTime.dayOfYear().withMaximumValue();
    }

    public static int compare(DateTime left, DateTime right) {
        if (left.isBefore((ReadableInstant)right)) {
            return 1;
        }
        if (left.isEqual((ReadableInstant)right)) {
            return 0;
        }
        return -1;
    }

    public static boolean between(DateTime src, DateTime left, DateTime right) {
        return src.isAfter((ReadableInstant)left) && src.isBefore((ReadableInstant)right);
    }

    public static DateTime getHourOfBegin(DateTime dateTime) {
        return dateTime.hourOfDay().roundFloorCopy();
    }

    public static DateTime getMinuteOfBegin(DateTime dateTime) {
        return dateTime.minuteOfDay().roundFloorCopy();
    }

    public static DateTime getSecondOfBegin(DateTime dateTime) {
        return dateTime.secondOfDay().roundFloorCopy();
    }

    private static DateTimeFormatter getFormatter(Parttern fmt) {
        return DateTimeFormat.forPattern((String)fmt.getFmt());
    }

    private static DateTimeFormatter getFormatter(String format) {
        return DateTimeFormat.forPattern((String)format);
    }

    public static enum Parttern {
        FORMAT_YYMM("yyyy-MM"),
        FORMAT_YYWW("yyyy-ww"),
        FORMAT_YYMMDD("yyyy-MM-dd"),
        FORMAT_YYMMDDHM("yyyy-MM-dd HH:mm"),
        FORMAT_YYMMDDHMS("yyyy-MM-dd HH:mm:ss"),
        FORMAT_YYMMDDHMSS("yyyy-MM-dd HH:mm:ss SSS"),
        FORMAT_YYMMDDHM_GAP_SLASH("yyyy/MM/dd HH:mm"),
        FORMAT_YYMMDD2("yyyyMMdd"),
        FORMAT_YYMMDDHMS_NO_GAP("yyyyMMddHHmmss"),
        FORMAT_YYMM_MID("yyyy-MM"),
        FORMAT_YYWW_MID("yyyy-ww"),
        FORMAT_YYMMDD_MID("yyyy-MM-dd"),
        FORMAT_YYMMDDH_MID("yyyy-MM-dd HH"),
        FORMAT_YYMMDDHM_MID("yyyy-MM-dd HH:mm"),
        FORMAT_YYMMDDHMS_MID("yyyy-MM-dd HH:mm:ss"),
        FORMAT_YYMMDDHMSS_MID("yyyy-MM-dd HH:mm:ss SSS"),
        FORMAT_YYMM_NON("yyyyMM"),
        FORMAT_YYWW_NON("yyyyww"),
        FORMAT_YYMMDD_NON("yyyyMMdd"),
        FORMAT_YYMMDDH_NON("yyyyMMddHH"),
        FORMAT_YYMMDDHM_NON("yyyyMMddHHmm"),
        FORMAT_YYMMDDHMS_NON("yyyyMMddHHmmss"),
        FORMAT_YYMMDDHMSS_NON("yyyyMMddHHmmssSSS"),
        FORMAT_YYMM_SLASH("yy/yy/MM"),
        FORMAT_YYWW_SLASH("yyyy/ww"),
        FORMAT_YYMMDD_SLASH("yyyy/MM/dd"),
        FORMAT_YYMMDDH_SLASH("yyyy/MM/dd HH"),
        FORMAT_YYMMDDHM_SLASH("yyyy/MM/dd HH:mm"),
        FORMAT_YYMMDDHMS_SLASH("yyyy/MM/dd HH:mm:ss"),
        FORMAT_YYMMDDHMSS_SLASH("yyyy/MM/dd HH:mm:ss:SSS");

        private String fmt;

        private Parttern(String fmt) {
            this.fmt = fmt;
        }

        public String getFmt() {
            return this.fmt;
        }
    }
}

