/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.util;

import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.common.util.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtils;

public class ClassUtils {
    private static final String OBJECT_NAME = "java.lang.Object";
    private static final List<Class> baseClass = Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Short.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class, String.class, Date.class, Integer[].class, int[].class, Long[].class, long[].class, Short[].class, short[].class, Byte[].class, short[].class, Float[].class, float[].class, Double[].class, double[].class, BigDecimal[].class, String[].class, Map.class, Collection.class});
    private static final List<Class> numberClass = Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Short.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class});
    private static final List<Class> decimalClass = Lists.newArrayList((Object[])new Class[]{Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class});
    private static final List<Class> integerClass = Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Short.TYPE});
    private static final Map<String, Class> keyClass = Maps.newHashMap();

    public static boolean isBaseDataType(Class<?> clazz) {
        return baseClass.contains(clazz);
    }

    public static boolean isExtendDataType(Object data) {
        for (Class clazz : baseClass) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumberType(Class<?> clazz) {
        return numberClass.contains(clazz);
    }

    public static boolean isExtendNumberType(Object data) {
        for (Class clazz : numberClass) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecimalType(Class<?> clazz) {
        return decimalClass.contains(clazz);
    }

    public static boolean isExtendDecimalType(Object data) {
        for (Class clazz : decimalClass) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntegerType(Class<?> clazz) {
        return integerClass.contains(clazz);
    }

    public static boolean isExtendIntegerType(Object data) {
        for (Class clazz : integerClass) {
            if (!clazz.isInstance(data)) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Class superClass = clazz.getSuperclass(); null != superClass && !OBJECT_NAME.equalsIgnoreCase(superClass.getName()); superClass = superClass.getSuperclass()) {
            ClassUtils.getFields(superClass, fields);
        }
        return fields;
    }

    public static Method getMethod(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Class<?> getFieldType(Class clazz, String fieldName) {
        Field field = ClassUtils.getField(clazz, fieldName);
        if (Objects.nonNull(field)) {
            return field.getType();
        }
        return null;
    }

    public static Field getField(Class clazz, String fieldName) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static boolean hasField(Class clazz, String fieldName) {
        Field field = ClassUtils.getField(clazz, fieldName);
        return Objects.nonNull(field);
    }

    public static boolean hasField(Object data) {
        Field[] fields = data.getClass().getDeclaredFields();
        return fields.length > 0;
    }

    public static boolean setValue(Object entity, String fieldName, Object fieldValue) {
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)entity, (String)fieldName);
            Class<?> fieldType = propertyDescriptor.getPropertyType();
            fieldValue = ClassUtils.transfer(fieldType, fieldValue);
            PropertyUtils.setSimpleProperty((Object)entity, (String)fieldName, (Object)fieldValue);
            return true;
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
            return false;
        }
    }

    public static <E, V> V getValue(E entity, String fieldName) {
        Object id = null;
        try {
            id = Map.class.isInstance(entity) ? ((Map)entity).get(fieldName) : PropertyUtils.getSimpleProperty(entity, (String)fieldName);
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
        }
        return (V)id;
    }

    @Deprecated
    public static <E, V> V getValue(String fieldName, E entity) {
        return ClassUtils.getValue(entity, fieldName);
    }

    public static Class<?> getBaseClass(String simpleClassName) {
        return keyClass.get(simpleClassName);
    }

    private static void getFields(Class clazz, List<Field> fields) {
        if (null == clazz) {
            return;
        }
        if (OBJECT_NAME.equalsIgnoreCase(clazz.getSimpleName())) {
            return;
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
    }

    private static Object transfer(Class<?> fieldType, Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (fieldType.equals(Integer.class)) {
            return Integer.valueOf(value.toString());
        }
        if (fieldType.equals(Long.class)) {
            return Long.valueOf(value.toString());
        }
        if (fieldType.equals(Float.class)) {
            return Float.valueOf(value.toString());
        }
        if (fieldType.equals(Double.class)) {
            return Double.valueOf(value.toString());
        }
        if (fieldType.equals(Byte.class)) {
            return Byte.valueOf(value.toString());
        }
        if (fieldType.equals(Boolean.class)) {
            return Boolean.valueOf(value.toString());
        }
        if (fieldType.equals(String.class)) {
            return value;
        }
        if (fieldType.equals(BigDecimal.class)) {
            return new BigDecimal(value.toString());
        }
        if (fieldType.equals(Date.class)) {
            return DateUtils.format(DateUtils.create(((Date)value).getTime()), DateUtils.Parttern.FORMAT_YYMMDDHMS_MID);
        }
        return value;
    }

    private ClassUtils() {
    }

    static {
        for (Class clazz : baseClass) {
            keyClass.put(clazz.getSimpleName(), clazz);
            keyClass.put(clazz.getSimpleName().toLowerCase(), clazz);
        }
    }
}

