/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.exception;

import com.bruce.tool.common.exception.BaseResult;
import com.bruce.tool.common.exception.ErrorCode;
import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.regex.RegexUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public final class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public static ModelAndView printErrorInfo(Throwable ex) {
        ExceptionUtils.printStackTrace(ex);
        BaseResult result = ExceptionUtils.gatherErrorInfos(ex);
        ModelAndView mav = new ModelAndView();
        mav.addObject("code", result.getCode());
        mav.addObject("message", (Object)result.getMessage());
        mav.setView((View)new MappingJackson2JsonView());
        return mav;
    }

    public static BaseResult printErrorInfos(Throwable ex) {
        ExceptionUtils.printStackTrace(ex);
        return ExceptionUtils.gatherErrorInfos(ex);
    }

    private static BaseResult gatherErrorInfos(Throwable ex) {
        BaseResult result = new BaseResult();
        if (ex instanceof DuplicateKeyException) {
            ExceptionUtils.handleDuplicateKeyInfo(ex, result);
        } else if (ex instanceof MethodArgumentTypeMismatchException) {
            ExceptionUtils.handleArumentTypeExceptionInfo(ex, result);
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            ExceptionUtils.handleRequestMethodExceptionInfo(ex, result);
        } else if (ex instanceof UncategorizedSQLException) {
            ExceptionUtils.handleSQLExceptionInfo(ex, result);
        } else if (ex instanceof MissingServletRequestParameterException) {
            ExceptionUtils.handleRequiredBindException(ex, result);
        } else if (ex instanceof MissingPathVariableException) {
            ExceptionUtils.handleRequiredPathException(ex, result);
        } else if (ex instanceof MethodArgumentNotValidException) {
            ExceptionUtils.handleMethodBindException(ex, result);
        } else if (ex instanceof BindException) {
            ExceptionUtils.handleBindException(ex, result);
        } else {
            ExceptionUtils.handleBusinessExceptionInfo(ex, result);
        }
        return result;
    }

    public static void printStackTrace(Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(out);
        e.printStackTrace(pout);
        String sw = new String(out.toByteArray());
        pout.close();
        try {
            out.close();
        }
        catch (Exception ex) {
            log.error("{}", (Throwable)ex);
        }
        log.error(sw);
    }

    private static void handleDuplicateKeyInfo(Throwable ex, BaseResult result) {
        DuplicateKeyException unique = (DuplicateKeyException)ex;
        Throwable throwable = unique.getCause();
        if (throwable instanceof SQLIntegrityConstraintViolationException) {
            ExceptionUtils.handleConstraintViolationInfo(throwable, result);
        }
    }

    private static void handleConstraintViolationInfo(Throwable ex, BaseResult result) {
        SQLIntegrityConstraintViolationException unique = (SQLIntegrityConstraintViolationException)ex;
        String message = unique.getMessage();
        if (message.contains("Duplicate")) {
            message = "\u8fdd\u53cd\u6570\u636e\u5e93\u552f\u4e00\u7d22\u5f15\u7ea6\u675f";
        }
        result.setCode(ErrorCode.SQL_UNIQUE_KEY_ERROR.getCode());
        result.setMessage(message);
    }

    private static void handleArumentTypeExceptionInfo(Throwable ex, BaseResult result) {
        MethodArgumentTypeMismatchException argumentTypeException = (MethodArgumentTypeMismatchException)ex;
        result.setCode(ErrorCode.REQUEST_PARAM_TYPE_ERROR.getCode());
        Class requiredType = argumentTypeException.getRequiredType();
        String message = "\u53c2\u6570\u7c7b\u578b\u9519\u8bef:" + argumentTypeException.getName() + "(" + (null != requiredType ? requiredType.getName() : "null") + "),\u5b9e\u9645\u7684\u4f20\u5165\u503c\u4e3a:" + argumentTypeException.getValue();
        result.setMessage(message);
    }

    private static void handleRequestMethodExceptionInfo(Throwable ex, BaseResult result) {
        HttpRequestMethodNotSupportedException methodException = (HttpRequestMethodNotSupportedException)ex;
        result.setCode(ErrorCode.REQUEST_METHOD_ERROR.getCode());
        String message = "\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301" + methodException.getMethod() + "\u8bf7\u6c42";
        result.setMessage(message);
    }

    private static void handleSQLExceptionInfo(Throwable ex, BaseResult mav) {
        UncategorizedSQLException e = (UncategorizedSQLException)ex;
        String msg = e.getMessage();
        if (!com.bruce.tool.common.util.string.StringUtils.isEmpty((CharSequence)msg) && msg.contains("Incorrect string value: '\\x")) {
            mav.setCode(ErrorCode.MYSQL_EMOJI_UNSUPPORT_CODE.getCode());
            mav.setMessage(ErrorCode.MYSQL_EMOJI_UNSUPPORT_CODE.getMessage());
        } else {
            ExceptionUtils.handleUnExpectedExceptionInfo(ex, mav);
        }
    }

    private static void handleRequiredBindException(Throwable ex, BaseResult mav) {
        MissingServletRequestParameterException bindException = (MissingServletRequestParameterException)ex;
        mav.setCode(ErrorCode.FORM_VALID_ERROR.getCode());
        String message = "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570:" + bindException.getParameterName();
        mav.setMessage(message);
    }

    private static void handleRequiredPathException(Throwable ex, BaseResult mav) {
        MissingPathVariableException pathVariableException = (MissingPathVariableException)ex;
        mav.setCode(ErrorCode.FORM_VALID_ERROR.getCode());
        String message = "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570:" + pathVariableException.getVariableName();
        mav.setMessage(message);
    }

    private static void handleMethodBindException(Throwable ex, BaseResult mav) {
        MethodArgumentNotValidException bindException = (MethodArgumentNotValidException)ex;
        ExceptionUtils.handleBindError(mav, bindException.getBindingResult());
    }

    private static void handleBindException(Throwable ex, BaseResult mav) {
        BindException bindException = (BindException)ex;
        ExceptionUtils.handleBindError(mav, bindException.getBindingResult());
    }

    private static void handleBindError(BaseResult mav, BindingResult br) {
        if (br.hasFieldErrors()) {
            FieldError fieldError = br.getFieldError();
            if (null != fieldError && StringUtils.isNotBlank((CharSequence)fieldError.getDefaultMessage())) {
                String error = fieldError.getDefaultMessage();
                mav.setMessage(error);
            } else {
                mav.setMessage(ErrorCode.FORM_VALID_ERROR.getMessage());
            }
            mav.setCode(ErrorCode.FORM_VALID_ERROR.getCode());
        }
    }

    private static void handleBusinessExceptionInfo(Throwable ex, BaseResult mav) {
        Object code = null;
        Method method = ClassUtils.getMethod(ex.getClass(), "getCode");
        try {
            if (Objects.nonNull(method)) {
                code = method.invoke((Object)ex, new Object[0]);
            }
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
        }
        if (Objects.isNull(code)) {
            ExceptionUtils.handleUnExpectedExceptionInfo(ex, mav);
        } else {
            mav.setCode(code);
            ExceptionUtils.setMessage(ex, mav);
            ExceptionUtils.setData(ex, mav);
        }
    }

    private static void handleUnExpectedExceptionInfo(Throwable ex, BaseResult mav) {
        mav.setCode(ErrorCode.SYSTEM_ERROR.getCode());
        String message = ex.getMessage();
        Throwable cause = ex.getCause();
        if (Objects.nonNull(cause)) {
            message = ex.getCause().getMessage();
        }
        if (com.bruce.tool.common.util.string.StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (RegexUtils.containChinese(message)) {
            mav.setMessage(message);
        } else {
            mav.setMessage(ErrorCode.SYSTEM_ERROR.getMessage());
        }
    }

    private static void setMessage(Throwable ex, BaseResult mav) {
        Object message = null;
        Method method = ClassUtils.getMethod(ex.getClass(), "getMessage");
        try {
            if (Objects.nonNull(method)) {
                message = method.invoke((Object)ex, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        if (Objects.nonNull(message)) {
            mav.setMessage(String.valueOf(message));
        }
    }

    private static void setData(Throwable ex, BaseResult mav) {
        Object data = null;
        Method method = ClassUtils.getMethod(ex.getClass(), "getData");
        try {
            if (Objects.nonNull(method)) {
                data = method.invoke((Object)ex, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        if (Objects.nonNull(data)) {
            mav.setData(data);
        }
    }

    private ExceptionUtils() {
    }
}

