/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.exception;

import com.bruce.tool.common.exception.I18N;

public enum ErrorCode {
    SYSTEM_ERROR("9999", "\u7f51\u7edc\u5f02\u5e38", "network error"),
    FORM_VALID_ERROR("9998", "\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", "form param valid error"),
    URL_IS_NULL("9997", "\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a", "request url is null"),
    REQUEST_METHOD_ERROR("9996", "\u8bf7\u6c42\u65b9\u6cd5\u9519\u8bef", "request method error"),
    REQUEST_PARAM_TYPE_ERROR("9995", "\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u9519\u8bef", "request argument type error"),
    SQL_UNIQUE_KEY_ERROR("9994", "\u8fdd\u53cd\u6570\u636e\u5e93\u552f\u4e00\u7ea6\u675f", "unique index error"),
    MYSQL_EMOJI_UNSUPPORT_CODE("0004", "\u6682\u4e0d\u652f\u6301\u8868\u60c5\u7b26\u53f7\u8f93\u5165\uff0c\u8bf7\u5220\u9664\u8868\u60c5\u518d\u8bd5", "emoji not support error"),
    RUNNING("0005", "\u4efb\u52a1\u6392\u961f\u6267\u884c\u4e2d,\u8bf7\u8010\u5fc3\u7b49\u5f85", "be queuing"),
    RESUBMIT("0006", "\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41,\u8bf7\u7a0d\u540e\u518d\u8bd5", "too frequently"),
    EXPORT_NO_RECORD("0007", "\u6ca1\u6709\u8bb0\u5f55\u53ef\u4ee5\u5bfc\u51fa", "no record"),
    EXPORT_NO_TOO_MORE("0008", "\u672c\u6b21\u5bfc\u51fa\u8bf7\u6c42\u8d85\u8fc720000\u6761\u6570\u636e\uff0c\u6bcf\u6b21\u6700\u591a\u5141\u8bb8\u5bfc\u51fa20000\u6761\u6570\u636e\uff01", "more than 20000");

    private String code;
    private String message;
    private String messageENUS;

    public static String getMessageByCode(String code, I18N i18N) {
        ErrorCode target = ErrorCode.search(code);
        if (null == target) {
            return "";
        }
        return ErrorCode.getMessageByLanguage(i18N, target.getMessage(), target.getMessageENUS());
    }

    public static ErrorCode search(String code) {
        ErrorCode target = null;
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!errorCode.getCode().equals(code)) continue;
            target = errorCode;
        }
        return target;
    }

    public static String getMessageByLanguage(I18N i18N, String ... messages) {
        I18N[] ns = I18N.values();
        Integer size = messages.length;
        String message = messages[0];
        int length = ns.length;
        for (int i = 0; i < length; ++i) {
            if (!i18N.equals((Object)ns[i])) continue;
            message = i < size - 1 ? messages[i] : messages[0];
        }
        return message;
    }

    private ErrorCode(String code, String message, String messageENUS) {
        this.code = code;
        this.message = message;
        this.messageENUS = messageENUS;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageENUS() {
        return this.messageENUS;
    }
}

