/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.common.arithmetic;

import com.bruce.tool.common.arithmetic.Base64;
import com.bruce.tool.common.exception.ExceptionUtils;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA {
    private static final Logger log = LoggerFactory.getLogger(RSA.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final String RSA_SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static KeyPair init() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
            return null;
        }
    }

    public static String publicKey(KeyPair keyPair) {
        if (Objects.isNull(keyPair)) {
            return null;
        }
        return Base64.encode(keyPair.getPublic().getEncoded());
    }

    public static String privateKey(KeyPair keyPair) {
        if (Objects.isNull(keyPair)) {
            return null;
        }
        return Base64.encode(keyPair.getPrivate().getEncoded());
    }

    public static byte[] encrypt(byte[] data, String base64PublicKey) {
        try {
            byte[] keyBytes = Base64.decode(base64PublicKey);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
            return new byte[0];
        }
    }

    public static byte[] decrypt(byte[] data, String base64PrivateKey) {
        try {
            byte[] keyBytes = Base64.decode(base64PrivateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
            return new byte[0];
        }
    }

    public static byte[] sign(byte[] data, String base64PrivateKey) {
        try {
            byte[] bytes = Base64.decode(base64PrivateKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance(RSA_SIGNATURE_ALGORITHM);
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
            return new byte[0];
        }
    }

    public static boolean verify(byte[] data, String base64PublicKey, String sign) {
        try {
            byte[] bytes = Base64.decode(base64PublicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(RSA_SIGNATURE_ALGORITHM);
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(Base64.decode(sign));
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace(e);
            return false;
        }
    }

    private RSA() {
    }
}

