package com.bruce.tool.common.util.string;

import com.bruce.tool.common.exception.ExceptionUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 功能 :
 *
 * @author : Bruce(刘正航) 上午11:54 2018/1/19
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils{

    public static final String DEFAULT_SEPERATOR = ",";
    public static final String SEPERATOR_COMMA = DEFAULT_SEPERATOR;
    public static final String SEPERATOR_VERTICAL_BAR = "\\|";
    public static final String SEPERATOR_SEMICOLON = ";";


    /**指定分割付的字符串,转换为list**/
    public static List<String> splitToList(String source){
        return splitToList(source,DEFAULT_SEPERATOR);
    }

    /**指定分割付的字符串,转换为list**/
    public static List<String> splitToList(String source,String seperator){
        if(null == seperator){
            seperator = DEFAULT_SEPERATOR;
        }
        if( StringUtils.isBlank(source) ){
            return Lists.newArrayList();
        }
        return Splitter.on(seperator).trimResults().splitToList(source);
    }

    /**unicode字符转换**/
    public static String unicode2str(String unicode){
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(unicode);
        char ch;
        while (matcher.find()) {
            //group 6728
            String group = matcher.group(2);
            //ch:'木' 26408
            ch = (char) Integer.parseInt(group, 16);
            //group1 \u6728
            String group1 = matcher.group(1);
            unicode = unicode.replace(group1, ch + "");
        }
        return unicode;
    }

    public static String str2Unicode(String string){
        try {
            StringBuffer out = new StringBuffer();
            //直接获取字符串的unicode二进制
            byte[] bytes = string.getBytes("unicode");
            //然后将其byte转换成对应的16进制表示即可
            for (int i = 0; i < bytes.length - 1; i += 2) {
                out.append("\\u");
                String str = Integer.toHexString(bytes[i + 1] & 0xff);
                for (int j = str.length(); j < 2; j++) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xff);
                out.append(str1);
                out.append(str);
            }
            return out.toString();
        } catch (UnsupportedEncodingException e) {
            ExceptionUtils.printStackTrace(e);
        }
        return null;
    }

    /**通过正则,获取匹配的结果集**/
    public static List<String> fetchMatchs(String ratesInfo,String regex) {
        List<String> colgroups = new ArrayList<>();

        Pattern p1 = Pattern.compile(regex);
        Matcher m1 = p1.matcher(ratesInfo);

        while (m1.find()) {
            for (int i = 0; i < m1.groupCount(); i++) {
                String test1 = m1.group(i);
                colgroups.add(test1);
            }
        }
        return colgroups;
    }

    /**字符串格式化**/
    public static String formatJson(String content) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int count = 0;
        while(index < content.length()){
            char ch = content.charAt(index);
            if(ch == '{' || ch == '['){
                sb.append(ch);
                sb.append('\n');
                count++;
                appendTabs(sb, count);
            }
            else if(ch == '}' || ch == ']'){
                sb.append('\n');
                count--;
                appendTabs(sb, count);
                sb.append(ch);
            }
            else if(ch == ','){
                sb.append(ch);
                sb.append('\n');
                appendTabs(sb, count);
            }
            else {
                sb.append(ch);
            }
            index ++;
        }
        return sb.toString();
    }

    /**追加tab键**/
    private static void appendTabs(StringBuilder sb, int count) {
        for (int i = 0; i < count; i++) {
            sb.append('\t');
        }
    }

}
