package com.bruce.tool.common.util.sort;

import com.bruce.tool.common.util.ClassUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 功能 :
 * 排序工具类
 * @author : Bruce(刘正航) 23:51 2019-01-09
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class SortUtils {

    public static <E> List<E> tree(List<E> entities,String idKey,String pidKey) {
        Integer rootId = 0;
        Map<Integer,List<E>> parents = Maps.newConcurrentMap();
        Map<Integer,E> nodes = Maps.newConcurrentMap();
        for (E entity : entities) {
            Integer id = ClassUtils.getValue(entity,idKey);
            Integer pid = ClassUtils.getValue(entity,pidKey);
            if( rootId > pid ){ rootId = pid;}
            nodes.put(id,entity);
            List<E> childrens = parents.get(pid);
            if(CollectionUtils.isEmpty(childrens) ){
                childrens = Lists.newArrayList();
                parents.put(pid,childrens);
            }
            childrens.add(entity);
        }

        if( CollectionUtils.isEmpty(nodes) ){ return entities; } // 结束排序

        List<E> rootNodes = Lists.newArrayList();
        for (Map.Entry<Integer,E> entry : nodes.entrySet()) {
            E entity = entry.getValue();
            Integer pid = ClassUtils.getValue(entity,pidKey);
            if( rootId.equals(pid) ){
                rootNodes.add(entity);
            }
        }

        List<E> sorted = Lists.newArrayList();
        recursion(parents,rootNodes,idKey,sorted);
        return sorted;
    }

    /**递归**/
    private static <E> void recursion(Map<Integer, List<E>> parents, List<E> childrens, String idKey, List<E> sorted){
        if( CollectionUtils.isEmpty(childrens) ){ return; }
        for (E children : childrens) {
            sorted.add(children);
            Integer id = ClassUtils.getValue(children,idKey);
            recursion(parents,parents.get(id),idKey, sorted);
        }
    }

}
