package com.bruce.tool.common.util.regex;

import lombok.Getter;

/**
 * 功能 :
 * 正则表达式工具类
 * 1.数字
 * 2.中文
 * 3.
 * @author : Bruce(刘正航) 10:06 PM 2019/1/1
 */
public enum Regex {
    // 正则表达式
    CHINESE("中文正则","[\\u4e00-\\u9fa5]"),
    ALPHA_NUM("字母正则","^[a-zA-Z0-9]+$"),
    USER_NAME_ONE("8~16位字符，至少包含数字、字母（区分大小写）、特殊符号中的2种，且不能以数字开头",
            "^(?![0-9]+)(?![a-z]+$)(?![A-Z]+$)(?!([^(0-9a-zA-Z)]|[\\(\\)])+$)([^(0-9a-zA-Z)]|[\\(\\)]|[a-z]|[A-Z]|[0-9]){8,16}$"),
    ;
    @Getter
    private String name;
    @Getter
    private String value;

    Regex(String name, String value) {
        this.name = name;
        this.value = value;
    }
}
