/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.address.mysql.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.pagehelper.PageInterceptor;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@MapperScan(basePackages={"com.bruce.tool.address.mysql.domain"}, sqlSessionFactoryRef="addressSqlSessionFactory")
@EnableTransactionManagement
public class AddressConfig {
    @Bean
    @ConfigurationProperties(prefix="datasource.address")
    public Properties addressDataSourceProperties() {
        return new Properties();
    }

    @Bean
    public DataSource addressDataSource(@Autowired @Qualifier(value="addressDataSourceProperties") Properties properties) throws SQLException {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDbType(properties.getProperty("dbType"));
        dataSource.setUsername(properties.getProperty("username"));
        dataSource.setPassword(properties.get("password").toString());
        dataSource.setUrl(properties.getProperty("url"));
        dataSource.setDriverClassName(properties.getProperty("driver-class-name"));
        dataSource.setMaxActive(Integer.valueOf(properties.getProperty("maxActive")).intValue());
        dataSource.setMinIdle(Integer.valueOf(properties.getProperty("minIdle")).intValue());
        dataSource.setInitialSize(Integer.valueOf(properties.getProperty("initialSize")).intValue());
        dataSource.setMaxWait((long)Integer.valueOf(properties.getProperty("maxWait")).intValue());
        return dataSource;
    }

    @Bean
    public SqlSessionFactory addressSqlSessionFactory(@Qualifier(value="addressDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        PageInterceptor pageHelper = new PageInterceptor();
        Properties props = new Properties();
        props.setProperty("helperDialect", "mysql");
        props.setProperty("reasonable", "true");
        props.setProperty("supportMethodsArguments", "true");
        props.setProperty("returnPageInfo", "check");
        props.setProperty("params", "count=countSql");
        pageHelper.setProperties(props);
        bean.setPlugins(new Interceptor[]{pageHelper});
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(configuration);
        return bean.getObject();
    }

    @Bean
    public SqlSessionTemplate addressSqlSessionTemplate(@Qualifier(value="addressSqlSessionFactory") SqlSessionFactory sessionFactory) {
        return new SqlSessionTemplate(sessionFactory);
    }
}

