package com.bruce.tool.address.mysql.mapper;

import com.bruce.tool.address.mysql.domain.Region;
import com.bruce.tool.mybatis.orm.mapper.BaseMapper;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 包含5级的地址,数据量在30万左右.
 * 包含4级的地址,数据量在3万左右.
 * 包含3级的地址,数据量在3000左右.
 * 地址相关的基本查询方法
 * 1.查询所有的Province
 * 2.根据provinceCode,查询所有的city
 * 3.根据cityCode,查询所有的county
 * 4.根据countyCode,查询所有的town
 * 5.根据town查询所有的street
 */
@Mapper
@Component
public interface RegionMapper extends BaseMapper<Region> {

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where `level`=1")
    List<Region> findProvinces();

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where `level`=2")
    List<Region> findCities();

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where `level`=3")
    List<Region> findCounties();

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where `level`=4")
    List<Region> findTowns();

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where `level`=5")
    List<Region> findStreets();

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where pcode=#{provinceCode}")
    List<Region> findCitiesByProvinceCode(@Param("provinceCode") String provinceCode);

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where pcode=#{cityCode}")
    List<Region> findCountiesByCityCode(@Param("cityCode") String cityCode);

    @Select(" select `id`,`level`,`is_direct`,`pcode`,`code`,`name`,`href`,`referer`,`longitude`,`latitude` "
            + "from global_region where pcode=#{cityCode}")
    List<Region> findRegionsByPcode(@Param("regionCode") String regionCode);
    /**重庆市-对应的县,调整到市区下边**/
    @Update(" update global_region set pcode = '500100000000' where pcode = '500200000000' ")
    Integer updateDirectInfo();
    /**重庆市-删除县级节点**/
    @Delete(" delete from global_region where code = '500200000000' ")
    Integer deleteDirectInfo();
}