/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.swagger.autoconfigure;

import com.battcn.boot.swagger.configuration.SwaggerBeanValidatorPluginsConfiguration;
import com.battcn.boot.swagger.configuration.SwaggerSecurityFilterPluginsConfiguration;
import com.battcn.boot.swagger.properties.SwaggerProperties;
import com.battcn.boot.swagger.properties.SwaggerSecurityProperties;
import com.battcn.boot.swagger.security.GlobalAccess;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;

@Configuration
@ConditionalOnProperty(name={"spring.swagger.enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={Swagger2DocumentationConfiguration.class, SwaggerBeanValidatorPluginsConfiguration.class})
@EnableConfigurationProperties(value={SwaggerProperties.class, SwaggerSecurityProperties.class})
public class SwaggerAutoConfiguration
implements BeanFactoryAware {
    private static final String DEFAULT_GROUP_NAME = "default";
    private static final String BASE_PATH = "/**";
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.swagger.enabled"}, havingValue="true")
    @ConditionalOnExpression(value="'${spring.swagger.security.filter-plugin}'=='true' || '${spring.swagger.security.filterPlugin}'=='true'")
    public FilterRegistrationBean<SwaggerSecurityFilterPluginsConfiguration> someFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SwaggerSecurityFilterPluginsConfiguration());
        registration.addUrlPatterns(new String[]{"/v2/api-docs", "/swagger-resources"});
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public GlobalAccess globalAccess(SwaggerProperties swaggerProperties) {
        return new GlobalAccess(swaggerProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public List<Docket> createRestApi(SwaggerProperties swaggerProperties, GlobalAccess globalAccess) {
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        LinkedList<Docket> docketList = new LinkedList<Docket>();
        if (swaggerProperties.getGroups().size() == 0) {
            ApiInfo apiInfo = new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).version(swaggerProperties.getVersion()).license(swaggerProperties.getLicense()).licenseUrl(swaggerProperties.getLicenseUrl()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).build();
            if (swaggerProperties.getBasePath().isEmpty()) {
                swaggerProperties.getBasePath().add(BASE_PATH);
            }
            List basePath = swaggerProperties.getBasePath().stream().map(PathSelectors::ant).collect(Collectors.toList());
            ArrayList excludePath = Lists.newArrayList();
            for (String path : swaggerProperties.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).globalOperationParameters(this.buildGlobalOperationParameters(swaggerProperties.getGlobalOperationParameters())).select().apis(RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or((Iterable)excludePath)), (Predicate)Predicates.or(basePath))).build();
            if (!CollectionUtils.isEmpty(swaggerProperties.getGlobalResponseMessages())) {
                this.buildGlobalResponseMessage(swaggerProperties, docket);
            }
            if (Objects.nonNull(swaggerProperties.getApiKey())) {
                docket.securitySchemes((List)Lists.newArrayList((Object[])new ApiKey[]{globalAccess.apiKey()})).securityContexts((List)Lists.newArrayList((Object[])new SecurityContext[]{globalAccess.securityContext()}));
            }
            configurableBeanFactory.registerSingleton(DEFAULT_GROUP_NAME, (Object)docket);
            docketList.add(docket);
            return docketList;
        }
        for (String groupName : swaggerProperties.getGroups().keySet()) {
            SwaggerProperties.GroupInfo groupInfo = swaggerProperties.getGroups().get(groupName);
            SwaggerProperties.Contact contact = groupInfo.getContact();
            ApiInfo apiInfo = new ApiInfoBuilder().title(SwaggerAutoConfiguration.defaultString(groupInfo.getTitle(), swaggerProperties.getTitle())).description(SwaggerAutoConfiguration.defaultString(groupInfo.getDescription(), swaggerProperties.getDescription())).version(SwaggerAutoConfiguration.defaultString(groupInfo.getVersion(), swaggerProperties.getVersion())).license(SwaggerAutoConfiguration.defaultString(groupInfo.getLicense(), swaggerProperties.getLicense())).licenseUrl(SwaggerAutoConfiguration.defaultString(groupInfo.getLicenseUrl(), swaggerProperties.getLicenseUrl())).contact(new Contact(SwaggerAutoConfiguration.defaultString(contact.getName(), swaggerProperties.getContact().getName()), SwaggerAutoConfiguration.defaultString(contact.getUrl(), swaggerProperties.getContact().getUrl()), SwaggerAutoConfiguration.defaultString(contact.getEmail(), swaggerProperties.getContact().getEmail()))).termsOfServiceUrl(SwaggerAutoConfiguration.defaultString(groupInfo.getTermsOfServiceUrl(), swaggerProperties.getTermsOfServiceUrl())).build();
            if (groupInfo.getBasePath().isEmpty()) {
                groupInfo.getBasePath().add(BASE_PATH);
            }
            List basePath = groupInfo.getBasePath().stream().map(PathSelectors::ant).collect(Collectors.toList());
            ArrayList excludePath = Lists.newArrayList();
            for (String path : groupInfo.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).globalOperationParameters(this.assemblyGlobalOperationParameters(swaggerProperties.getGlobalOperationParameters(), groupInfo.getGlobalOperationParameters())).groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)groupInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or((Iterable)excludePath)), (Predicate)Predicates.or(basePath))).build();
            if (!CollectionUtils.isEmpty(swaggerProperties.getGlobalResponseMessages())) {
                this.buildGlobalResponseMessage(swaggerProperties, docket);
            }
            if (Objects.nonNull(swaggerProperties.getApiKey())) {
                docket.securitySchemes((List)Lists.newArrayList((Object[])new ApiKey[]{globalAccess.apiKey()})).securityContexts((List)Lists.newArrayList((Object[])new SecurityContext[]{globalAccess.securityContext()}));
            }
            configurableBeanFactory.registerSingleton(groupName, (Object)docket);
            docketList.add(docket);
        }
        return docketList;
    }

    private void buildGlobalResponseMessage(SwaggerProperties swaggerProperties, Docket docket) {
        Map<RequestMethod, List<SwaggerProperties.ResponseMessageBody>> responseMessages = swaggerProperties.getGlobalResponseMessages();
        Set<RequestMethod> methods = responseMessages.keySet();
        for (RequestMethod method : methods) {
            List<SwaggerProperties.ResponseMessageBody> responseMessageBodies = responseMessages.get(method);
            List messages = responseMessageBodies.stream().map(my -> {
                ResponseMessageBuilder builder = new ResponseMessageBuilder().code(my.getCode()).message(my.getMessage());
                if (!StringUtils.isEmpty((Object)my.getModelRef())) {
                    builder.responseModel((ModelReference)new ModelRef(my.getModelRef()));
                }
                return builder.build();
            }).collect(Collectors.toList());
            docket.globalResponseMessage(method, messages);
        }
    }

    private List<Parameter> buildGlobalOperationParameters(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters) {
        if (Objects.isNull(globalOperationParameters)) {
            return Lists.newArrayList();
        }
        return globalOperationParameters.stream().map(globalOperationParameter -> new ParameterBuilder().name(globalOperationParameter.getName()).description(globalOperationParameter.getDescription()).modelRef((ModelReference)new ModelRef(globalOperationParameter.getModelRef())).parameterType(globalOperationParameter.getParameterType()).required(globalOperationParameter.getRequired().booleanValue()).build()).collect(Collectors.toList());
    }

    private List<Parameter> assemblyGlobalOperationParameters(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters, List<SwaggerProperties.GlobalOperationParameter> groupOperationParameters) {
        if (CollectionUtils.isEmpty(groupOperationParameters)) {
            return this.buildGlobalOperationParameters(globalOperationParameters);
        }
        if (CollectionUtils.isEmpty(globalOperationParameters)) {
            return this.buildGlobalOperationParameters(groupOperationParameters);
        }
        Set groupNames = groupOperationParameters.stream().map(SwaggerProperties.GlobalOperationParameter::getName).collect(Collectors.toSet());
        List<SwaggerProperties.GlobalOperationParameter> resultOperationParameters = globalOperationParameters.stream().filter(parameter -> !groupNames.contains(parameter.getName())).collect(Collectors.toList());
        resultOperationParameters.addAll(groupOperationParameters);
        return this.buildGlobalOperationParameters(resultOperationParameters);
    }

    private static String defaultString(String str, String defaultStr) {
        return str == null || Objects.equals(str.trim(), "") || str.length() == 0 ? defaultStr : str;
    }
}

