/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.nio;

import com.barchart.udt.EpollUDT;
import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.OptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.KindUDT;
import com.barchart.udt.nio.SelectorUDT;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionKeyUDT
extends SelectionKey
implements Comparable<SelectionKeyUDT> {
    protected static final int HAS_READ = 17;
    protected static final int HAS_WRITE = 12;
    protected static final Logger log = LoggerFactory.getLogger(SelectionKeyUDT.class);
    private final ChannelUDT channelUDT;
    private volatile EpollUDT.Opt epollOpt;
    private volatile int interestOps;
    private volatile boolean isValid;
    private volatile int readyOps;
    private volatile int resultIndex;
    private final SelectorUDT selectorUDT;

    protected static EpollUDT.Opt from(int interestOps) {
        boolean hasWrite;
        boolean hasRead = (interestOps & 0x11) != 0;
        boolean bl = hasWrite = (interestOps & 0xC) != 0;
        if (hasRead && hasWrite) {
            return EpollUDT.Opt.ALL;
        }
        if (hasRead) {
            return EpollUDT.Opt.ERROR_READ;
        }
        if (hasWrite) {
            return EpollUDT.Opt.ERROR_WRITE;
        }
        return EpollUDT.Opt.ERROR;
    }

    public static final String toStringOps(int selectOps) {
        char A = (0x10 & selectOps) != 0 ? (char)'A' : '-';
        char C = (8 & selectOps) != 0 ? (char)'C' : '-';
        char R = (1 & selectOps) != 0 ? (char)'R' : '-';
        char W = (4 & selectOps) != 0 ? (char)'W' : '-';
        return String.format("%c%c%c%c", Character.valueOf(A), Character.valueOf(C), Character.valueOf(R), Character.valueOf(W));
    }

    protected SelectionKeyUDT(SelectorUDT selectorUDT, ChannelUDT channelUDT, Object attachment) {
        super.attach(attachment);
        this.selectorUDT = selectorUDT;
        this.channelUDT = channelUDT;
        this.makeValid(true);
    }

    protected void assertValidKey() throws CancelledKeyException {
        if (this.isValid()) {
            return;
        }
        throw new CancelledKeyException();
    }

    protected void assertValidOps(int interestOps) {
        if ((interestOps & ~this.channel().validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps=" + interestOps);
        }
    }

    @Override
    public void cancel() {
        if (this.isValid()) {
            this.selector().cancel(this);
        }
    }

    @Override
    public SelectableChannel channel() {
        return (SelectableChannel)((Object)this.channelUDT);
    }

    protected ChannelUDT channelUDT() {
        return this.channelUDT;
    }

    @Override
    public int compareTo(SelectionKeyUDT that) {
        int thatId;
        int thisId = this.socketId();
        if (thisId > (thatId = that.socketId())) {
            return 1;
        }
        if (thisId < thatId) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRead(int resultIndex) {
        int readyOps = 0;
        int interestOps = this.interestOps;
        this.resultIndex = resultIndex;
        try {
            if (!this.epollOpt.hasRead()) {
                if (this.isSocketBroken()) {
                    readyOps = this.channel().validOps();
                    boolean bl = true;
                    return bl;
                }
                this.logError("Unexpected error report.");
                boolean bl = false;
                return bl;
            }
            switch (this.kindUDT()) {
                case ACCEPTOR: {
                    if ((interestOps & 0x10) != 0) {
                        readyOps = 16;
                        boolean bl = true;
                        return bl;
                    }
                    this.logError("Ready to ACCEPT while not interested.");
                    boolean bl = false;
                    return bl;
                }
                case CONNECTOR: 
                case RENDEZVOUS: {
                    if ((interestOps & 1) != 0) {
                        readyOps = 1;
                        boolean bl = true;
                        return bl;
                    }
                    this.logError("Ready to READ while not interested.");
                    boolean bl = false;
                    return bl;
                }
            }
            this.logError("Wrong kind.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.readyOps = readyOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWrite(int resultIndex) {
        int readyOps = 0;
        int interestOps = this.interestOps;
        boolean hadReadBeforeWrite = this.resultIndex == resultIndex;
        try {
            if (!this.epollOpt.hasWrite()) {
                if (this.isSocketBroken()) {
                    readyOps = this.channel().validOps();
                    boolean bl = true;
                    return bl;
                }
                this.logError("Unexpected error report.");
                boolean bl = false;
                return bl;
            }
            switch (this.kindUDT()) {
                case ACCEPTOR: {
                    this.logError("Ready to WRITE for acceptor.");
                    boolean bl = false;
                    return bl;
                }
                case CONNECTOR: 
                case RENDEZVOUS: {
                    if (this.channelUDT().isConnectFinished()) {
                        if ((interestOps & 4) != 0) {
                            readyOps = 4;
                            boolean bl = true;
                            return bl;
                        }
                        this.logError("Ready to WRITE when not insterested.");
                        boolean bl = false;
                        return bl;
                    }
                    if ((interestOps & 8) != 0) {
                        readyOps = 8;
                        boolean bl = true;
                        return bl;
                    }
                    this.logError("Ready to CONNECT when not interested.");
                    boolean bl = false;
                    return bl;
                }
            }
            this.logError("Wrong kind.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.readyOps = hadReadBeforeWrite ? (this.readyOps |= readyOps) : readyOps;
        }
    }

    protected EpollUDT.Opt epollOpt() {
        return this.epollOpt;
    }

    protected EpollUDT epollUDT() {
        return this.selector().epollUDT();
    }

    public boolean equals(Object otherKey) {
        if (otherKey instanceof SelectionKeyUDT) {
            SelectionKeyUDT other = (SelectionKeyUDT)otherKey;
            return other.socketId() == this.socketId();
        }
        return false;
    }

    boolean hasError() throws ExceptionUDT {
        int code = this.socketUDT().getOption(OptionUDT.Epoll_Event_Mask);
        return EpollUDT.Opt.from(code).hasError();
    }

    public int hashCode() {
        return this.socketId();
    }

    @Override
    public int interestOps() {
        return this.interestOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectionKey interestOps(int interestOps) {
        this.assertValidKey();
        this.assertValidOps(interestOps);
        try {
            EpollUDT.Opt epollNew = SelectionKeyUDT.from(interestOps);
            if (epollNew != this.epollOpt) {
                if (EpollUDT.Opt.ERROR == epollNew) {
                    this.epollUDT().remove(this.socketUDT());
                } else {
                    this.epollUDT().remove(this.socketUDT());
                    this.epollUDT().add(this.socketUDT(), epollNew);
                }
                this.epollOpt = epollNew;
            }
        }
        catch (Exception e) {
            log.error("epoll udpate failure", (Throwable)e);
        }
        finally {
            this.interestOps = interestOps;
        }
        return this;
    }

    protected boolean isSocketBroken() {
        switch (this.socketUDT().status()) {
            case INIT: 
            case OPENED: 
            case LISTENING: 
            case CONNECTING: 
            case CONNECTED: {
                return false;
            }
            case BROKEN: 
            case CLOSING: 
            case CLOSED: 
            case NONEXIST: {
                return true;
            }
        }
        this.logError("Unknown socket status.");
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    protected KindUDT kindUDT() {
        return this.channelUDT.kindUDT();
    }

    protected void logError(String comment) {
        String message = "logic error : \n\t" + this;
        log.warn(message, (Throwable)new Exception("" + comment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeValid(boolean isValid) {
        try {
            if (isValid) {
                this.epollOpt = EpollUDT.Opt.ERROR;
                this.epollUDT().add(this.socketUDT(), this.epollOpt);
            } else {
                this.epollUDT().remove(this.socketUDT());
            }
        }
        catch (Throwable e) {
            log.error("Epoll failure.", e);
        }
        finally {
            this.isValid = isValid;
        }
    }

    @Override
    public int readyOps() {
        return this.readyOps;
    }

    protected void readyOps(int ops) {
        this.readyOps = ops;
    }

    @Override
    public SelectorUDT selector() {
        return this.selectorUDT;
    }

    protected int socketId() {
        return this.socketUDT().id();
    }

    protected SocketUDT socketUDT() {
        return this.channelUDT.socketUDT();
    }

    public String toString() {
        return String.format("[id: 0x%08x] poll=%s ready=%s inter=%s %s %s %s bind=%s:%s peer=%s:%s", new Object[]{this.socketUDT().id(), this.epollOpt, SelectionKeyUDT.toStringOps(this.readyOps), SelectionKeyUDT.toStringOps(this.interestOps), this.channelUDT.typeUDT(), this.channelUDT.kindUDT(), this.socketUDT().status(), this.socketUDT().getLocalInetAddress(), this.socketUDT().getLocalInetPort(), this.socketUDT().getRemoteInetAddress(), this.socketUDT().getRemoteInetPort()});
    }
}

