/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class Page<T>
implements IPage<T> {
    private static final long serialVersionUID = 8545996863226528798L;
    private List<T> records = Collections.emptyList();
    private long total = 0L;
    private long size = 10L;
    private long current = 1L;
    private List<OrderItem> orders = new ArrayList<OrderItem>();
    private boolean optimizeCountSql = true;
    private boolean isSearchCount = true;

    public Page() {
    }

    public Page(long current, long size) {
        this(current, size, 0L);
    }

    public Page(long current, long size, long total) {
        this(current, size, total, true);
    }

    public Page(long current, long size, boolean isSearchCount) {
        this(current, size, 0L, isSearchCount);
    }

    public Page(long current, long size, long total, boolean isSearchCount) {
        if (current > 1L) {
            this.current = current;
        }
        this.size = size;
        this.total = total;
        this.isSearchCount = isSearchCount;
    }

    public boolean hasPrevious() {
        return this.current > 1L;
    }

    public boolean hasNext() {
        return this.current < this.getPages();
    }

    public List<T> getRecords() {
        return this.records;
    }

    public Page<T> setRecords(List<T> records) {
        this.records = records;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public Page<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public Page<T> setSize(long size) {
        this.size = size;
        return this;
    }

    public long getCurrent() {
        return this.current;
    }

    public Page<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    @Deprecated
    @Nullable
    public String[] ascs() {
        return CollectionUtils.isNotEmpty(this.orders) ? this.mapOrderToArray(OrderItem::isAsc) : null;
    }

    private String[] mapOrderToArray(Predicate<OrderItem> filter) {
        ArrayList columns = new ArrayList(this.orders.size());
        this.orders.forEach(i -> {
            if (filter.test((OrderItem)i)) {
                columns.add(i.getColumn());
            }
        });
        return columns.toArray(new String[0]);
    }

    private void removeOrder(Predicate<OrderItem> filter) {
        for (int i = this.orders.size() - 1; i >= 0; --i) {
            if (!filter.test(this.orders.get(i))) continue;
            this.orders.remove(i);
        }
    }

    public Page<T> addOrder(OrderItem ... items) {
        this.orders.addAll(Arrays.asList(items));
        return this;
    }

    @Deprecated
    public Page<T> setAscs(List<String> ascs) {
        return CollectionUtils.isNotEmpty(ascs) ? this.setAsc(ascs.toArray(new String[0])) : this;
    }

    @Deprecated
    public Page<T> setAsc(String ... ascs) {
        this.removeOrder(OrderItem::isAsc);
        for (String s : ascs) {
            this.addOrder(OrderItem.asc((String)s));
        }
        return this;
    }

    @Deprecated
    public String[] descs() {
        return this.mapOrderToArray(i -> !i.isAsc());
    }

    @Deprecated
    public Page<T> setDescs(List<String> descs) {
        if (CollectionUtils.isNotEmpty(descs)) {
            this.removeOrder(item -> !item.isAsc());
            for (String s : descs) {
                this.addOrder(OrderItem.desc((String)s));
            }
        }
        return this;
    }

    @Deprecated
    public Page<T> setDesc(String ... descs) {
        this.setDescs(Arrays.asList(descs));
        return this;
    }

    public List<OrderItem> orders() {
        return this.getOrders();
    }

    public List<OrderItem> getOrders() {
        return this.orders;
    }

    public void setOrders(List<OrderItem> orders) {
        this.orders = orders;
    }

    public boolean optimizeCountSql() {
        return this.optimizeCountSql;
    }

    public boolean isSearchCount() {
        if (this.total < 0L) {
            return false;
        }
        return this.isSearchCount;
    }

    public Page<T> setSearchCount(boolean isSearchCount) {
        this.isSearchCount = isSearchCount;
        return this;
    }

    public Page<T> setOptimizeCountSql(boolean optimizeCountSql) {
        this.optimizeCountSql = optimizeCountSql;
        return this;
    }
}

