/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OptimisticLockerInterceptor
implements Interceptor {
    @Deprecated
    public static final String MP_OPTLOCK_VERSION_ORIGINAL = "MP_OPTLOCK_VERSION_ORIGINAL";
    @Deprecated
    public static final String MP_OPTLOCK_VERSION_COLUMN = "MP_OPTLOCK_VERSION_COLUMN";
    @Deprecated
    public static final String MP_OPTLOCK_ET_ORIGINAL = "MP_OPTLOCK_ET_ORIGINAL";
    private static final String NAME_ENTITY = "et";
    private static final String NAME_ENTITY_WRAPPER = "ew";
    private static final String PARAM_UPDATE_METHOD_NAME = "update";
    private final Map<Class<?>, EntityField> versionFieldCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<EntityField>> entityFieldsCache = new ConcurrentHashMap();

    public Object intercept(Invocation invocation) throws Throwable {
        Map map;
        Object et;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (SqlCommandType.UPDATE != ms.getSqlCommandType()) {
            return invocation.proceed();
        }
        Object param = args[1];
        if (param instanceof Map && (et = (map = (Map)param).getOrDefault(NAME_ENTITY, null)) != null) {
            TableInfo tableInfo;
            String methodId = ms.getId();
            String methodName = methodId.substring(methodId.lastIndexOf(".") + 1);
            Class<?> entityClass = et.getClass();
            EntityField versionField = this.getVersionField(entityClass, tableInfo = TableInfoHelper.getTableInfo(entityClass));
            if (versionField == null) {
                return invocation.proceed();
            }
            Field field = versionField.getField();
            Object originalVersionVal = versionField.getField().get(et);
            if (originalVersionVal == null) {
                return invocation.proceed();
            }
            Object updatedVersionVal = this.getUpdatedVersionVal(originalVersionVal);
            if (PARAM_UPDATE_METHOD_NAME.equals(methodName)) {
                AbstractWrapper ew = map.getOrDefault(NAME_ENTITY_WRAPPER, null);
                if (ew == null) {
                    UpdateWrapper uw = new UpdateWrapper();
                    uw.eq((Object)versionField.getColumnName(), originalVersionVal);
                    map.put(NAME_ENTITY_WRAPPER, uw);
                    field.set(et, updatedVersionVal);
                } else {
                    ew.apply(versionField.getColumnName() + " = {0}", new Object[]{originalVersionVal});
                    field.set(et, updatedVersionVal);
                }
                return invocation.proceed();
            }
            List fields = this.entityFieldsCache.computeIfAbsent(entityClass, this::getFieldsFromClazz);
            HashMap<String, Object> entityMap = new HashMap<String, Object>(fields.size());
            for (EntityField ef : fields) {
                Field fd = ef.getField();
                entityMap.put(fd.getName(), fd.get(et));
            }
            String versionColumnName = versionField.getColumnName();
            versionField.setColumnName(versionColumnName);
            entityMap.put(field.getName(), updatedVersionVal);
            entityMap.put(MP_OPTLOCK_VERSION_ORIGINAL, originalVersionVal);
            entityMap.put(MP_OPTLOCK_VERSION_COLUMN, versionColumnName);
            entityMap.put(MP_OPTLOCK_ET_ORIGINAL, et);
            map.put(NAME_ENTITY, entityMap);
            Object resultObj = invocation.proceed();
            if (resultObj instanceof Integer) {
                Integer effRow = (Integer)resultObj;
                if (updatedVersionVal != null && effRow != 0) {
                    field.set(et, updatedVersionVal);
                }
            }
            return resultObj;
        }
        return invocation.proceed();
    }

    protected Object getUpdatedVersionVal(Object originalVersionVal) {
        Class<?> versionValClass = originalVersionVal.getClass();
        if (Long.TYPE.equals(versionValClass) || Long.class.equals(versionValClass)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(versionValClass) || Integer.class.equals(versionValClass)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(versionValClass)) {
            return new Date();
        }
        if (Timestamp.class.equals(versionValClass)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(versionValClass)) {
            return LocalDateTime.now();
        }
        return originalVersionVal;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private EntityField getVersionField(Class<?> parameterClass, TableInfo tableInfo) {
        return this.versionFieldCache.computeIfAbsent(parameterClass, mapping -> this.getVersionFieldRegular(parameterClass, tableInfo));
    }

    private EntityField getVersionFieldRegular(Class<?> parameterClass, TableInfo tableInfo) {
        return Object.class.equals(parameterClass) ? null : ReflectionKit.getFieldList(parameterClass).stream().filter(e -> e.isAnnotationPresent(Version.class)).map(field -> {
            field.setAccessible(true);
            return new EntityField((Field)field, true, tableInfo.getFieldList().stream().filter(e -> field.getName().equals(e.getProperty())).map(TableFieldInfo::getColumn).findFirst().orElse(null));
        }).findFirst().orElseGet(() -> this.getVersionFieldRegular(parameterClass.getSuperclass(), tableInfo));
    }

    private List<EntityField> getFieldsFromClazz(Class<?> parameterClass) {
        return ReflectionKit.getFieldList(parameterClass).stream().map(field -> {
            field.setAccessible(true);
            return new EntityField((Field)field, field.isAnnotationPresent(Version.class));
        }).collect(Collectors.toList());
    }

    private class EntityField {
        private Field field;
        private boolean version;
        private String columnName;

        EntityField(Field field, boolean version) {
            this.field = field;
            this.version = version;
        }

        public EntityField(Field field, boolean version, String columnName) {
            this.field = field;
            this.version = version;
            this.columnName = columnName;
        }

        public Field getField() {
            return this.field;
        }

        public boolean isVersion() {
            return this.version;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setVersion(boolean version) {
            this.version = version;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityField)) {
                return false;
            }
            EntityField other = (EntityField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            if (this.isVersion() != other.isVersion()) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntityField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            result = result * 59 + (this.isVersion() ? 79 : 97);
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        public String toString() {
            return "OptimisticLockerInterceptor.EntityField(field=" + this.getField() + ", version=" + this.isVersion() + ", columnName=" + this.getColumnName() + ")";
        }
    }
}

