/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.injector.methods.additional;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.util.function.Predicate;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;

public class InsertBatchSomeColumn
extends AbstractMethod {
    private static final String MAPPER_METHOD = "insertBatchSomeColumn";
    private Predicate<TableFieldInfo> predicate;

    public InsertBatchSomeColumn(Predicate<TableFieldInfo> predicate) {
        Assert.notNull(predicate, (String)"this predicate can not be null !", (Object[])new Object[0]);
        this.predicate = predicate;
    }

    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        SqlMethod sqlMethod = SqlMethod.INSERT_ONE;
        String insertSqlColumn = tableInfo.getSomeInsertSqlColumn(this.predicate);
        String columnScript = "(" + insertSqlColumn.substring(0, insertSqlColumn.length() - 1) + ")";
        String insertSqlProperty = tableInfo.getSomeInsertSqlProperty("et.", this.predicate);
        insertSqlProperty = "(" + insertSqlProperty.substring(0, insertSqlProperty.length() - 1) + ")";
        String valuesScript = SqlScriptUtils.convertForeach((String)insertSqlProperty, (String)"list", null, (String)"et", (String)",");
        String keyProperty = null;
        String keyColumn = null;
        if (StringUtils.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
            if (tableInfo.getIdType() == IdType.AUTO) {
                keyGenerator = new Jdbc3KeyGenerator();
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            } else if (null != tableInfo.getKeySequence()) {
                keyGenerator = TableInfoHelper.genKeyGenerator((TableInfo)tableInfo, (MapperBuilderAssistant)this.builderAssistant, (String)sqlMethod.getMethod(), (LanguageDriver)this.languageDriver);
                keyProperty = tableInfo.getKeyProperty();
                keyColumn = tableInfo.getKeyColumn();
            }
        }
        String sql = String.format(sqlMethod.getSql(), tableInfo.getTableName(), columnScript, valuesScript);
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        return this.addInsertMappedStatement(mapperClass, modelClass, MAPPER_METHOD, sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }
}

