/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.toolkit.EnumUtils;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EnumAnnotationTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private final Class<E> type;
    private static final Log LOGGER = LogFactory.getLog(EnumAnnotationTypeHandler.class);
    private static final Map<Class<?>, Field> TABLE_FIELD_OF_ENUM_TYPES = new ConcurrentHashMap();

    public EnumAnnotationTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    public static void addEnumType(Class<?> clazz, Field tableFieldOfEnumType) {
        TABLE_FIELD_OF_ENUM_TYPES.put(clazz, tableFieldOfEnumType);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Enum parameter, JdbcType jdbcType) throws SQLException {
        Field tableEnumField = TABLE_FIELD_OF_ENUM_TYPES.get(this.type);
        try {
            if (jdbcType == null) {
                ps.setObject(i, tableEnumField == null ? parameter.name() : tableEnumField.get(parameter));
            } else {
                ps.setObject(i, tableEnumField == null ? parameter.name() : tableEnumField.get(parameter), jdbcType.TYPE_CODE);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("unrecognized jdbcType, failed to set StringValue for type=" + parameter);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getEnumResult(rs.getObject(columnName));
    }

    private E getEnumResult(Object s) {
        if (s == null) {
            return null;
        }
        Field tableEnumField = TABLE_FIELD_OF_ENUM_TYPES.get(this.type);
        if (tableEnumField != null) {
            return (E)EnumUtils.valueOf(this.type, (Object)s, (Field)tableEnumField);
        }
        return Enum.valueOf(this.type, s.toString());
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getEnumResult(rs.getObject(columnIndex));
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getEnumResult(cs.getString(columnIndex));
    }
}

