/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.executor;

import com.baomidou.mybatisplus.core.executor.AbstractBaseExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;

public class MybatisSimpleExecutor
extends AbstractBaseExecutor {
    public MybatisSimpleExecutor(Configuration configuration, Transaction transaction) {
        super(configuration, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(MappedStatement ms, Object parameter) throws SQLException {
        int n;
        Statement stmt = null;
        try {
            Configuration configuration = ms.getConfiguration();
            StatementHandler handler = configuration.newStatementHandler((Executor)this, ms, parameter, RowBounds.DEFAULT, null, null);
            stmt = this.prepareStatement(handler, ms.getStatementLog(), false);
            n = stmt == null ? 0 : handler.update(stmt);
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
        this.closeStatement(stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> doQuery(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        List list;
        Statement stmt = null;
        try {
            Configuration configuration = ms.getConfiguration();
            StatementHandler handler = configuration.newStatementHandler(this.wrapper, ms, parameter, rowBounds, resultHandler, boundSql);
            stmt = this.prepareStatement(handler, ms.getStatementLog(), false);
            list = stmt == null ? Collections.emptyList() : handler.query(stmt, resultHandler);
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
        this.closeStatement(stmt);
        return list;
    }

    protected <E> Cursor<E> doQueryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds, BoundSql boundSql) throws SQLException {
        Configuration configuration = ms.getConfiguration();
        StatementHandler handler = configuration.newStatementHandler(this.wrapper, ms, parameter, rowBounds, null, boundSql);
        Statement stmt = this.prepareStatement(handler, ms.getStatementLog(), true);
        if (stmt != null) {
            stmt.closeOnCompletion();
            return handler.queryCursor(stmt);
        }
        return null;
    }

    public List<BatchResult> doFlushStatements(boolean isRollback) {
        return Collections.emptyList();
    }

    private Statement prepareStatement(StatementHandler handler, Log statementLog, boolean isCursor) throws SQLException {
        Connection connection = this.getConnection(statementLog);
        Statement stmt = handler.prepare(connection, this.transaction.getTimeout());
        if (stmt == null && !isCursor) {
            return null;
        }
        handler.parameterize(stmt);
        return stmt;
    }
}

