/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.segments;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.segments.GroupBySegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.HavingSegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.MatchSegment;
import com.baomidou.mybatisplus.core.conditions.segments.NormalSegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.OrderBySegmentList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MergeSegments
implements ISqlSegment {
    private final NormalSegmentList normal = new NormalSegmentList();
    private final GroupBySegmentList groupBy = new GroupBySegmentList();
    private final HavingSegmentList having = new HavingSegmentList();
    private final OrderBySegmentList orderBy = new OrderBySegmentList();
    private String sqlSegment = "";
    private boolean cacheSqlSegment = true;

    public void add(ISqlSegment ... iSqlSegments) {
        List<ISqlSegment> list = Arrays.asList(iSqlSegments);
        ISqlSegment sqlSegment = list.get(0);
        if (MatchSegment.ORDER_BY.match(sqlSegment)) {
            this.orderBy.addAll((Collection<? extends ISqlSegment>)list);
        } else if (MatchSegment.GROUP_BY.match(sqlSegment)) {
            this.groupBy.addAll((Collection<? extends ISqlSegment>)list);
        } else if (MatchSegment.HAVING.match(sqlSegment)) {
            this.having.addAll((Collection<? extends ISqlSegment>)list);
        } else {
            this.normal.addAll((Collection<? extends ISqlSegment>)list);
        }
        this.cacheSqlSegment = false;
    }

    @Override
    public String getSqlSegment() {
        if (this.cacheSqlSegment) {
            return this.sqlSegment;
        }
        this.cacheSqlSegment = true;
        if (this.normal.isEmpty()) {
            if (!this.groupBy.isEmpty() || !this.orderBy.isEmpty()) {
                this.sqlSegment = this.groupBy.getSqlSegment() + this.having.getSqlSegment() + this.orderBy.getSqlSegment();
            }
        } else {
            this.sqlSegment = this.normal.getSqlSegment() + this.groupBy.getSqlSegment() + this.having.getSqlSegment() + this.orderBy.getSqlSegment();
        }
        return this.sqlSegment;
    }

    public NormalSegmentList getNormal() {
        return this.normal;
    }

    public GroupBySegmentList getGroupBy() {
        return this.groupBy;
    }

    public HavingSegmentList getHaving() {
        return this.having;
    }

    public OrderBySegmentList getOrderBy() {
        return this.orderBy;
    }

    public boolean isCacheSqlSegment() {
        return this.cacheSqlSegment;
    }
}

