/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.persistence.RecoverableCoordinator;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.OltpLog;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Assert;

public class StateRecoveryManagerImp
implements StateRecoveryManager,
FSMPreEnterListener {
    private OltpLog oltpLog;

    @Override
    public void register(RecoverableCoordinator staterecoverable) {
        TxState[] states;
        Assert.notNull((String)"illegal attempt to register null staterecoverable", (Object)staterecoverable);
        for (TxState txState : states = TxState.values()) {
            if (!txState.isRecoverableState() && !txState.isFinalState()) continue;
            staterecoverable.addFSMPreEnterListener(this, txState);
        }
    }

    @Override
    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        TxState state = event.getState();
        RecoverableCoordinator source = (RecoverableCoordinator)event.getSource();
        CoordinatorLogEntry coordinatorLogEntry = source.getCoordinatorLogEntry(state);
        if (coordinatorLogEntry != null) {
            try {
                this.oltpLog.write(coordinatorLogEntry);
            }
            catch (LogException le) {
                throw new IllegalStateException("could not flush state image " + le.getMessage() + " " + ((Object)((Object)le)).getClass().getName(), le);
            }
        }
    }

    @Override
    public void close() throws LogException {
        this.oltpLog.close();
    }

    public void setOltpLog(OltpLog oltpLog) {
        this.oltpLog = oltpLog;
    }
}

