/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.CRC64;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.internal.OSSCallbackErrorResponseHandler;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OSSMultipartOperation
extends OSSOperation {
    private static final int LIST_PART_MAX_RETURNS = 1000;
    private static final int LIST_UPLOAD_MAX_RETURNS = 1000;
    private static final int MAX_PART_NUMBER = 10000;

    public OSSMultipartOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(abortMultipartUploadRequest, "abortMultipartUploadRequest");
        String key = abortMultipartUploadRequest.getKey();
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String uploadId = abortMultipartUploadRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uploadId", uploadId);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateRequestPayerHeader(headers, abortMultipartUploadRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(parameters).setOriginalRequest(abortMultipartUploadRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(completeMultipartUploadRequest, "completeMultipartUploadRequest");
        String key = completeMultipartUploadRequest.getKey();
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        OSSUtils.ensureCallbackValid(completeMultipartUploadRequest.getCallback());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateCompleteMultipartUploadOptionalHeaders(completeMultipartUploadRequest, headers);
        OSSUtils.populateRequestCallback(headers, completeMultipartUploadRequest.getCallback());
        OSSMultipartOperation.populateRequestPayerHeader(headers, completeMultipartUploadRequest.getRequestPayer());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uploadId", uploadId);
        List<PartETag> partETags = completeMultipartUploadRequest.getPartETags();
        Collections.sort(partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag p1, PartETag p2) {
                return p1.getPartNumber() - p2.getPartNumber();
            }
        });
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(parameters).setInputStreamWithLength(RequestMarshallers.completeMultipartUploadRequestMarshaller.marshall(completeMultipartUploadRequest)).setOriginalRequest(completeMultipartUploadRequest).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new OSSCallbackErrorResponseHandler());
        CompleteMultipartUploadResult result = null;
        result = !OSSMultipartOperation.isNeedReturnResponse(completeMultipartUploadRequest) ? this.doOperation(request, ResponseParsers.completeMultipartUploadResponseParser, bucketName, key, true) : this.doOperation(request, ResponseParsers.completeMultipartUploadProcessResponseParser, bucketName, key, true, null, reponseHandlers);
        result.setClientCRC(OSSMultipartOperation.calcObjectCRCFromParts(completeMultipartUploadRequest.getPartETags()));
        if (this.getInnerClient().getClientConfiguration().isCrcCheckEnabled()) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(initiateMultipartUploadRequest, "initiateMultipartUploadRequest");
        String key = initiateMultipartUploadRequest.getKey();
        String bucketName = initiateMultipartUploadRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (initiateMultipartUploadRequest.getObjectMetadata() != null) {
            OSSUtils.populateRequestMetadata(headers, initiateMultipartUploadRequest.getObjectMetadata());
        }
        OSSMultipartOperation.populateRequestPayerHeader(headers, initiateMultipartUploadRequest.getRequestPayer());
        OSSUtils.removeHeader(headers, "Content-Length");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uploads", null);
        Boolean sequentialMode = initiateMultipartUploadRequest.getSequentialMode();
        if (sequentialMode != null && sequentialMode.equals(true)) {
            params.put("sequential", null);
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).setOriginalRequest(initiateMultipartUploadRequest).build();
        return this.doOperation(request, ResponseParsers.initiateMultipartUploadResponseParser, bucketName, key, true);
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listMultipartUploadsRequest, "listMultipartUploadsRequest");
        String bucketName = listMultipartUploadsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSMultipartOperation.populateListMultipartUploadsRequestParameters(listMultipartUploadsRequest, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateRequestPayerHeader(headers, listMultipartUploadsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(listMultipartUploadsRequest).build();
        return this.doOperation(request, ResponseParsers.listMultipartUploadsResponseParser, bucketName, null, true);
    }

    public PartListing listParts(ListPartsRequest listPartsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listPartsRequest, "listPartsRequest");
        String key = listPartsRequest.getKey();
        String bucketName = listPartsRequest.getBucketName();
        String uploadId = listPartsRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSMultipartOperation.populateListPartsRequestParameters(listPartsRequest, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateRequestPayerHeader(headers, listPartsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(listPartsRequest).build();
        return this.doOperation(request, ResponseParsers.listPartsResponseParser, bucketName, key, true);
    }

    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(uploadPartRequest, "uploadPartRequest");
        String key = uploadPartRequest.getKey();
        String bucketName = uploadPartRequest.getBucketName();
        String uploadId = uploadPartRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        if (uploadPartRequest.getInputStream() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetContentStream"));
        }
        InputStream repeatableInputStream = null;
        try {
            repeatableInputStream = IOUtils.newRepeatableInputStream(uploadPartRequest.buildPartialStream());
        }
        catch (IOException ex) {
            LogUtils.logException("Cannot wrap to repeatable input stream: ", ex);
            throw new ClientException("Cannot wrap to repeatable input stream: ", ex);
        }
        int partNumber = uploadPartRequest.getPartNumber();
        if (!CodingUtils.checkParamRange(partNumber, 0L, false, 10000L, true)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberOutOfRange"));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateUploadPartOptionalHeaders(uploadPartRequest, headers);
        OSSMultipartOperation.populateRequestPayerHeader(headers, uploadPartRequest.getRequestPayer());
        OSSMultipartOperation.populateTrafficLimitHeader(headers, uploadPartRequest.getTrafficLimit());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partNumber", Integer.toString(partNumber));
        params.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setParameters(params).setHeaders(headers).setInputStream(repeatableInputStream).setInputSize(uploadPartRequest.getPartSize()).setUseChunkEncoding(uploadPartRequest.isUseChunkEncoding()).setOriginalRequest(uploadPartRequest).build();
        ProgressListener listener = uploadPartRequest.getProgressListener();
        ResponseMessage response = null;
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_PART_STARTED_EVENT);
            response = this.doOperation(request, emptyResponseParser, bucketName, key);
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_PART_COMPLETED_EVENT);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_PART_FAILED_EVENT);
            throw e;
        }
        UploadPartResult result = new UploadPartResult();
        result.setPartNumber(partNumber);
        result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
        result.setRequestId(response.getRequestId());
        result.setPartSize(uploadPartRequest.getPartSize());
        ResponseParsers.setCRC(result, response);
        if (this.getInnerClient().getClientConfiguration().isCrcCheckEnabled()) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public UploadPartCopyResult uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(uploadPartCopyRequest, "uploadPartCopyRequest");
        String key = uploadPartCopyRequest.getKey();
        String bucketName = uploadPartCopyRequest.getBucketName();
        String uploadId = uploadPartCopyRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        Long partSize = uploadPartCopyRequest.getPartSize();
        if (partSize != null && !CodingUtils.checkParamRange(partSize, 0L, true, 0x140000000L, true)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("FileSizeOutOfRange"));
        }
        int partNumber = uploadPartCopyRequest.getPartNumber();
        if (!CodingUtils.checkParamRange(partNumber, 0L, false, 10000L, true)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberOutOfRange"));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateCopyPartRequestHeaders(uploadPartCopyRequest, headers);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partNumber", Integer.toString(partNumber));
        params.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setParameters(params).setHeaders(headers).setOriginalRequest(uploadPartCopyRequest).build();
        return this.doOperation(request, new ResponseParsers.UploadPartCopyResponseParser(partNumber), bucketName, key, true);
    }

    private static void populateListMultipartUploadsRequestParameters(ListMultipartUploadsRequest listMultipartUploadsRequest, Map<String, String> params) {
        Integer maxUploads;
        params.put("uploads", null);
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            params.put("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            params.put("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if ((maxUploads = listMultipartUploadsRequest.getMaxUploads()) != null) {
            if (!CodingUtils.checkParamRange(maxUploads.intValue(), 0L, true, 1000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getFormattedString("MaxUploadsOutOfRange", 1000));
            }
            params.put("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            params.put("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            params.put("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            params.put("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
    }

    private static void populateListPartsRequestParameters(ListPartsRequest listPartsRequest, Map<String, String> params) {
        Integer partNumberMarker;
        params.put("uploadId", listPartsRequest.getUploadId());
        Integer maxParts = listPartsRequest.getMaxParts();
        if (maxParts != null) {
            if (!CodingUtils.checkParamRange(maxParts.intValue(), 0L, true, 1000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getFormattedString("MaxPartsOutOfRange", 1000));
            }
            params.put("max-parts", maxParts.toString());
        }
        if ((partNumberMarker = listPartsRequest.getPartNumberMarker()) != null) {
            if (!CodingUtils.checkParamRange(partNumberMarker.intValue(), 0L, false, 10000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberMarkerOutOfRange"));
            }
            params.put("part-number-marker", partNumberMarker.toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            params.put("encoding-type", listPartsRequest.getEncodingType());
        }
    }

    private static void populateCopyPartRequestHeaders(UploadPartCopyRequest uploadPartCopyRequest, Map<String, String> headers) {
        if (uploadPartCopyRequest.getPartSize() != null) {
            headers.put("Content-Length", Long.toString(uploadPartCopyRequest.getPartSize()));
        }
        if (uploadPartCopyRequest.getMd5Digest() != null) {
            headers.put("Content-MD5", uploadPartCopyRequest.getMd5Digest());
        }
        String copySource = "/" + uploadPartCopyRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(uploadPartCopyRequest.getSourceKey(), "utf-8");
        if (uploadPartCopyRequest.getSourceVersionId() != null) {
            copySource = copySource + "?versionId=" + uploadPartCopyRequest.getSourceVersionId();
        }
        headers.put("x-oss-copy-source", copySource);
        if (uploadPartCopyRequest.getBeginIndex() != null && uploadPartCopyRequest.getPartSize() != null) {
            String range = "bytes=" + uploadPartCopyRequest.getBeginIndex() + "-" + Long.toString(uploadPartCopyRequest.getBeginIndex() + uploadPartCopyRequest.getPartSize() - 1L);
            headers.put("x-oss-copy-source-range", range);
        }
        if (uploadPartCopyRequest.getRequestPayer() != null) {
            headers.put("x-oss-request-payer", uploadPartCopyRequest.getRequestPayer().toString().toLowerCase());
        }
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", uploadPartCopyRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", uploadPartCopyRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", uploadPartCopyRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", uploadPartCopyRequest.getNonmatchingEtagConstraints());
    }

    private static void populateUploadPartOptionalHeaders(UploadPartRequest uploadPartRequest, Map<String, String> headers) {
        if (!uploadPartRequest.isUseChunkEncoding()) {
            long partSize = uploadPartRequest.getPartSize();
            if (!CodingUtils.checkParamRange(partSize, 0L, true, 0x140000000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("FileSizeOutOfRange"));
            }
            headers.put("Content-Length", Long.toString(partSize));
        }
        if (uploadPartRequest.getMd5Digest() != null) {
            headers.put("Content-MD5", uploadPartRequest.getMd5Digest());
        }
    }

    private static void populateCompleteMultipartUploadOptionalHeaders(CompleteMultipartUploadRequest completeMultipartUploadRequest, Map<String, String> headers) {
        CannedAccessControlList cannedACL = completeMultipartUploadRequest.getObjectACL();
        if (cannedACL != null) {
            headers.put("x-oss-object-acl", cannedACL.toString());
        }
    }

    private static void populateRequestPayerHeader(Map<String, String> headers, Payer payer) {
        if (payer != null && payer.equals((Object)Payer.Requester)) {
            headers.put("x-oss-request-payer", payer.toString().toLowerCase());
        }
    }

    private static void populateTrafficLimitHeader(Map<String, String> headers, int limit) {
        if (limit > 0) {
            headers.put("x-oss-traffic-limit", String.valueOf(limit));
        }
    }

    private static Long calcObjectCRCFromParts(List<PartETag> partETags) {
        long crc = 0L;
        for (PartETag partETag : partETags) {
            if (partETag.getPartCRC() == null || partETag.getPartSize() <= 0L) {
                return null;
            }
            crc = CRC64.combine(crc, partETag.getPartCRC(), partETag.getPartSize());
        }
        return new Long(crc);
    }

    private static boolean isNeedReturnResponse(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        return completeMultipartUploadRequest.getCallback() != null || completeMultipartUploadRequest.getProcess() != null;
    }
}

