/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openapiutil;

import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Encoder;

public class Client {
    public static final String SEPARATOR = "&";
    public static final String URL_ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "HmacSHA1";
    public static final String HASH_SHA256 = "SHA-256";
    public static final String HASH_SM3 = "SM3";
    public static final String HMAC_SHA256 = "ACS3-HMAC-SHA256";
    public static final String RSA_SHA256 = "ACS3-RSA-SHA256";
    public static final String HMAC_SM3 = "ACS3-HMAC-SM3";
    public static final String UTF8 = "UTF-8";
    public static final String PEM_BEGIN = "-----BEGIN RSA PRIVATE KEY-----\n";
    public static final String PEM_END = "\n-----END RSA PRIVATE KEY-----";

    public static void convert(TeaModel body, TeaModel content) throws Exception {
        if (body == null || content == null) {
            return;
        }
        Class<?> bodyClass = body.getClass();
        Class<?> contentClass = content.getClass();
        Field[] fields = bodyClass.getDeclaredFields();
        TeaModel teaModel = (TeaModel)bodyClass.newInstance();
        for (Field field : fields) {
            field.setAccessible(true);
            if (InputStream.class.isAssignableFrom(field.getType())) continue;
            field.set(teaModel, field.get(body));
        }
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)teaModel);
        Object outPut = gson.fromJson(jsonString, contentClass);
        for (Field field : fields = outPut.getClass().getFields()) {
            field.setAccessible(true);
            field.set(content, field.get(outPut));
        }
    }

    public static String getStringToSign(TeaRequest request) throws Exception {
        if (request == null) {
            return "";
        }
        String method = request.method;
        String pathname = request.pathname;
        Map headers = request.headers;
        Map query = request.query;
        String accept = headers.get("accept") == null ? "" : (String)headers.get("accept");
        String contentMD5 = headers.get("content-md5") == null ? "" : (String)headers.get("content-md5");
        String contentType = headers.get("content-type") == null ? "" : (String)headers.get("content-type");
        String date = headers.get("date") == null ? "" : (String)headers.get("date");
        String header = method + "\n" + accept + "\n" + contentMD5 + "\n" + contentType + "\n" + date + "\n";
        String canonicalizedHeaders = Client.getCanonicalizedHeaders(headers);
        String canonicalizedResource = Client.getCanonicalizedResource(pathname, query);
        String stringToSign = header + canonicalizedHeaders + canonicalizedResource;
        return stringToSign;
    }

    protected static String getCanonicalizedHeaders(Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        String prefix = "x-acs-";
        Set<String> keys = headers.keySet();
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            canonicalizedKeys.add(key);
        }
        Object[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        Arrays.sort(canonicalizedKeysArray);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; ++i) {
            Object key = canonicalizedKeysArray[i];
            result.append((String)key);
            result.append(":");
            result.append(headers.get(key).trim());
            result.append("\n");
        }
        return result.toString();
    }

    protected static Map<String, String> getCanonicalizedHeadersMap(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        String prefix = "x-acs-";
        Set<String> keys = headers.keySet();
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (String key : keys) {
            String lowerKey = key.toLowerCase();
            if (!lowerKey.startsWith(prefix) && !lowerKey.equals("host") && !lowerKey.equals("content-type")) continue;
            if (!canonicalizedKeys.contains(lowerKey)) {
                canonicalizedKeys.add(lowerKey);
            }
            valueMap.put(lowerKey, headers.get(key).trim());
        }
        Object[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        String signedHeaders = StringUtils.join((String)";", Arrays.asList(canonicalizedKeysArray));
        Arrays.sort(canonicalizedKeysArray);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; ++i) {
            Object key = canonicalizedKeysArray[i];
            sb.append((String)key);
            sb.append(":");
            sb.append((String)valueMap.get(key));
            sb.append("\n");
        }
        result.put("canonicalHeaders", sb.toString());
        result.put("signedHeaders", signedHeaders);
        return result;
    }

    protected static String getCanonicalizedQueryString(StringBuilder sb, Map<String, String> query, String[] keys) throws Exception {
        if (query == null || query.size() == 0) {
            return "";
        }
        if (keys == null || keys.length == 0) {
            return "";
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            sb.append(Client.percentEncode(key));
            String value = query.get(key);
            sb.append("=");
            if (!StringUtils.isEmpty((CharSequence)value)) {
                sb.append(Client.percentEncode(value));
            }
            sb.append(SEPARATOR);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    protected static String getCanonicalizedQueryStringForROA(StringBuilder sb, Map<String, String> query, String[] keys) throws Exception {
        if (query == null || query.size() == 0) {
            return "";
        }
        if (keys == null || keys.length == 0) {
            return "";
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            sb.append(key);
            String value = query.get(key);
            if (!StringUtils.isEmpty((CharSequence)value)) {
                sb.append("=");
                sb.append(value);
            }
            sb.append(SEPARATOR);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    protected static String getCanonicalizedResource(Map<String, String> query) throws Exception {
        if (query == null || query.size() == 0) {
            return "";
        }
        String[] keys = query.keySet().toArray(new String[query.size()]);
        StringBuilder result = new StringBuilder();
        return Client.getCanonicalizedQueryString(result, query, keys);
    }

    protected static String getCanonicalizedResource(String pathname, Map<String, String> query) throws Exception {
        if (query == null || query.size() == 0) {
            return pathname;
        }
        String[] keys = query.keySet().toArray(new String[query.size()]);
        if (pathname == null || keys.length <= 0) {
            return pathname;
        }
        StringBuilder result = new StringBuilder(pathname);
        result.append("?");
        return Client.getCanonicalizedQueryStringForROA(result, query, keys);
    }

    public static String getROASignature(String stringToSign, String secret) throws Exception {
        if (StringUtils.isEmpty((CharSequence)secret)) {
            return secret;
        }
        Mac mac = Mac.getInstance(ALGORITHM_NAME);
        mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), ALGORITHM_NAME));
        byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
        return new BASE64Encoder().encode(signData);
    }

    public static String toForm(Map<String, ?> filter) throws Exception {
        return Client.toFormWithSymbol(filter, SEPARATOR);
    }

    private static String toFormWithSymbol(Map<String, ?> filter, String symbol) throws Exception {
        Map<String, String> map = Client.query(filter);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtils.isEmpty((Object)entry.getValue())) continue;
            if (first) {
                first = false;
            } else {
                result.append(symbol);
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
        }
        return result.toString();
    }

    public static String getTimestamp() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return df.format(new Date());
    }

    public static Map<String, String> query(Map<String, ?> filter) throws Exception {
        HashMap<String, String> outMap = new HashMap<String, String>();
        if (null != filter) {
            Client.processObject(outMap, "", filter);
        }
        return outMap;
    }

    private static void processObject(Map<String, String> map, String key, Object value) throws UnsupportedEncodingException {
        if (null == value) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Client.processObject(map, key + "." + (i + 1), list.get(i));
            }
        } else if (value instanceof TeaModel) {
            Map subMap = ((TeaModel)value).toMap();
            for (Map.Entry entry : subMap.entrySet()) {
                Client.processObject(map, key + "." + (String)entry.getKey(), entry.getValue());
            }
        } else if (value instanceof Map) {
            Map subMap = (Map)value;
            for (Map.Entry entry : subMap.entrySet()) {
                Client.processObject(map, key + "." + (String)entry.getKey(), entry.getValue());
            }
        } else {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            if (value instanceof byte[]) {
                map.put(key, new String((byte[])value, "UTF-8"));
            } else {
                map.put(key, String.valueOf(value));
            }
        }
    }

    public static String getRPCSignature(Map<String, String> signedParams, String method, String secret) throws Exception {
        if (signedParams == null || StringUtils.isEmpty((CharSequence)secret)) {
            return secret;
        }
        Map<String, String> queries = signedParams;
        Object[] sortedKeys = queries.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Object key : sortedKeys) {
            if (StringUtils.isEmpty((CharSequence)queries.get(key))) continue;
            canonicalizedQueryString.append(SEPARATOR).append(Client.percentEncode((String)key)).append("=").append(Client.percentEncode(queries.get(key)));
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(method);
        stringToSign.append(SEPARATOR);
        stringToSign.append(Client.percentEncode("/"));
        stringToSign.append(SEPARATOR);
        stringToSign.append(Client.percentEncode(canonicalizedQueryString.toString().substring(1)));
        Mac mac = Mac.getInstance(ALGORITHM_NAME);
        mac.init(new SecretKeySpec((secret + SEPARATOR).getBytes("UTF-8"), ALGORITHM_NAME));
        byte[] signData = mac.doFinal(stringToSign.toString().getBytes("UTF-8"));
        return DatatypeConverter.printBase64Binary((byte[])signData);
    }

    public static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String arrayToStringWithSpecifiedStyle(Object array, String prefix, String style) throws Exception {
        if (null == array) {
            return "";
        }
        switch (style) {
            case "repeatList": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(prefix, array);
                return Client.toFormWithSymbol(map, "&&");
            }
            case "simple": 
            case "spaceDelimited": 
            case "pipeDelimited": {
                return Client.flatArray((List)array, style);
            }
            case "json": {
                Class<?> clazz = array.getClass();
                List list = new ArrayList();
                if (List.class.isAssignableFrom(clazz)) {
                    list = (List)array;
                }
                if (list.size() > 0 && TeaModel.class.isAssignableFrom(list.get(0).getClass())) {
                    List teaModels = (List)array;
                    ArrayList<Map> mapList = new ArrayList<Map>();
                    for (TeaModel teaModel : teaModels) {
                        mapList.add(teaModel.toMap());
                    }
                    return new Gson().toJson(mapList);
                }
                return new Gson().toJson(array);
            }
        }
        return "";
    }

    private static String flatArray(List array, String sty) {
        if (array == null || array.size() <= 0 || sty == null) {
            return "";
        }
        String flag = "simple".equalsIgnoreCase(sty) ? "," : ("spaceDelimited".equalsIgnoreCase(sty) ? " " : "|");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            sb.append(array.get(i));
            sb.append(flag);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static Map<String, Object> parseToMap(Object o) {
        if (null == o) {
            return null;
        }
        return (Map)TeaModel.parseObject((Object)o);
    }

    public static String getEndpoint(String endpoint, boolean useAccelerate, String endpointType) {
        if ("internal".equals(endpointType)) {
            String[] strs = endpoint.split("\\.");
            strs[0] = strs[0] + "-internal";
            endpoint = StringUtils.join((String)".", Arrays.asList(strs));
        }
        if (useAccelerate && "accelerate".equals(endpointType)) {
            return "oss-accelerate.aliyuncs.com";
        }
        return endpoint;
    }

    public static String hexEncode(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < raw.length; ++i) {
            String hex = Integer.toHexString(raw[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] hash(byte[] raw, String signAlgorithm) throws Exception {
        if (signAlgorithm == null) {
            return null;
        }
        if (signAlgorithm.equals(HMAC_SHA256) || signAlgorithm.equals(RSA_SHA256)) {
            MessageDigest digest = MessageDigest.getInstance(HASH_SHA256);
            return digest.digest(raw);
        }
        if (signAlgorithm.equals(HMAC_SM3)) {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            MessageDigest digest = MessageDigest.getInstance(HASH_SM3, (Provider)provider);
            return digest.digest(raw);
        }
        return null;
    }

    public static String getAuthorization(TeaRequest request, String signAlgorithm, String payload, String accessKey, String secret) throws Exception {
        if (request == null) {
            return null;
        }
        if (secret == null) {
            throw new Exception("Need secret!");
        }
        if (StringUtils.isEmpty((CharSequence)signAlgorithm)) {
            throw new Exception("Need signAlgorithm!");
        }
        String canonicalURI = request.pathname;
        if (canonicalURI == null || StringUtils.isEmpty((CharSequence)canonicalURI) || "".equals(canonicalURI.trim())) {
            canonicalURI = "/";
        }
        String method = request.method;
        Map headers = request.headers;
        Map query = request.query;
        Map<String, String> cannoicalHeaders = Client.getCanonicalizedHeadersMap(headers);
        String signedHeaders = cannoicalHeaders.get("signedHeaders");
        String queryString = Client.getCanonicalizedResource(query);
        StringBuilder sb = new StringBuilder(method);
        sb.append("\n").append(canonicalURI).append("\n").append(queryString).append("\n").append(cannoicalHeaders.get("canonicalHeaders")).append("\n").append(signedHeaders).append("\n").append(payload);
        String hex = Client.hexEncode(Client.hash(sb.toString().getBytes("UTF-8"), signAlgorithm));
        String stringToSign = signAlgorithm + "\n" + hex;
        String signature = Client.hexEncode(Client.SignatureMethod(stringToSign, secret, signAlgorithm));
        String auth = signAlgorithm + " Credential=" + accessKey + ",SignedHeaders=" + signedHeaders + ",Signature=" + signature;
        return auth;
    }

    protected static String checkRSASecret(String secret) {
        if (secret != null) {
            if (secret.startsWith(PEM_BEGIN)) {
                secret = secret.replace(PEM_BEGIN, "");
            }
            while (secret.endsWith("\n") || secret.endsWith("\r")) {
                secret = secret.substring(0, secret.length() - 1);
            }
            if (secret.endsWith(PEM_END)) {
                secret = secret.replace(PEM_END, "");
            }
        }
        return secret;
    }

    public static byte[] SignatureMethod(String stringToSign, String secret, String signAlgorithm) throws Exception {
        if (stringToSign == null || secret == null || signAlgorithm == null) {
            return null;
        }
        byte[] bytes = null;
        if (signAlgorithm.equals(HMAC_SHA256)) {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            bytes = sha256_HMAC.doFinal(stringToSign.getBytes());
            return bytes;
        }
        if (signAlgorithm.equals(RSA_SHA256)) {
            secret = Client.checkRSASecret(secret);
            Signature rsaSign = Signature.getInstance("SHA256withRSA");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] keySpec = DatatypeConverter.parseBase64Binary((String)secret);
            PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(keySpec));
            rsaSign.initSign(privateKey);
            rsaSign.update(stringToSign.getBytes("UTF-8"));
            bytes = rsaSign.sign();
        } else if (signAlgorithm.equals(HMAC_SM3)) {
            SecretKeySpec key = new SecretKeySpec(secret.getBytes("UTF-8"), "HMAC-SM3");
            HMac mac = new HMac((Digest)new SM3Digest());
            bytes = new byte[mac.getMacSize()];
            byte[] inputBytes = stringToSign.getBytes("UTF-8");
            mac.init((CipherParameters)new KeyParameter(key.getEncoded()));
            mac.update(inputBytes, 0, inputBytes.length);
            mac.doFinal(bytes, 0);
        }
        return bytes;
    }

    public static String getEncodePath(String path) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((CharSequence)path) || "/".equals(path)) {
            return path;
        }
        String[] strs = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            sb.append(Client.percentEncode(strs[i]));
            sb.append("/");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

