/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.regions;

import com.aliyuncs.regions.ProductDomain;
import java.util.List;
import java.util.Set;

public class Endpoint {
    private String name = null;
    private Set<String> regionIds = null;
    private List<ProductDomain> productDomains = null;

    public Endpoint(String name, Set<String> regionIds, List<ProductDomain> productDomains) {
        this.name = name;
        this.regionIds = regionIds;
        this.productDomains = productDomains;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getRegionIds() {
        return this.regionIds;
    }

    public void setRegionIds(Set<String> regionIds) {
        this.regionIds = regionIds;
    }

    public List<ProductDomain> getProductDomains() {
        return this.productDomains;
    }

    public void setProductDomains(List<ProductDomain> productDomains) {
        this.productDomains = productDomains;
    }

    public static ProductDomain findProductDomain(String regionId, String product, List<Endpoint> endpoints) {
        if (null == regionId || null == product || null == endpoints) {
            return null;
        }
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.getRegionIds().contains(regionId)) continue;
            ProductDomain domain = Endpoint.findProductDomainByProduct(endpoint.getProductDomains(), product);
            return domain;
        }
        return null;
    }

    private static ProductDomain findProductDomainByProduct(List<ProductDomain> productDomains, String product) {
        if (null == productDomains) {
            return null;
        }
        for (ProductDomain productDomain : productDomains) {
            if (!product.equalsIgnoreCase(productDomain.getProductName())) continue;
            return productDomain;
        }
        return null;
    }
}

