/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.http.MetricsHttpAgent;
import com.alibaba.nacos.client.config.http.ServerHttpAgent;
import com.alibaba.nacos.client.config.impl.ClientWorker;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.config.utils.ParamUtils;
import com.alibaba.nacos.client.config.utils.TenantUtil;
import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.logger.support.LoggerHelper;
import com.alibaba.nacos.client.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class NacosConfigService
implements ConfigService {
    public static final Logger log = LogUtils.logger(NacosConfigService.class);
    public final long POST_TIMEOUT = 3000L;
    private HttpAgent agent;
    private ClientWorker worker;
    private String namespace;
    private String encode;
    private ConfigFilterChainManager configFilterChainManager = new ConfigFilterChainManager();

    public NacosConfigService(Properties properties) throws NacosException {
        String encodeTmp = properties.getProperty("encode");
        this.encode = StringUtils.isBlank(encodeTmp) ? "UTF-8" : encodeTmp.trim();
        String namespaceTmp = properties.getProperty("namespace");
        if (StringUtils.isBlank(namespaceTmp)) {
            this.namespace = TenantUtil.getUserTenant();
            properties.put("namespace", this.namespace);
        } else {
            this.namespace = namespaceTmp;
            properties.put("namespace", this.namespace);
        }
        this.agent = new MetricsHttpAgent(new ServerHttpAgent(properties));
        this.agent.start();
        this.worker = new ClientWorker(this.agent, this.configFilterChainManager);
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws NacosException {
        return this.getConfigInner(this.namespace, dataId, group, timeoutMs);
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.worker.addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.publishConfigInner(this.namespace, dataId, group, null, null, null, content);
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.removeConfigInner(this.namespace, dataId, group, null);
    }

    public void removeListener(String dataId, String group, Listener listener) {
        this.worker.removeTenantListener(dataId, group, listener);
    }

    private String getConfigInner(String tenant, String dataId, String group, long timeoutMs) throws NacosException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        ConfigResponse cr = new ConfigResponse();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
        if (content != null) {
            log.warn(this.agent.getName(), "[get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            cr.setContent(content);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        try {
            content = this.worker.getServerConfig(dataId, group, tenant, timeoutMs);
            cr.setContent(content);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        catch (NacosException ioe) {
            if (403 == ioe.getErrCode()) {
                throw ioe;
            }
            log.warn("NACOS-0003", LoggerHelper.getErrorCodeStr("NACOS", "NACOS-0003", "\u73af\u5883\u95ee\u9898", "get from server error"));
            log.warn(this.agent.getName(), "[get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, ioe.toString());
            log.warn(this.agent.getName(), "[get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            content = LocalConfigInfoProcessor.getSnapshot(this.agent.getName(), dataId, group, tenant);
            cr.setContent(content);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    private boolean removeConfigInner(String tenant, String dataId, String group, String tag) throws NacosException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        String url = "/v1/cs/configs";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty(tag)) {
            params.add("tag");
            params.add(tag);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpDelete(url, null, params, this.encode, 3000L);
        }
        catch (IOException ioe) {
            log.warn("[remove] error, " + dataId + ", " + group + ", " + tenant + ", msg: " + ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.agent.getName(), "[remove] ok, dataId={}, group={}, tenant={}", dataId, group, tenant);
            return true;
        }
        if (403 == result.code) {
            log.warn(this.agent.getName(), "[remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new NacosException(result.code, result.content);
        }
        log.warn(this.agent.getName(), "[remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
        return false;
    }

    private boolean publishConfigInner(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content) throws NacosException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, content);
        ConfigRequest cr = new ConfigRequest();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        cr.setContent(content);
        this.configFilterChainManager.doFilter(cr, null);
        content = cr.getContent();
        String url = "/v1/cs/configs";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty(appName)) {
            params.add("appName");
            params.add(appName);
        }
        if (StringUtils.isNotEmpty(tag)) {
            params.add("tag");
            params.add(tag);
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotEmpty(betaIps)) {
            headers.add("betaIps");
            headers.add(betaIps);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, headers, params, this.encode, 3000L);
        }
        catch (IOException ioe) {
            log.warn("NACOS-0006", LoggerHelper.getErrorCodeStr("NACOS", "NACOS-0006", "\u73af\u5883\u95ee\u9898", "[publish-single] exception"));
            log.warn(this.agent.getName(), "[publish-single] exception, dataId={}, group={}, msg={}", dataId, group, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.agent.getName(), "[publish-single] ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            return true;
        }
        if (403 == result.code) {
            log.warn(this.agent.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new NacosException(result.code, result.content);
        }
        log.warn(this.agent.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
        return false;
    }

    public String getServerStatus() {
        if (this.worker.isHealthServer()) {
            return "UP";
        }
        return "DOWN";
    }
}

