/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONPOJOBuilder;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DeserializeBeanInfo {
    private final Class<?> clazz;
    private final Class<?> builderClass;
    private Constructor<?> defaultConstructor;
    private Constructor<?> creatorConstructor;
    private Method factoryMethod;
    private Method buildMethod;
    private final List<FieldInfo> fieldList = new ArrayList<FieldInfo>();
    private final List<FieldInfo> sortedFieldList = new ArrayList<FieldInfo>();
    private int parserFeatures = 0;

    public DeserializeBeanInfo(Class<?> clazz) {
        this(clazz, DeserializeBeanInfo.getBuilderClass(clazz));
    }

    public DeserializeBeanInfo(Class<?> clazz, Class<?> builderClass) {
        this.clazz = clazz;
        this.builderClass = builderClass;
        this.parserFeatures = TypeUtils.getParserFeatures(clazz);
    }

    public Constructor<?> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public void setDefaultConstructor(Constructor<?> defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    public Constructor<?> getCreatorConstructor() {
        return this.creatorConstructor;
    }

    public void setCreatorConstructor(Constructor<?> createConstructor) {
        this.creatorConstructor = createConstructor;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(Method factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public Method getBuildMethod() {
        return this.buildMethod;
    }

    public void setBuildMethod(Method buildMethod) {
        this.buildMethod = buildMethod;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Class<?> getBuilderClass() {
        return this.builderClass;
    }

    public List<FieldInfo> getFieldList() {
        return this.fieldList;
    }

    public List<FieldInfo> getSortedFieldList() {
        return this.sortedFieldList;
    }

    public FieldInfo getField(String propertyName) {
        for (FieldInfo item : this.fieldList) {
            if (!item.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    public boolean add(FieldInfo field) {
        for (FieldInfo item : this.fieldList) {
            if (!item.getName().equals(field.getName()) || item.isGetOnly() && !field.isGetOnly()) continue;
            if (item.getFieldClass().isAssignableFrom(field.getFieldClass())) {
                this.fieldList.remove(item);
                break;
            }
            return false;
        }
        this.fieldList.add(field);
        this.sortedFieldList.add(field);
        Collections.sort(this.sortedFieldList);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static DeserializeBeanInfo computeSetters(Class<?> clazz, Type type) {
        String propertyName;
        DeserializeBeanInfo beanInfo = new DeserializeBeanInfo(clazz);
        Class<?> builderClass = beanInfo.getBuilderClass();
        Constructor<?> defaultConstructor = DeserializeBeanInfo.getDefaultConstructor(builderClass == null ? clazz : builderClass);
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(defaultConstructor);
            beanInfo.setDefaultConstructor(defaultConstructor);
        } else if (defaultConstructor == null && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            Constructor<?> creatorConstructor = DeserializeBeanInfo.getCreatorConstructor(clazz);
            if (creatorConstructor != null) {
                TypeUtils.setAccessible(creatorConstructor);
                beanInfo.setCreatorConstructor(creatorConstructor);
                for (int i = 0; i < creatorConstructor.getParameterTypes().length; ++i) {
                    void var8_15;
                    Annotation[] paramAnnotations = creatorConstructor.getParameterAnnotations()[i];
                    Object var8_16 = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        JSONField jSONField = (JSONField)paramAnnotation;
                        break;
                    }
                    if (var8_15 == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = creatorConstructor.getParameterTypes()[i];
                    Type fieldType = creatorConstructor.getGenericParameterTypes()[i];
                    Field field = TypeUtils.getField(clazz, var8_15.name());
                    int ordinal = var8_15.ordinal();
                    int serialzeFeatures = SerializerFeature.of(var8_15.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(var8_15.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    beanInfo.add(fieldInfo);
                }
                return beanInfo;
            }
            Method factoryMethod = DeserializeBeanInfo.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                TypeUtils.setAccessible(factoryMethod);
                beanInfo.setFactoryMethod(factoryMethod);
                for (int i = 0; i < factoryMethod.getParameterTypes().length; ++i) {
                    Annotation[] annotationArray = factoryMethod.getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : annotationArray) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = factoryMethod.getParameterTypes()[i];
                    Type fieldType = factoryMethod.getGenericParameterTypes()[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name());
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    beanInfo.add(fieldInfo);
                }
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        if (builderClass != null) {
            String withPrefix = null;
            JSONPOJOBuilder builderAnno = builderClass.getAnnotation(JSONPOJOBuilder.class);
            if (builderAnno != null) {
                withPrefix = builderAnno.withPrefix();
            }
            if (withPrefix == null || withPrefix.length() == 0) {
                withPrefix = "with";
            }
            for (Method method : builderClass.getMethods()) {
                char c0;
                String methodName;
                if (Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(builderClass)) continue;
                int ordinal = 0;
                int serialzeFeatures = 0;
                JSONField annotation = method.getAnnotation(JSONField.class);
                if (annotation == null) {
                    annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                }
                if (annotation != null) {
                    if (!annotation.deserialize()) continue;
                    ordinal = annotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                    if (annotation.name().length() != 0) {
                        propertyName = annotation.name();
                        beanInfo.add(new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures));
                        TypeUtils.setAccessible(method);
                        continue;
                    }
                }
                if (!(methodName = method.getName()).startsWith(withPrefix) || methodName.length() <= withPrefix.length() || !Character.isUpperCase(c0 = methodName.charAt(withPrefix.length()))) continue;
                StringBuilder properNameBuilder = new StringBuilder(methodName.substring(withPrefix.length()));
                properNameBuilder.setCharAt(0, Character.toLowerCase(c0));
                String propertyName2 = properNameBuilder.toString();
                beanInfo.add(new FieldInfo(propertyName2, method, null, clazz, type, ordinal, serialzeFeatures));
                TypeUtils.setAccessible(method);
            }
            if (builderClass != null) {
                void var8_22;
                JSONPOJOBuilder builderAnnotation = builderClass.getAnnotation(JSONPOJOBuilder.class);
                Object var8_20 = null;
                if (builderAnnotation != null) {
                    String string = builderAnnotation.buildMethod();
                }
                if (var8_22 == null || var8_22.length() == 0) {
                    String string = "build";
                }
                Method buildMethod = null;
                try {
                    void var8_24;
                    buildMethod = builderClass.getMethod((String)var8_24, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (buildMethod == null) {
                    try {
                        buildMethod = builderClass.getMethod("create", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
                if (buildMethod == null) {
                    throw new JSONException("buildMethod not found.");
                }
                beanInfo.setBuildMethod(buildMethod);
                TypeUtils.setAccessible(buildMethod);
            }
        }
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().equals(clazz) || method.getParameterTypes().length != 1) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation == null) {
                annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
            }
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                ordinal = annotation.ordinal();
                serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                if (annotation.name().length() != 0) {
                    String propertyName3 = annotation.name();
                    beanInfo.add(new FieldInfo(propertyName3, method, null, clazz, type, ordinal, serialzeFeatures));
                    TypeUtils.setAccessible(method);
                    continue;
                }
            }
            if (!methodName.startsWith("set")) continue;
            char c3 = methodName.charAt(3);
            if (Character.isUpperCase(c3) || c3 > '\u0200') {
                propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            } else if (c3 == '_') {
                propertyName = methodName.substring(4);
            } else if (c3 == 'f') {
                propertyName = methodName.substring(3);
            } else {
                if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                propertyName = TypeUtils.decapitalize(methodName.substring(3));
            }
            Field field = TypeUtils.getField(clazz, propertyName);
            if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                field = TypeUtils.getField(clazz, isFieldName);
            }
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    beanInfo.add(new FieldInfo(propertyName, method, field, clazz, type, ordinal, serialzeFeatures));
                    continue;
                }
            }
            beanInfo.add(new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures));
            TypeUtils.setAccessible(method);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            boolean contains = false;
            for (FieldInfo item : beanInfo.getFieldList()) {
                if (!item.getName().equals(((Field)accessibleObject).getName())) continue;
                contains = true;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String propertyName4 = ((Field)accessibleObject).getName();
            JSONField fieldAnnotation = ((Field)accessibleObject).getAnnotation(JSONField.class);
            if (fieldAnnotation != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName4 = fieldAnnotation.name();
                }
            }
            beanInfo.add(new FieldInfo(propertyName4, null, (Field)accessibleObject, clazz, type, ordinal, serialzeFeatures));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            String propertyName2;
            String methodName = ((Method)accessibleObject).getName();
            if (methodName.length() < 4 || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !methodName.startsWith("get") || !Character.isUpperCase(methodName.charAt(3)) || ((Method)accessibleObject).getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(((Method)accessibleObject).getReturnType()) && !Map.class.isAssignableFrom(((Method)accessibleObject).getReturnType()) && AtomicBoolean.class != ((Method)accessibleObject).getReturnType() && AtomicInteger.class != ((Method)accessibleObject).getReturnType() && AtomicLong.class != ((Method)accessibleObject).getReturnType()) continue;
            JSONField annotation = ((Method)accessibleObject).getAnnotation(JSONField.class);
            if (annotation != null && annotation.name().length() > 0) {
                String propertyName5 = annotation.name();
            } else {
                propertyName2 = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            }
            FieldInfo fieldInfo = beanInfo.getField(propertyName2);
            if (fieldInfo != null) continue;
            beanInfo.add(new FieldInfo(propertyName2, (Method)accessibleObject, null, clazz, type));
            TypeUtils.setAccessible(accessibleObject);
        }
        return beanInfo;
    }

    public static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }

    public static Constructor<?> getCreatorConstructor(Class<?> clazz) {
        Constructor<?> creatorConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
            if (annotation == null) continue;
            if (creatorConstructor != null) {
                throw new JSONException("multi-json creator");
            }
            creatorConstructor = constructor;
            break;
        }
        return creatorConstructor;
    }

    public static Method getFactoryMethod(Class<?> clazz) {
        Method factoryMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            JSONCreator annotation;
            if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType()) || (annotation = method.getAnnotation(JSONCreator.class)) == null) continue;
            if (factoryMethod != null) {
                throw new JSONException("multi-json creator");
            }
            factoryMethod = method;
            break;
        }
        return factoryMethod;
    }

    public int getParserFeatures() {
        return this.parserFeatures;
    }

    public static Class<?> getBuilderClass(Class<?> clazz) {
        JSONType type = clazz.getAnnotation(JSONType.class);
        if (type == null) {
            return null;
        }
        Class<?> builderClass = type.builder();
        if (builderClass == Void.class) {
            return null;
        }
        return builderClass;
    }
}

