/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterCharacter;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAnalyzePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCheckPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCoalescePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableConvertCharSet;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDiscardPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableImportPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableOptimizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReOrganizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRebuildPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRepairPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTruncatePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLLoopStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWhileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.ConditionValue;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCursorDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareConditionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareHandlerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlHandlerType;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlIterateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlLeaveStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlRepeatStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlSelectIntoStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterLogFileGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterServerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAlterColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableDiscardTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableImportTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAnalyzeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBinlogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlChecksumTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateAddLogFileGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateServerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableSpaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlEventSchedule;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExplainStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlFlushStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHelpStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLockTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlOptimizeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlResetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowAuthorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinaryLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCharacterSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCollationStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowContributorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTriggerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasePartitionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEngineStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEnginesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowErrorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowIndexesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowKeysStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowOpenTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPluginsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPrivilegesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcessListStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowRelayLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveHostsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTableStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTriggersStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowVariantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnlockTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MysqlDeallocatePrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlCreateTableParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectIntoParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.InsertColumnsCache;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class MySqlStatementParser
extends SQLStatementParser {
    private static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String COLLATE2 = "COLLATE";
    private static final String CHAIN = "CHAIN";
    private static final String ENGINES = "ENGINES";
    private static final String ENGINE = "ENGINE";
    private static final String BINLOG = "BINLOG";
    private static final String EVENTS = "EVENTS";
    private static final String SESSION = "SESSION";
    private static final String GLOBAL = "GLOBAL";
    private static final String VARIABLES = "VARIABLES";
    private static final String STATUS = "STATUS";
    private static final String RESET = "RESET";
    private static final String DESCRIBE = "DESCRIBE";
    private static final String WRITE = "WRITE";
    private static final String READ = "READ";
    private static final String LOCAL = "LOCAL";
    private static final String TABLES = "TABLES";
    private static final String TEMPORARY = "TEMPORARY";
    private static final String SPATIAL = "SPATIAL";
    private static final String LOW_PRIORITY = "LOW_PRIORITY";
    private static final String CONNECTION = "CONNECTION";
    private static final String EXTENDED = "EXTENDED";
    private static final String PARTITIONS = "PARTITIONS";
    private static final String FORMAT = "FORMAT";
    private int maxIntoClause = -1;

    public MySqlStatementParser(String sql) {
        super(new MySqlExprParser(sql));
    }

    public MySqlStatementParser(String sql, SQLParserFeature ... features) {
        super(new MySqlExprParser(sql, features));
    }

    public MySqlStatementParser(String sql, boolean keepComments) {
        super(new MySqlExprParser(sql, keepComments));
    }

    public MySqlStatementParser(String sql, boolean skipComment, boolean keepComments) {
        super(new MySqlExprParser(sql, skipComment, keepComments));
    }

    public MySqlStatementParser(Lexer lexer) {
        super(new MySqlExprParser(lexer));
    }

    public int getMaxIntoClause() {
        return this.maxIntoClause;
    }

    public void setMaxIntoClause(int maxIntoClause) {
        this.maxIntoClause = maxIntoClause;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        MySqlCreateTableParser parser = new MySqlCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLStatement parseSelect() {
        MySqlSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        if (selectParser.returningFlag) {
            return selectParser.updateStmt;
        }
        return new SQLSelectStatement(select, "mysql");
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        return new MySqlSelectParser(this.exprParser, this.selectListCache).parseUpdateStatment();
    }

    @Override
    protected MySqlUpdateStatement createUpdateStatement() {
        return new MySqlUpdateStatement();
    }

    @Override
    public MySqlDeleteStatement parseDeleteStatement() {
        MySqlDeleteStatement deleteStatement = new MySqlDeleteStatement();
        if (this.lexer.token() == Token.DELETE) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.HINT) {
                this.getExprParser().parseHints(deleteStatement.getHints());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LOW_PRIORITY)) {
                deleteStatement.setLowPriority(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals("QUICK")) {
                deleteStatement.setQuick(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
                deleteStatement.setIgnore(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                Lexer.SavePoint savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.ALL) {
                    this.lexer.nextToken();
                    this.acceptIdentifier(PARTITIONS);
                    deleteStatement.setForceAllPartitions(true);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                    this.lexer.nextToken();
                    deleteStatement.setForceAllPartitions(true);
                } else if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    SQLName partition = this.exprParser.name();
                    deleteStatement.setForcePartition(partition);
                } else {
                    this.lexer.reset(savePoint);
                }
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                deleteStatement.setTableSource(this.createSQLSelectParser().parseTableSource());
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    tableSource = this.createSQLSelectParser().parseTableSource();
                    deleteStatement.setFrom(tableSource);
                }
            } else if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                deleteStatement.setTableSource(this.createSQLSelectParser().parseTableSource());
            } else {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                this.lexer.nextToken();
                tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setUsing(tableSource);
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            deleteStatement.setOrderBy(orderBy);
        }
        deleteStatement.setLimit(this.exprParser.parseLimit());
        return deleteStatement;
    }

    @Override
    public SQLStatement parseCreate() {
        char markChar = this.lexer.current();
        int markBp = this.lexer.bp();
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.CREATE);
        boolean replace = false;
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            replace = true;
        }
        List<SQLCommentHint> hints = this.exprParser.parseHints();
        if (this.lexer.token() == Token.TABLE || this.lexer.identifierEquals(TEMPORARY)) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            MySqlCreateTableParser parser = new MySqlCreateTableParser(this.exprParser);
            MySqlCreateTableStatement stmt = parser.parseCreateTable(false);
            stmt.setHints(hints);
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            return stmt;
        }
        if (this.lexer.token() == Token.DATABASE || this.lexer.token() == Token.SCHEMA) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateDatabase();
        }
        if (this.lexer.token() == Token.UNIQUE || this.lexer.token() == Token.INDEX || this.lexer.token() == Token.FULLTEXT || this.lexer.identifierEquals(SPATIAL)) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateIndex(false);
        }
        if (this.lexer.token() == Token.USER) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateUser();
        }
        if (this.lexer.token() == Token.VIEW || this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateView();
        }
        if (this.lexer.token() == Token.TRIGGER) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateTrigger();
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateProcedure();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            this.getExprParser().userName();
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
                this.lexer.nextToken();
                this.acceptIdentifier("SECURITY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.EVENT)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateEvent();
            }
            if (this.lexer.token() == Token.TRIGGER) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateTrigger();
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateView();
            }
            if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateFunction();
            }
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateProcedure();
        }
        if (this.lexer.token() == Token.FUNCTION) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateFunction();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOGFILE)) {
            return this.parseCreateLogFileGroup();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SERVER)) {
            return this.parseCreateServer();
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            return this.parseCreateTableSpace();
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseCreateTableSpace() {
        if (this.lexer.token() == Token.CREATE) {
            this.accept(Token.CREATE);
        }
        MySqlCreateTableSpaceStatement stmt = new MySqlCreateTableSpaceStatement();
        this.accept(Token.TABLESPACE);
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.ADD)) {
            this.lexer.nextToken();
            this.acceptIdentifier("DATAFILE");
            SQLExpr file = this.exprParser.primary();
            stmt.setAddDataFile(file);
        }
        while (true) {
            SQLExpr size;
            SQLExpr extentSize;
            if (this.lexer.identifierEquals(FnvHash.Constants.INITIAL_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr initialSize = this.exprParser.expr();
                stmt.setInitialSize(initialSize);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FILE_BLOCK_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr fileBlockSize = this.exprParser.expr();
                stmt.setFileBlockSize(fileBlockSize);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.EXTENT_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                extentSize = this.exprParser.expr();
                stmt.setExtentSize(extentSize);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.AUTOEXTEND_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                extentSize = this.exprParser.expr();
                stmt.setAutoExtentSize(extentSize);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MAX_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                size = this.exprParser.expr();
                stmt.setMaxSize(size);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NODEGROUP)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                size = this.exprParser.expr();
                stmt.setNodeGroup(size);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
                this.lexer.nextToken();
                stmt.setWait(true);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr engine = this.exprParser.expr();
                stmt.setEngine(engine);
                continue;
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLExpr comment = this.exprParser.expr();
                stmt.setComment(comment);
                continue;
            }
            if (this.lexer.token() != Token.USE) break;
            this.lexer.nextToken();
            this.acceptIdentifier("LOGFILE");
            this.accept(Token.GROUP);
            SQLExpr logFileGroup = this.exprParser.expr();
            stmt.setFileBlockSize(logFileGroup);
        }
        return stmt;
    }

    public SQLStatement parseCreateServer() {
        if (this.lexer.token() == Token.CREATE) {
            this.accept(Token.CREATE);
        }
        MySqlCreateServerStatement stmt = new MySqlCreateServerStatement();
        this.acceptIdentifier("SERVER");
        stmt.setName(this.exprParser.name());
        this.accept(Token.FOREIGN);
        this.acceptIdentifier("DATA");
        this.acceptIdentifier("WRAPPER");
        stmt.setForeignDataWrapper(this.exprParser.name());
        this.acceptIdentifier("OPTIONS");
        this.accept(Token.LPAREN);
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.HOST)) {
                this.lexer.nextToken();
                SQLExpr host = this.exprParser.expr();
                stmt.setHost(host);
            } else if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                SQLExpr user = this.exprParser.expr();
                stmt.setUser(user);
            } else if (this.lexer.token() == Token.DATABASE) {
                this.lexer.nextToken();
                SQLExpr db = this.exprParser.expr();
                stmt.setDatabase(db);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PASSWORD)) {
                this.lexer.nextToken();
                SQLExpr pwd = this.exprParser.expr();
                stmt.setPassword(pwd);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SOCKET)) {
                this.lexer.nextToken();
                SQLExpr sock = this.exprParser.expr();
                stmt.setSocket(sock);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
                this.lexer.nextToken();
                SQLExpr owner = this.exprParser.expr();
                stmt.setOwner(owner);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PORT)) {
                this.lexer.nextToken();
                SQLExpr port = this.exprParser.expr();
                stmt.setPort(port);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return stmt;
    }

    @Override
    public SQLStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement();
        if (this.lexer.token() == Token.UNIQUE) {
            stmt.setType("UNIQUE");
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.FULLTEXT) {
            stmt.setType("FULLTEXT");
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(SPATIAL)) {
            stmt.setType(SPATIAL);
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.parseCreateIndexUsing(stmt);
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                this.parseCreateIndexUsing(stmt);
                continue;
            }
            if (this.lexer.token() != Token.COMMENT) break;
            this.lexer.nextToken();
            SQLExpr comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        return stmt;
    }

    private void parseCreateIndexUsing(SQLCreateIndexStatement stmt) {
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.BTREE)) {
                stmt.setUsing("BTREE");
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.HASH)) {
                stmt.setUsing("HASH");
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
    }

    @Override
    public SQLStatement parseCreateUser() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.USER);
        MySqlCreateUserStatement stmt = new MySqlCreateUserStatement();
        while (true) {
            MySqlCreateUserStatement.UserSpecification userSpec = new MySqlCreateUserStatement.UserSpecification();
            SQLExpr expr = this.exprParser.primary();
            userSpec.setUser(expr);
            if (this.lexer.token() == Token.IDENTIFIED) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.BY) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("PASSWORD")) {
                        this.lexer.nextToken();
                        userSpec.setPasswordHash(true);
                    }
                    SQLCharExpr password = (SQLCharExpr)this.exprParser.expr();
                    userSpec.setPassword(password);
                } else if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    userSpec.setAuthPlugin(this.exprParser.expr());
                }
            }
            stmt.addUser(userSpec);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLStatement parseKill() {
        this.accept(Token.KILL);
        MySqlKillStatement stmt = new MySqlKillStatement();
        if (this.lexer.identifierEquals(CONNECTION)) {
            stmt.setType(MySqlKillStatement.Type.CONNECTION);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("QUERY")) {
            stmt.setType(MySqlKillStatement.Type.QUERY);
            this.lexer.nextToken();
        } else if (this.lexer.token() != Token.LITERAL_INT) {
            throw new ParserException("not support kill type " + (Object)((Object)this.lexer.token()) + ". " + this.lexer.info());
        }
        this.exprParser.exprList(stmt.getThreadIds(), stmt);
        return stmt;
    }

    public SQLStatement parseBinlog() {
        this.acceptIdentifier("binlog");
        MySqlBinlogStatement stmt = new MySqlBinlogStatement();
        SQLExpr expr = this.exprParser.expr();
        stmt.setExpr(expr);
        return stmt;
    }

    public MySqlAnalyzeStatement parseAnalyze() {
        this.accept(Token.ANALYZE);
        this.accept(Token.TABLE);
        MySqlAnalyzeStatement stmt = new MySqlAnalyzeStatement();
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            stmt.addTableSource(new SQLExprTableSource(name));
        }
        return stmt;
    }

    public MySqlOptimizeStatement parseOptimize() {
        this.accept(Token.OPTIMIZE);
        this.accept(Token.TABLE);
        MySqlOptimizeStatement stmt = new MySqlOptimizeStatement();
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            stmt.addTableSource(new SQLExprTableSource(name));
        }
        return stmt;
    }

    public SQLStatement parseReset() {
        this.acceptIdentifier(RESET);
        MySqlResetStatement stmt = new MySqlResetStatement();
        while (this.lexer.token() == Token.IDENTIFIER) {
            if (this.lexer.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.accept(Token.CACHE);
                stmt.getOptions().add("QUERY CACHE");
            } else {
                stmt.getOptions().add(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.identifierEquals("PREPARE")) {
            MySqlPrepareStatement stmt = this.parsePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("EXECUTE")) {
            MySqlExecuteStatement stmt = this.parseExecute();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("DEALLOCATE")) {
            MysqlDeallocatePrepareStatement stmt = this.parseDeallocatePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("LOAD")) {
            SQLStatement stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.REPLACE) {
            SQLReplaceStatement stmt = this.parseReplace();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("START")) {
            SQLStartTransactionStatement stmt = this.parseStart();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.SHOW) {
            SQLStatement stmt = this.parseShow();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.EXPLAIN) {
            MySqlExplainStatement stmt = this.parseExplain();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(BINLOG)) {
            SQLStatement stmt = this.parseBinlog();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(RESET)) {
            SQLStatement stmt = this.parseReset();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.ANALYZE) {
            MySqlAnalyzeStatement stmt = this.parseAnalyze();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.OPTIMIZE) {
            MySqlOptimizeStatement stmt = this.parseOptimize();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("HELP")) {
            this.lexer.nextToken();
            MySqlHelpStatement stmt = new MySqlHelpStatement();
            stmt.setContent(this.exprParser.primary());
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("FLUSH")) {
            SQLStatement stmt = this.parseFlush();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.DESC || this.lexer.identifierEquals(DESCRIBE)) {
            MySqlExplainStatement stmt = this.parseDescribe();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.LOCK) {
            boolean isLockTable;
            this.lexer.nextToken();
            String val = this.lexer.stringVal();
            boolean isLockTables = TABLES.equalsIgnoreCase(val) && this.lexer.token() == Token.IDENTIFIER;
            boolean bl = isLockTable = "TABLE".equalsIgnoreCase(val) && this.lexer.token() == Token.TABLE;
            if (!isLockTables && !isLockTable) {
                this.setErrorEndPos(this.lexer.pos());
                throw new ParserException("syntax error, expect TABLES or TABLE, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
            }
            this.lexer.nextToken();
            MySqlLockTableStatement stmt = new MySqlLockTableStatement();
            while (true) {
                MySqlLockTableStatement.Item item = new MySqlLockTableStatement.Item();
                SQLExprTableSource tableSource = null;
                SQLName tableName = this.exprParser.name();
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    String as = this.lexer.stringVal();
                    tableSource = new SQLExprTableSource(tableName, as);
                    this.lexer.nextToken();
                } else {
                    tableSource = new SQLExprTableSource(tableName);
                }
                item.setTableSource(tableSource);
                stmt.getItems().add(item);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.identifierEquals(READ)) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(LOCAL)) {
                        this.lexer.nextToken();
                        item.setLockType(MySqlLockTableStatement.LockType.READ_LOCAL);
                    } else {
                        item.setLockType(MySqlLockTableStatement.LockType.READ);
                    }
                } else if (this.lexer.identifierEquals(WRITE)) {
                    this.lexer.nextToken();
                    item.setLockType(MySqlLockTableStatement.LockType.WRITE);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.LOW_PRIORITY)) {
                    this.lexer.nextToken();
                    this.acceptIdentifier(WRITE);
                    this.lexer.nextToken();
                    item.setLockType(MySqlLockTableStatement.LockType.LOW_PRIORITY_WRITE);
                } else {
                    throw new ParserException("syntax error, expect READ or WRITE OR AS, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
                }
                if (this.lexer.token() == Token.HINT) {
                    item.setHints(this.exprParser.parseHints());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("UNLOCK")) {
            this.lexer.nextToken();
            String val = this.lexer.stringVal();
            boolean isUnLockTables = TABLES.equalsIgnoreCase(val) && this.lexer.token() == Token.IDENTIFIER;
            boolean isUnLockTable = "TABLE".equalsIgnoreCase(val) && this.lexer.token() == Token.TABLE;
            statementList.add(new MySqlUnlockTablesStatement());
            if (!isUnLockTables && !isUnLockTable) {
                this.setErrorEndPos(this.lexer.pos());
                throw new ParserException("syntax error, expect TABLES or TABLE, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
            }
            this.lexer.nextToken();
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHECKSUM)) {
            statementList.add(this.parseChecksum());
            return true;
        }
        if (this.lexer.token() == Token.HINT) {
            SQLStatementImpl stmt;
            List<SQLCommentHint> hints = this.exprParser.parseHints();
            boolean tddlHints = false;
            boolean accept = false;
            boolean acceptHint = false;
            switch (this.lexer.token()) {
                case SELECT: 
                case WITH: 
                case DELETE: 
                case UPDATE: 
                case INSERT: 
                case SHOW: 
                case REPLACE: 
                case TRUNCATE: 
                case DROP: 
                case ALTER: 
                case CREATE: 
                case CHECK: 
                case SET: {
                    acceptHint = true;
                    break;
                }
                case IDENTIFIER: {
                    acceptHint = this.lexer.hash_lower() == FnvHash.Constants.DUMP || this.lexer.hash_lower() == FnvHash.Constants.RENAME;
                    break;
                }
            }
            if (hints.size() == 1 && statementList.size() == 0 && acceptHint) {
                SQLCommentHint hint = hints.get(0);
                String hintText = hint.getText().toUpperCase();
                if (hintText.startsWith("+TDDL") || hintText.startsWith("+ TDDL") || hintText.startsWith("TDDL") || hintText.startsWith("!TDDL")) {
                    tddlHints = true;
                } else if (hintText.startsWith("+")) {
                    accept = true;
                }
            }
            if (tddlHints) {
                stmt = (SQLStatementImpl)this.parseStatement();
                stmt.setHeadHints(hints);
                statementList.add(stmt);
                return true;
            }
            if (accept) {
                stmt = (SQLStatementImpl)this.parseStatement();
                stmt.setHeadHints(hints);
                statementList.add(stmt);
                return true;
            }
            stmt = new MySqlHintStatement();
            ((MySqlHintStatement)stmt).setHints(hints);
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.BEGIN) {
            statementList.add(this.parseBlock());
            return true;
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            String label = this.lexer.stringVal();
            char ch = this.lexer.current();
            int bp = this.lexer.bp();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.VARIANT && this.lexer.stringVal().equals(":")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LOOP) {
                    statementList.add(this.parseLoop(label));
                } else if (this.lexer.token() == Token.WHILE) {
                    statementList.add(this.parseWhile(label));
                } else if (this.lexer.token() == Token.BEGIN) {
                    SQLBlockStatement block = this.parseBlock(label);
                    statementList.add(block);
                } else if (this.lexer.token() == Token.REPEAT) {
                    statementList.add(this.parseRepeat(label));
                }
                return true;
            }
            this.lexer.reset(bp, ch, Token.IDENTIFIER);
        }
        return false;
    }

    public SQLStatement parseFlush() {
        this.acceptIdentifier("FLUSH");
        MySqlFlushStatement stmt = new MySqlFlushStatement();
        if (this.lexer.identifierEquals("NO_WRITE_TO_BINLOG")) {
            this.lexer.nextToken();
            stmt.setNoWriteToBinlog(true);
        }
        if (this.lexer.identifierEquals(LOCAL)) {
            this.lexer.nextToken();
            stmt.setLocal(true);
        }
        while (true) {
            if (this.lexer.token() == Token.BINARY || this.lexer.identifierEquals("BINARY")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOGS");
                stmt.setBinaryLogs(true);
                continue;
            }
            if (this.lexer.identifierEquals("DES_KEY_FILE")) {
                this.lexer.nextToken();
                stmt.setDesKeyFile(true);
                continue;
            }
            if (this.lexer.identifierEquals(ENGINE)) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOGS");
                stmt.setEngineLogs(true);
                continue;
            }
            if (this.lexer.identifierEquals("ERROR")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOGS");
                stmt.setErrorLogs(true);
                continue;
            }
            if (this.lexer.identifierEquals("GENERAL")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOGS");
                stmt.setGeneralLogs(true);
                continue;
            }
            if (this.lexer.identifierEquals("HOSTS")) {
                this.lexer.nextToken();
                stmt.setHots(true);
                continue;
            }
            if (this.lexer.identifierEquals("LOGS")) {
                this.lexer.nextToken();
                stmt.setLogs(true);
                continue;
            }
            if (this.lexer.identifierEquals("PRIVILEGES")) {
                this.lexer.nextToken();
                stmt.setPrivileges(true);
                continue;
            }
            if (this.lexer.identifierEquals("OPTIMIZER_COSTS")) {
                this.lexer.nextToken();
                stmt.setOptimizerCosts(true);
                continue;
            }
            if (this.lexer.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.accept(Token.CACHE);
                stmt.setQueryCache(true);
                continue;
            }
            if (this.lexer.identifierEquals("RELAY")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOGS");
                stmt.setRelayLogs(true);
                if (this.lexer.token() != Token.FOR) continue;
                this.lexer.nextToken();
                this.acceptIdentifier("CHANNEL");
                stmt.setRelayLogsForChannel(this.exprParser.primary());
                continue;
            }
            if (this.lexer.identifierEquals("SLOW")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOGS");
                stmt.setSlowLogs(true);
                continue;
            }
            if (this.lexer.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                stmt.setStatus(true);
                continue;
            }
            if (this.lexer.identifierEquals("USER_RESOURCES")) {
                this.lexer.nextToken();
                stmt.setUserResources(true);
                continue;
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(TABLES)) {
            this.lexer.nextToken();
            stmt.setTableOption(true);
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier(READ);
                this.accept(Token.LOCK);
                stmt.setWithReadLock(true);
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                while (true) {
                    SQLName name = this.exprParser.name();
                    stmt.addTable(name);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (stmt.getTables().size() != 0) {
                if (this.lexer.token() == Token.FOR) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("EXPORT");
                    stmt.setForExport(true);
                } else if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier(READ);
                    this.accept(Token.LOCK);
                    stmt.setWithReadLock(true);
                }
            }
        }
        return stmt;
    }

    @Override
    public SQLBlockStatement parseBlock() {
        SQLBlockStatement block = new SQLBlockStatement();
        block.setDbType(this.dbType);
        this.accept(Token.BEGIN);
        List<SQLStatement> statementList = block.getStatementList();
        this.parseStatementList(statementList, -1, block);
        if (this.lexer.token() != Token.END && statementList.size() > 0 && (statementList.get(statementList.size() - 1) instanceof SQLCommitStatement || statementList.get(statementList.size() - 1) instanceof SQLRollbackStatement)) {
            block.setEndOfCommit(true);
            return block;
        }
        this.accept(Token.END);
        return block;
    }

    @Override
    public MySqlExplainStatement parseDescribe() {
        MySqlExplainStatement describe = new MySqlExplainStatement();
        if (this.lexer.token() != Token.DESC && !this.lexer.identifierEquals(DESCRIBE)) {
            throw new ParserException("expect one of {DESCRIBE | DESC} , actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
        }
        this.lexer.nextToken();
        describe.setDescribe(true);
        return this.parseExplain(describe);
    }

    @Override
    public MySqlExplainStatement parseExplain() {
        MySqlExplainStatement explain = new MySqlExplainStatement();
        if (this.lexer.token() != Token.EXPLAIN) {
            throw new ParserException("expect EXPLAIN , actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
        }
        this.lexer.nextToken();
        return this.parseExplain(explain);
    }

    private MySqlExplainStatement parseExplain(MySqlExplainStatement explain) {
        if (this.lexer.token() == Token.HINT) {
            List<SQLCommentHint> hints = this.exprParser.parseHints();
            explain.setHints(hints);
        }
        boolean table = false;
        if (this.lexer.token() == Token.IDENTIFIER) {
            String stringVal = this.lexer.stringVal();
            if (stringVal.equalsIgnoreCase(EXTENDED) || stringVal.equalsIgnoreCase(PARTITIONS)) {
                explain.setType(stringVal);
                this.lexer.nextToken();
            } else if (stringVal.equalsIgnoreCase(FORMAT)) {
                explain.setType(stringVal);
                this.lexer.nextToken();
                this.accept(Token.EQ);
                String format = this.lexer.stringVal();
                explain.setFormat(format);
                this.accept(Token.IDENTIFIER);
            } else {
                explain.setTableName(this.exprParser.name());
                if (this.lexer.token() == Token.IDENTIFIER) {
                    explain.setColumnName(this.exprParser.name());
                } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                    explain.setWild(this.exprParser.expr());
                }
                table = true;
            }
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.acceptIdentifier(CONNECTION);
            explain.setConnectionId(this.exprParser.expr());
        } else if (!table) {
            explain.setStatement(this.parseStatement());
        }
        return explain;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        boolean full = false;
        if (this.lexer.token() == Token.FULL) {
            this.lexer.nextToken();
            full = true;
        }
        if (this.lexer.identifierEquals("PROCESSLIST")) {
            this.lexer.nextToken();
            MySqlShowProcessListStatement stmt = new MySqlShowProcessListStatement();
            stmt.setFull(full);
            return stmt;
        }
        if (this.lexer.identifierEquals("COLUMNS") || this.lexer.identifierEquals("FIELDS")) {
            this.lexer.nextToken();
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            stmt.setFull(full);
            return stmt;
        }
        if (this.lexer.identifierEquals("COLUMNS")) {
            this.lexer.nextToken();
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            return stmt;
        }
        if (this.lexer.identifierEquals(TABLES)) {
            this.lexer.nextToken();
            SQLShowTablesStatement stmt = this.parseShowTabless();
            stmt.setFull(full);
            return stmt;
        }
        if (this.lexer.identifierEquals("DATABASES")) {
            this.lexer.nextToken();
            MySqlShowDatabasesStatement stmt = this.parseShowDatabases();
            return stmt;
        }
        if (this.lexer.identifierEquals("WARNINGS")) {
            this.lexer.nextToken();
            MySqlShowWarningsStatement stmt = this.parseShowWarnings();
            return stmt;
        }
        if (this.lexer.identifierEquals("COUNT")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.accept(Token.STAR);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.ERRORS)) {
                this.lexer.nextToken();
                MySqlShowErrorsStatement stmt = new MySqlShowErrorsStatement();
                stmt.setCount(true);
                return stmt;
            }
            this.acceptIdentifier("WARNINGS");
            MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
            stmt.setCount(true);
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ERRORS)) {
            this.lexer.nextToken();
            MySqlShowErrorsStatement stmt = new MySqlShowErrorsStatement();
            stmt.setLimit(this.exprParser.parseLimit());
            return stmt;
        }
        if (this.lexer.identifierEquals(STATUS)) {
            this.lexer.nextToken();
            MySqlShowStatusStatement stmt = this.parseShowStatus();
            return stmt;
        }
        if (this.lexer.identifierEquals(VARIABLES)) {
            this.lexer.nextToken();
            MySqlShowVariantsStatement stmt = this.parseShowVariants();
            return stmt;
        }
        if (this.lexer.identifierEquals(GLOBAL)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setGlobal(true);
                return stmt;
            }
            if (this.lexer.identifierEquals(VARIABLES)) {
                this.lexer.nextToken();
                MySqlShowVariantsStatement stmt = this.parseShowVariants();
                stmt.setGlobal(true);
                return stmt;
            }
        }
        if (this.lexer.identifierEquals(SESSION)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setSession(true);
                return stmt;
            }
            if (this.lexer.identifierEquals(VARIABLES)) {
                this.lexer.nextToken();
                MySqlShowVariantsStatement stmt = this.parseShowVariants();
                stmt.setSession(true);
                return stmt;
            }
        }
        if (this.lexer.identifierEquals("COBAR_STATUS")) {
            this.lexer.nextToken();
            return new CobarShowStatus();
        }
        if (this.lexer.identifierEquals("AUTHORS")) {
            this.lexer.nextToken();
            return new MySqlShowAuthorsStatement();
        }
        if (this.lexer.token() == Token.BINARY) {
            this.lexer.nextToken();
            this.acceptIdentifier("LOGS");
            return new MySqlShowBinaryLogsStatement();
        }
        if (this.lexer.identifierEquals("MASTER")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("LOGS")) {
                this.lexer.nextToken();
                return new MySqlShowMasterLogsStatement();
            }
            this.acceptIdentifier(STATUS);
            return new MySqlShowMasterStatusStatement();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            MySqlShowCharacterSetStatement stmt = new MySqlShowCharacterSetStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setPattern(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("COLLATION")) {
            this.lexer.nextToken();
            MySqlShowCollationStatement stmt = new MySqlShowCollationStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setPattern(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(BINLOG)) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowBinLogEventsStatement stmt = new MySqlShowBinLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setIn(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.expr());
            }
            stmt.setLimit(this.exprParser.parseLimit());
            return stmt;
        }
        if (this.lexer.identifierEquals("CONTRIBUTORS")) {
            this.lexer.nextToken();
            return new MySqlShowContributorsStatement();
        }
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DATABASE) {
                this.lexer.nextToken();
                MySqlShowCreateDatabaseStatement stmt = new MySqlShowCreateDatabaseStatement();
                stmt.setDatabase(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.identifierEquals("EVENT")) {
                this.lexer.nextToken();
                MySqlShowCreateEventStatement stmt = new MySqlShowCreateEventStatement();
                stmt.setEventName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                MySqlShowCreateFunctionStatement stmt = new MySqlShowCreateFunctionStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.nextToken();
                MySqlShowCreateProcedureStatement stmt = new MySqlShowCreateProcedureStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                MySqlShowCreateTableStatement stmt = new MySqlShowCreateTableStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.nextToken();
                MySqlShowCreateViewStatement stmt = new MySqlShowCreateViewStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.TRIGGER) {
                this.lexer.nextToken();
                MySqlShowCreateTriggerStatement stmt = new MySqlShowCreateTriggerStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(ENGINE)) {
            this.lexer.nextToken();
            MySqlShowEngineStatement stmt = new MySqlShowEngineStatement();
            stmt.setName(this.exprParser.name());
            stmt.setOption(MySqlShowEngineStatement.Option.valueOf(this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            return stmt;
        }
        if (this.lexer.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            this.acceptIdentifier(ENGINES);
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            stmt.setStorage(true);
            return stmt;
        }
        if (this.lexer.identifierEquals(ENGINES)) {
            this.lexer.nextToken();
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals(EVENTS)) {
            this.lexer.nextToken();
            MySqlShowEventsStatement stmt = new MySqlShowEventsStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setSchema(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.token() == Token.FUNCTION) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CODE")) {
                this.lexer.nextToken();
                MySqlShowFunctionCodeStatement stmt = new MySqlShowFunctionCodeStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            this.acceptIdentifier(STATUS);
            MySqlShowFunctionStatusStatement stmt = new MySqlShowFunctionStatusStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(ENGINE)) {
            this.lexer.nextToken();
            MySqlShowEngineStatement stmt = new MySqlShowEngineStatement();
            stmt.setName(this.exprParser.name());
            stmt.setOption(MySqlShowEngineStatement.Option.valueOf(this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            return stmt;
        }
        if (this.lexer.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            this.accept(Token.DEFAULT);
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            stmt.setStorage(true);
            return stmt;
        }
        if (this.lexer.identifierEquals(ENGINES)) {
            this.lexer.nextToken();
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("GRANTS")) {
            this.lexer.nextToken();
            MySqlShowGrantsStatement stmt = new MySqlShowGrantsStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.token() == Token.INDEX || this.lexer.identifierEquals("INDEXES")) {
            this.lexer.nextToken();
            MySqlShowIndexesStatement stmt = new MySqlShowIndexesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    stmt.setDatabase(database);
                }
            }
            if (this.lexer.token() == Token.HINT) {
                stmt.setHints(this.exprParser.parseHints());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("KEYS")) {
            this.lexer.nextToken();
            MySqlShowKeysStatement stmt = new MySqlShowKeysStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    stmt.setDatabase(database);
                }
            }
            return stmt;
        }
        if (this.lexer.token() == Token.OPEN || this.lexer.identifierEquals("OPEN")) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            MySqlShowOpenTablesStatement stmt = new MySqlShowOpenTablesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("PLUGINS")) {
            this.lexer.nextToken();
            MySqlShowPluginsStatement stmt = new MySqlShowPluginsStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("PRIVILEGES")) {
            this.lexer.nextToken();
            MySqlShowPrivilegesStatement stmt = new MySqlShowPrivilegesStatement();
            return stmt;
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CODE")) {
                this.lexer.nextToken();
                MySqlShowProcedureCodeStatement stmt = new MySqlShowProcedureCodeStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            this.acceptIdentifier(STATUS);
            MySqlShowProcedureStatusStatement stmt = new MySqlShowProcedureStatusStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("PROCESSLIST")) {
            this.lexer.nextToken();
            MySqlShowProcessListStatement stmt = new MySqlShowProcessListStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("PROFILES")) {
            this.lexer.nextToken();
            MySqlShowProfilesStatement stmt = new MySqlShowProfilesStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("PROFILE")) {
            this.lexer.nextToken();
            MySqlShowProfileStatement stmt = new MySqlShowProfileStatement();
            while (true) {
                if (this.lexer.token() == Token.ALL) {
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.ALL);
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals("BLOCK")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("IO");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.BLOCK_IO);
                } else if (this.lexer.identifierEquals("CONTEXT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("SWITCHES");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.CONTEXT_SWITCHES);
                } else if (this.lexer.identifierEquals("CPU")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.CPU);
                } else if (this.lexer.identifierEquals("IPC")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.IPC);
                } else if (this.lexer.identifierEquals("MEMORY")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.MEMORY);
                } else if (this.lexer.identifierEquals("PAGE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("FAULTS");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.PAGE_FAULTS);
                } else if (this.lexer.identifierEquals("SOURCE")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.SOURCE);
                } else {
                    if (!this.lexer.identifierEquals("SWAPS")) break;
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.SWAPS);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.acceptIdentifier("QUERY");
                stmt.setForQuery(this.exprParser.primary());
            }
            stmt.setLimit(this.exprParser.parseLimit());
            return stmt;
        }
        if (this.lexer.identifierEquals("RELAYLOG")) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowRelayLogEventsStatement stmt = new MySqlShowRelayLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setLogName(this.exprParser.primary());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.primary());
            }
            stmt.setLimit(this.exprParser.parseLimit());
            return stmt;
        }
        if (this.lexer.identifierEquals("RELAYLOG")) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowRelayLogEventsStatement stmt = new MySqlShowRelayLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setLogName(this.exprParser.primary());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.primary());
            }
            stmt.setLimit(this.exprParser.parseLimit());
            return stmt;
        }
        if (this.lexer.identifierEquals("SLAVE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                return new MySqlShowSlaveStatusStatement();
            }
            this.acceptIdentifier("HOSTS");
            MySqlShowSlaveHostsStatement stmt = new MySqlShowSlaveHostsStatement();
            return stmt;
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier(STATUS);
            MySqlShowTableStatusStatement stmt = new MySqlShowTableStatusStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.token() == Token.DATABASE) {
            this.lexer.nextToken();
            this.accept(Token.PARTITION);
            this.acceptIdentifier(STATUS);
            this.accept(Token.FOR);
            MySqlShowDatabasePartitionStatusStatement stmt = new MySqlShowDatabasePartitionStatusStatement();
            stmt.setDatabase(this.exprParser.name());
            return stmt;
        }
        if (this.lexer.identifierEquals("TRIGGERS")) {
            this.lexer.nextToken();
            MySqlShowTriggersStatement stmt = new MySqlShowTriggersStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                SQLExpr like = this.exprParser.expr();
                stmt.setLike(like);
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                SQLExpr where = this.exprParser.expr();
                stmt.setWhere(where);
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    private MySqlShowStatusStatement parseShowStatus() {
        MySqlShowStatusStatement stmt = new MySqlShowStatusStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowVariantsStatement parseShowVariants() {
        MySqlShowVariantsStatement stmt = new MySqlShowVariantsStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowWarningsStatement parseShowWarnings() {
        MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
        stmt.setLimit(this.exprParser.parseLimit());
        return stmt;
    }

    private MySqlShowDatabasesStatement parseShowDatabases() {
        MySqlShowDatabasesStatement stmt = new MySqlShowDatabasesStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private SQLShowTablesStatement parseShowTabless() {
        SQLShowTablesStatement stmt = new SQLShowTablesStatement();
        if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            SQLName database = this.exprParser.name();
            if (this.lexer.token() == Token.SUB && database instanceof SQLIdentifierExpr) {
                this.lexer.mark();
                this.lexer.nextToken();
                String strVal = this.lexer.stringVal();
                this.lexer.nextToken();
                if (database instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr ident = (SQLIdentifierExpr)database;
                    database = new SQLIdentifierExpr(ident.getName() + "-" + strVal);
                }
            }
            stmt.setDatabase(database);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowColumnsStatement parseShowColumns() {
        MySqlShowColumnsStatement stmt = new MySqlShowColumnsStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    public SQLStartTransactionStatement parseStart() {
        this.acceptIdentifier("START");
        this.acceptIdentifier("TRANSACTION");
        SQLStartTransactionStatement stmt = new SQLStartTransactionStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("CONSISTENT");
            this.acceptIdentifier("SNAPSHOT");
            stmt.setConsistentSnapshot(true);
        }
        if (this.lexer.token() == Token.BEGIN) {
            this.lexer.nextToken();
            stmt.setBegin(true);
            if (this.lexer.identifierEquals("WORK")) {
                this.lexer.nextToken();
                stmt.setWork(true);
            }
        }
        if (this.lexer.token() == Token.HINT) {
            stmt.setHints(this.exprParser.parseHints());
        }
        return stmt;
    }

    @Override
    public SQLRollbackStatement parseRollback() {
        this.acceptIdentifier("ROLLBACK");
        SQLRollbackStatement stmt = new SQLRollbackStatement();
        if (this.lexer.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.TRUE);
            }
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SAVEPOINT")) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCommit() {
        this.acceptIdentifier("COMMIT");
        SQLCommitStatement stmt = new SQLCommitStatement();
        if (this.lexer.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.TRUE);
            }
        }
        return stmt;
    }

    public SQLReplaceStatement parseReplace() {
        SQLQueryExpr queryExpr;
        SQLReplaceStatement stmt = new SQLReplaceStatement();
        this.accept(Token.REPLACE);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DELAYED)) {
            stmt.setDelayed(true);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                queryExpr = (SQLQueryExpr)this.exprParser.expr();
                stmt.setQuery(queryExpr);
            } else {
                this.exprParser.exprList(stmt.getColumns(), stmt);
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.lexer.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            this.parseValueClause(stmt.getValuesList(), 0, stmt);
        } else if (this.lexer.token() == Token.SELECT) {
            queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            values.setParent(stmt);
            stmt.getValuesList().add(values);
            while (true) {
                stmt.addColumn(this.exprParser.name());
                if (this.lexer.token() == Token.COLONEQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.EQ);
                }
                values.addValue(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.LPAREN) {
            SQLSelect select = this.createSQLSelectParser().select();
            SQLQueryExpr queryExpr2 = new SQLQueryExpr(select);
            stmt.setQuery(queryExpr2);
        }
        return stmt;
    }

    protected SQLStatement parseLoad() {
        this.acceptIdentifier("LOAD");
        if (this.lexer.identifierEquals("DATA")) {
            MySqlLoadDataInFileStatement stmt = this.parseLoadDataInFile();
            return stmt;
        }
        if (this.lexer.identifierEquals("XML")) {
            MySqlLoadXmlStatement stmt = this.parseLoadXml();
            return stmt;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }

    protected MySqlLoadXmlStatement parseLoadXml() {
        this.acceptIdentifier("XML");
        MySqlLoadXmlStatement stmt = new MySqlLoadXmlStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(LOCAL)) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.lexer.token() == Token.REPLACE) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset. " + this.lexer.info());
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.lexer.identifierEquals("ROWS")) {
            this.lexer.nextToken();
            this.accept(Token.IDENTIFIED);
            this.accept(Token.BY);
            SQLExpr rowsIdentifiedBy = this.exprParser.expr();
            stmt.setRowsIdentifiedBy(rowsIdentifiedBy);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        if (this.lexer.token() == Token.SET) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        return stmt;
    }

    protected MySqlLoadDataInFileStatement parseLoadDataInFile() {
        this.acceptIdentifier("DATA");
        MySqlLoadDataInFileStatement stmt = new MySqlLoadDataInFileStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(LOCAL)) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.lexer.token() == Token.REPLACE) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset. " + this.lexer.info());
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.lexer.identifierEquals("FIELDS") || this.lexer.identifierEquals("COLUMNS")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("TERMINATED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setColumnsTerminatedBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals("OPTIONALLY")) {
                stmt.setColumnsEnclosedOptionally(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals("ENCLOSED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setColumnsEnclosedBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals("ESCAPED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setColumnsEscaped(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals("LINES")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STARTING")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setLinesStartingBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals("TERMINATED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setLinesTerminatedBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            this.lexer.nextToken();
            stmt.setIgnoreLinesNumber(this.exprParser.expr());
            this.acceptIdentifier("LINES");
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getSetList(), stmt);
        }
        return stmt;
    }

    public MySqlPrepareStatement parsePrepare() {
        this.acceptIdentifier("PREPARE");
        SQLName name = this.exprParser.name();
        this.accept(Token.FROM);
        SQLExpr from = this.exprParser.expr();
        return new MySqlPrepareStatement(name, from);
    }

    public MySqlExecuteStatement parseExecute() {
        this.acceptIdentifier("EXECUTE");
        MySqlExecuteStatement stmt = new MySqlExecuteStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        if (this.lexer.identifierEquals("USING")) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            this.exprParser.exprList(stmt.getParameters(), stmt);
        }
        return stmt;
    }

    public MysqlDeallocatePrepareStatement parseDeallocatePrepare() {
        this.acceptIdentifier("DEALLOCATE");
        this.acceptIdentifier("PREPARE");
        MysqlDeallocatePrepareStatement stmt = new MysqlDeallocatePrepareStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        return stmt;
    }

    @Override
    public SQLInsertStatement parseInsert() {
        SQLName name;
        MySqlInsertStatement stmt = new MySqlInsertStatement();
        SQLName tableName = null;
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            while (this.lexer.token() == Token.IDENTIFIER) {
                long hash = this.lexer.hash_lower();
                if (hash == FnvHash.Constants.LOW_PRIORITY) {
                    stmt.setLowPriority(true);
                    this.lexer.nextToken();
                    continue;
                }
                if (hash == FnvHash.Constants.DELAYED) {
                    stmt.setDelayed(true);
                    this.lexer.nextToken();
                    continue;
                }
                if (hash == FnvHash.Constants.HIGH_PRIORITY) {
                    stmt.setHighPriority(true);
                    this.lexer.nextToken();
                    continue;
                }
                if (hash == FnvHash.Constants.IGNORE) {
                    stmt.setIgnore(true);
                    this.lexer.nextToken();
                    continue;
                }
                if (hash != FnvHash.Constants.ROLLBACK_ON_FAIL) break;
                stmt.setRollbackOnFail(true);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.LINE_COMMENT) {
                this.lexer.nextToken();
            }
            tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.HINT) {
                String comment = "/*" + this.lexer.stringVal() + "*/";
                this.lexer.nextToken();
                stmt.getTableSource().addAfterComment(comment);
            }
            if (this.lexer.token() == Token.IDENTIFIER && !this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        int columnSize = 0;
        if (this.lexer.token() == Token.LPAREN) {
            boolean useInsertColumnsCache = this.lexer.isEnabled(SQLParserFeature.UseInsertColumnsCache);
            InsertColumnsCache insertColumnsCache = null;
            InsertColumnsCache.Entry cachedColumns = null;
            if (useInsertColumnsCache) {
                insertColumnsCache = this.insertColumnsCache;
                if (insertColumnsCache == null) {
                    insertColumnsCache = InsertColumnsCache.global;
                }
                if (tableName != null) {
                    cachedColumns = insertColumnsCache.get(tableName.hashCode64());
                }
            }
            int pos = this.lexer.pos();
            if (cachedColumns != null && this.lexer.text.startsWith(cachedColumns.columnsString, pos)) {
                if (!this.lexer.isEnabled(SQLParserFeature.OptimizedForParameterized)) {
                    List<SQLExpr> columns = stmt.getColumns();
                    List<SQLExpr> cachedColumns2 = cachedColumns.columns;
                    int size = cachedColumns2.size();
                    for (int i = 0; i < size; ++i) {
                        columns.add(cachedColumns2.get(i).clone());
                    }
                }
                stmt.setColumnsString(cachedColumns.columnsFormattedString, cachedColumns.columnsFormattedStringHash);
                int p2 = pos + cachedColumns.columnsString.length();
                this.lexer.reset(p2);
                this.lexer.nextToken();
            } else {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.SELECT) {
                    SQLSelect select = this.exprParser.createSelectParser().select();
                    select.setParent(stmt);
                    stmt.setQuery(select);
                } else {
                    List<SQLExpr> columns = stmt.getColumns();
                    if (this.lexer.token() != Token.RPAREN) {
                        while (true) {
                            long hash;
                            String identName;
                            Token token;
                            if ((token = this.lexer.token()) == Token.IDENTIFIER) {
                                identName = this.lexer.stringVal();
                                hash = this.lexer.hash_lower();
                            } else if (token == Token.LITERAL_CHARS) {
                                identName = '\'' + this.lexer.stringVal() + '\'';
                                hash = 0L;
                            } else {
                                identName = this.lexer.stringVal();
                                hash = 0L;
                            }
                            this.lexer.nextTokenComma();
                            SQLExprImpl expr = new SQLIdentifierExpr(identName, hash);
                            while (this.lexer.token() == Token.DOT) {
                                this.lexer.nextToken();
                                String propertyName = this.lexer.stringVal();
                                this.lexer.nextToken();
                                expr = new SQLPropertyExpr(expr, propertyName);
                            }
                            expr.setParent(stmt);
                            columns.add(expr);
                            ++columnSize;
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextTokenIdent();
                        }
                        columnSize = stmt.getColumns().size();
                        if (insertColumnsCache != null && tableName != null) {
                            String columnsString = this.lexer.subString(pos, this.lexer.pos() - pos);
                            ArrayList<SQLExpr> clonedColumns = new ArrayList<SQLExpr>(columnSize);
                            for (int i = 0; i < columns.size(); ++i) {
                                clonedColumns.add(columns.get(i).clone());
                            }
                            StringBuilder buf = new StringBuilder();
                            SQLASTOutputVisitor outputVisitor = SQLUtils.createOutputVisitor(buf, this.dbType);
                            outputVisitor.printInsertColumns(columns);
                            String formattedColumnsString = buf.toString();
                            long columnsFormattedStringHash = FnvHash.fnv1a_64_lower(formattedColumnsString);
                            insertColumnsCache.put(tableName.hashCode64(), columnsString, formattedColumnsString, clonedColumns);
                            stmt.setColumnsString(formattedColumnsString, columnsFormattedStringHash);
                        }
                    }
                }
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.LINE_COMMENT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.VALUES || this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            this.lexer.nextTokenLParen();
            this.parseValueClause(stmt.getValuesList(), columnSize, stmt);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            stmt.addValueCause(values);
            while (true) {
                name = this.exprParser.name();
                stmt.addColumn(name);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.COLONEQ);
                }
                values.addValue(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLSelect select = this.exprParser.createSelectParser().select();
            select.setParent(stmt);
            stmt.setQuery(select);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelect select = this.exprParser.createSelectParser().select();
            select.setParent(stmt);
            stmt.setQuery(select);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("DUPLICATE");
            this.accept(Token.KEY);
            this.accept(Token.UPDATE);
            List<SQLExpr> duplicateKeyUpdate = stmt.getDuplicateKeyUpdate();
            while (true) {
                SQLExpr value;
                name = this.exprParser.name();
                this.accept(Token.EQ);
                try {
                    value = this.exprParser.expr();
                }
                catch (EOFParserException e) {
                    throw new ParserException("EOF, " + name + "=", e);
                }
                SQLBinaryOpExpr assignment = new SQLBinaryOpExpr((SQLExpr)name, SQLBinaryOperator.Equality, value);
                assignment.setParent(stmt);
                duplicateKeyUpdate.add(assignment);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextTokenIdent();
            }
        }
        return stmt;
    }

    @Override
    public MySqlSelectParser createSQLSelectParser() {
        return new MySqlSelectParser(this.exprParser, this.selectListCache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLStatement parseSet() {
        SQLVariantRefExpr varRef;
        this.accept(Token.SET);
        if (this.lexer.identifierEquals(FnvHash.Constants.PASSWORD)) {
            this.lexer.nextToken();
            SQLSetStatement stmt = new SQLSetStatement();
            stmt.setDbType(this.dbType);
            stmt.setOption(SQLSetStatement.Option.PASSWORD);
            SQLName user = null;
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                user = this.exprParser.name();
            }
            this.accept(Token.EQ);
            SQLExpr password = this.exprParser.expr();
            stmt.set(user, password);
            return stmt;
        }
        Boolean global = null;
        Boolean session = null;
        if (this.lexer.identifierEquals(GLOBAL)) {
            global = Boolean.TRUE;
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(SESSION)) {
            global = Boolean.FALSE;
            session = Boolean.TRUE;
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("TRANSACTION")) {
            MySqlSetTransactionStatement stmt = new MySqlSetTransactionStatement();
            stmt.setGlobal(global);
            stmt.setSession(session);
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("ISOLATION")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LEVEL");
                if (this.lexer.identifierEquals(READ)) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("UNCOMMITTED")) {
                        stmt.setIsolationLevel("READ UNCOMMITTED");
                        this.lexer.nextToken();
                        return stmt;
                    } else if (this.lexer.identifierEquals(WRITE)) {
                        stmt.setIsolationLevel("READ WRITE");
                        this.lexer.nextToken();
                        return stmt;
                    } else if (this.lexer.identifierEquals("ONLY")) {
                        stmt.setIsolationLevel("READ ONLY");
                        this.lexer.nextToken();
                        return stmt;
                    } else {
                        if (!this.lexer.identifierEquals("COMMITTED")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal() + ", " + this.lexer.info());
                        stmt.setIsolationLevel("READ COMMITTED");
                        this.lexer.nextToken();
                    }
                    return stmt;
                } else if (this.lexer.identifierEquals("SERIALIZABLE")) {
                    stmt.setIsolationLevel("SERIALIZABLE");
                    this.lexer.nextToken();
                    return stmt;
                } else {
                    if (!this.lexer.identifierEquals("REPEATABLE")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal() + ", " + this.lexer.info());
                    this.lexer.nextToken();
                    if (!this.lexer.identifierEquals(READ)) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal() + ", " + this.lexer.info());
                    stmt.setIsolationLevel("REPEATABLE READ");
                    this.lexer.nextToken();
                }
                return stmt;
            } else {
                if (!this.lexer.identifierEquals(READ)) return stmt;
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("ONLY")) {
                    stmt.setAccessModel("ONLY");
                    this.lexer.nextToken();
                    return stmt;
                } else {
                    if (!this.lexer.identifierEquals(WRITE)) throw new ParserException("UNKOWN ACCESS MODEL : " + this.lexer.stringVal() + ", " + this.lexer.info());
                    stmt.setAccessModel(WRITE);
                    this.lexer.nextToken();
                }
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        if (global != null && global.booleanValue()) {
            varRef = (SQLVariantRefExpr)stmt.getItems().get(0).getTarget();
            varRef.setGlobal(true);
        }
        if (session != null && session.booleanValue()) {
            varRef = (SQLVariantRefExpr)stmt.getItems().get(0).getTarget();
            varRef.setSession(true);
        }
        if (this.lexer.token() != Token.HINT) return stmt;
        stmt.setHints(this.exprParser.parseHints());
        return stmt;
    }

    @Override
    public SQLStatement parseAlter() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.USER) {
            return this.parseAlterUser();
        }
        boolean ignore = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            ignore = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.TABLE) {
            return this.parseAlterTable(ignore);
        }
        if (this.lexer.token() == Token.DATABASE || this.lexer.token() == Token.SCHEMA) {
            return this.parseAlterDatabase();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EVENT)) {
            return this.parseAlterEvent();
        }
        if (this.lexer.token() == Token.FUNCTION) {
            return this.parseAlterFunction();
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            return this.parseAlterProcedure();
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            return this.parseAlterTableSpace();
        }
        if (this.lexer.token() == Token.VIEW) {
            return this.parseAlterView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOGFILE)) {
            return this.parseAlterLogFileGroup();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SERVER)) {
            return this.parseAlterServer();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
            return this.parseAlterView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            this.accept(Token.EQ);
            this.getExprParser().userName();
            if (this.lexer.identifierEquals(FnvHash.Constants.EVENT)) {
                this.lexer.reset(savePoint);
                return this.parseAlterEvent();
            }
            this.lexer.reset(savePoint);
            return this.parseAlterView();
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLStatement parseAlterView() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        SQLAlterViewStatement createView = new SQLAlterViewStatement(this.getDbType());
        if (this.lexer.identifierEquals("ALGORITHM")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            String algorithm = this.lexer.stringVal();
            createView.setAlgorithm(algorithm);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("DEFINER")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = (SQLName)this.exprParser.expr();
            createView.setDefiner(definer);
        }
        if (this.lexer.identifierEquals("SQL")) {
            this.lexer.nextToken();
            this.acceptIdentifier("SECURITY");
            String sqlSecurity = this.lexer.stringVal();
            createView.setSqlSecurity(sqlSecurity);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("FORCE")) {
            this.lexer.nextToken();
            createView.setForce(true);
        }
        this.accept(Token.VIEW);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createView.setIfNotExists(true);
        }
        createView.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token() == Token.CONSTRAINT) {
                    SQLTableConstraint constraint = (SQLTableConstraint)this.exprParser.parseConstaint();
                    createView.addColumn(constraint);
                } else {
                    SQLColumnDefinition column = new SQLColumnDefinition();
                    column.setDbType(this.dbType);
                    SQLName expr = this.exprParser.name();
                    column.setName(expr);
                    this.exprParser.parseColumnRest(column);
                    if (this.lexer.token() == Token.COMMENT) {
                        SQLExpr comment;
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.LITERAL_ALIAS) {
                            String alias = this.lexer.stringVal();
                            if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                                alias = alias.substring(1, alias.length() - 1);
                            }
                            comment = new SQLCharExpr(alias);
                            this.lexer.nextToken();
                        } else {
                            comment = this.exprParser.primary();
                        }
                        column.setComment(comment);
                    }
                    column.setParent(createView);
                    createView.addColumn(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLCharExpr comment = (SQLCharExpr)this.exprParser.primary();
            createView.setComment(comment);
        }
        this.accept(Token.AS);
        MySqlSelectParser selectParser = this.createSQLSelectParser();
        createView.setSubQuery(selectParser.select());
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CASCADED")) {
                createView.setWithCascaded(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(LOCAL)) {
                createView.setWithLocal(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(READ)) {
                this.lexer.nextToken();
                this.accept(Token.ONLY);
                createView.setWithReadOnly(true);
            }
            if (this.lexer.token() == Token.CHECK) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                createView.setWithCheckOption(true);
            }
        }
        return createView;
    }

    protected SQLStatement parseAlterTableSpace() {
        SQLExpr file;
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.accept(Token.TABLESPACE);
        SQLName name = this.exprParser.name();
        MySqlAlterTablespaceStatement stmt = new MySqlAlterTablespaceStatement();
        stmt.setName(name);
        if (this.lexer.identifierEquals(FnvHash.Constants.ADD)) {
            this.lexer.nextToken();
            this.acceptIdentifier("DATAFILE");
            file = this.exprParser.primary();
            stmt.setAddDataFile(file);
        } else if (this.lexer.token() == Token.DROP) {
            this.lexer.nextToken();
            this.acceptIdentifier("DATAFILE");
            file = this.exprParser.primary();
            stmt.setDropDataFile(file);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.INITIAL_SIZE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr initialSize = this.exprParser.expr();
            stmt.setInitialSize(initialSize);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
            this.lexer.nextToken();
            stmt.setWait(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr engine = this.exprParser.expr();
            stmt.setEngine(engine);
        }
        return stmt;
    }

    protected SQLStatement parseAlterServer() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("SERVER");
        SQLName name = this.exprParser.name();
        MySqlAlterServerStatement stmt = new MySqlAlterServerStatement();
        stmt.setName(name);
        this.acceptIdentifier("OPTIONS");
        this.accept(Token.LPAREN);
        if (this.lexer.token() == Token.USER) {
            this.lexer.nextToken();
            SQLName user = this.exprParser.name();
            stmt.setUser(user);
        }
        this.accept(Token.RPAREN);
        return stmt;
    }

    protected SQLStatement parseCreateLogFileGroup() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("LOGFILE");
        this.accept(Token.GROUP);
        SQLName name = this.exprParser.name();
        MySqlCreateAddLogFileGroupStatement stmt = new MySqlCreateAddLogFileGroupStatement();
        stmt.setName(name);
        this.acceptIdentifier("ADD");
        this.acceptIdentifier("UNDOFILE");
        SQLExpr fileName = this.exprParser.primary();
        stmt.setAddUndoFile(fileName);
        if (this.lexer.identifierEquals(FnvHash.Constants.INITIAL_SIZE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr initialSize = this.exprParser.expr();
            stmt.setInitialSize(initialSize);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
            this.lexer.nextToken();
            stmt.setWait(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr engine = this.exprParser.expr();
            stmt.setEngine(engine);
        }
        return stmt;
    }

    protected SQLStatement parseAlterLogFileGroup() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("LOGFILE");
        this.accept(Token.GROUP);
        SQLName name = this.exprParser.name();
        MySqlAlterLogFileGroupStatement stmt = new MySqlAlterLogFileGroupStatement();
        stmt.setName(name);
        this.acceptIdentifier("ADD");
        this.acceptIdentifier("UNDOFILE");
        SQLExpr fileName = this.exprParser.primary();
        stmt.setAddUndoFile(fileName);
        if (this.lexer.identifierEquals(FnvHash.Constants.INITIAL_SIZE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr initialSize = this.exprParser.expr();
            stmt.setInitialSize(initialSize);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
            this.lexer.nextToken();
            stmt.setWait(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr engine = this.exprParser.expr();
            stmt.setEngine(engine);
        }
        return stmt;
    }

    protected SQLStatement parseAlterProcedure() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.accept(Token.PROCEDURE);
        SQLAlterProcedureStatement stmt = new SQLAlterProcedureStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        while (true) {
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLExpr comment = this.exprParser.primary();
                stmt.setComment(comment);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LANGUAGE)) {
                this.lexer.nextToken();
                this.acceptIdentifier("SQL");
                stmt.setLanguageSql(true);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
                this.lexer.nextToken();
                this.acceptIdentifier("SECURITY");
                SQLName sqlSecurity = this.exprParser.name();
                stmt.setSqlSecurity(sqlSecurity);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.CONTAINS) && this.lexer.token() != Token.CONTAINS) break;
            this.lexer.nextToken();
            this.acceptIdentifier("SQL");
            stmt.setContainsSql(true);
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterFunction() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.accept(Token.FUNCTION);
        SQLAlterFunctionStatement stmt = new SQLAlterFunctionStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        while (true) {
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLExpr comment = this.exprParser.primary();
                stmt.setComment(comment);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LANGUAGE)) {
                this.lexer.nextToken();
                this.acceptIdentifier("SQL");
                stmt.setLanguageSql(true);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
                this.lexer.nextToken();
                this.acceptIdentifier("SECURITY");
                SQLName sqlSecurity = this.exprParser.name();
                stmt.setSqlSecurity(sqlSecurity);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.CONTAINS) && this.lexer.token() != Token.CONTAINS) break;
            this.lexer.nextToken();
            this.acceptIdentifier("SQL");
            stmt.setContainsSql(true);
        }
        return stmt;
    }

    protected SQLStatement parseCreateEvent() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        MySqlCreateEventStatement stmt = new MySqlCreateEventStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = this.getExprParser().userName();
            stmt.setDefiner(definer);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.accept(Token.RPAREN);
            }
        }
        this.acceptIdentifier("EVENT");
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        SQLName eventName = this.exprParser.name();
        stmt.setName(eventName);
        while (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.SCHEDULE)) {
                this.lexer.nextToken();
                MySqlEventSchedule schedule = this.parseSchedule();
                stmt.setSchedule(schedule);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COMPLETION)) {
                boolean value;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    value = false;
                } else {
                    value = true;
                }
                this.acceptIdentifier("PRESERVE");
                stmt.setOnCompletionPreserve(value);
                continue;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            SQLName renameTo = this.exprParser.name();
            stmt.setRenameTo(renameTo);
        }
        if (this.lexer.token() == Token.ENABLE) {
            stmt.setEnable(true);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISABLE) {
            this.lexer.nextToken();
            stmt.setEnable(false);
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("SLAVE");
                stmt.setDisableOnSlave(true);
            }
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLExpr comment = this.exprParser.primary();
            stmt.setComment(comment);
        }
        if (this.lexer.token() == Token.DO) {
            this.lexer.nextToken();
            SQLStatement eventBody = this.parseStatement();
            stmt.setEventBody(eventBody);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            SQLExpr expr = this.exprParser.expr();
            SQLExprStatement eventBody = new SQLExprStatement(expr);
            eventBody.setDbType(this.dbType);
            stmt.setEventBody(eventBody);
        }
        return stmt;
    }

    protected SQLStatement parseAlterEvent() {
        if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
        }
        MySqlAlterEventStatement stmt = new MySqlAlterEventStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = this.getExprParser().userName();
            stmt.setDefiner(definer);
        }
        this.acceptIdentifier("EVENT");
        SQLName eventName = this.exprParser.name();
        stmt.setName(eventName);
        while (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.SCHEDULE)) {
                this.lexer.nextToken();
                MySqlEventSchedule schedule = this.parseSchedule();
                stmt.setSchedule(schedule);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COMPLETION)) {
                boolean value;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    value = false;
                } else {
                    value = true;
                }
                this.acceptIdentifier("PRESERVE");
                stmt.setOnCompletionPreserve(value);
                continue;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            SQLName renameTo = this.exprParser.name();
            stmt.setRenameTo(renameTo);
        }
        if (this.lexer.token() == Token.ENABLE) {
            stmt.setEnable(true);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISABLE) {
            this.lexer.nextToken();
            stmt.setEnable(false);
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("SLAVE");
                stmt.setDisableOnSlave(true);
            }
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLExpr comment = this.exprParser.primary();
            stmt.setComment(comment);
        }
        if (this.lexer.token() == Token.DO) {
            this.lexer.nextToken();
            SQLStatement eventBody = this.parseStatement();
            stmt.setEventBody(eventBody);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            SQLExpr expr = this.exprParser.expr();
            SQLExprStatement eventBody = new SQLExprStatement(expr);
            eventBody.setDbType(this.dbType);
            stmt.setEventBody(eventBody);
        }
        return stmt;
    }

    private MySqlEventSchedule parseSchedule() {
        MySqlEventSchedule schedule = new MySqlEventSchedule();
        if (this.lexer.identifierEquals(FnvHash.Constants.AT)) {
            this.lexer.nextToken();
            schedule.setAt(this.exprParser.expr());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.EVERY)) {
            this.lexer.nextToken();
            SQLExpr value = this.exprParser.expr();
            String unit = this.lexer.stringVal();
            this.lexer.nextToken();
            SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
            intervalExpr.setValue(value);
            intervalExpr.setUnit(SQLIntervalUnit.valueOf(unit.toUpperCase()));
            schedule.setEvery(intervalExpr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STARTS)) {
            this.lexer.nextToken();
            schedule.setStarts(this.exprParser.expr());
            if (this.lexer.identifierEquals(FnvHash.Constants.ENDS)) {
                this.lexer.nextToken();
                schedule.setEnds(this.exprParser.expr());
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ENDS)) {
            this.lexer.nextToken();
            schedule.setEnds(this.exprParser.expr());
        }
        return schedule;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected SQLStatement parseAlterTable(boolean ignore) {
        this.lexer.nextToken();
        SQLAlterTableStatement stmt = new SQLAlterTableStatement(this.getDbType());
        stmt.setIgnore(ignore);
        stmt.setName(this.exprParser.name());
        while (true) {
            block74: {
                boolean paren;
                block91: {
                    block114: {
                        block113: {
                            block112: {
                                block111: {
                                    block110: {
                                        block109: {
                                            block108: {
                                                block107: {
                                                    block106: {
                                                        block105: {
                                                            block104: {
                                                                block103: {
                                                                    block102: {
                                                                        block101: {
                                                                            block100: {
                                                                                block99: {
                                                                                    block98: {
                                                                                        block97: {
                                                                                            block96: {
                                                                                                block95: {
                                                                                                    block94: {
                                                                                                        SQLObjectImpl item;
                                                                                                        block93: {
                                                                                                            block92: {
                                                                                                                block90: {
                                                                                                                    block89: {
                                                                                                                        block88: {
                                                                                                                            block77: {
                                                                                                                                block84: {
                                                                                                                                    block87: {
                                                                                                                                        block86: {
                                                                                                                                            block85: {
                                                                                                                                                block83: {
                                                                                                                                                    block82: {
                                                                                                                                                        block81: {
                                                                                                                                                            block80: {
                                                                                                                                                                block79: {
                                                                                                                                                                    block78: {
                                                                                                                                                                        block76: {
                                                                                                                                                                            block75: {
                                                                                                                                                                                if (this.lexer.token() != Token.DROP) break block75;
                                                                                                                                                                                this.parseAlterDrop(stmt);
                                                                                                                                                                                break block74;
                                                                                                                                                                            }
                                                                                                                                                                            if (this.lexer.token() != Token.TRUNCATE) break block76;
                                                                                                                                                                            this.lexer.nextToken();
                                                                                                                                                                            this.accept(Token.PARTITION);
                                                                                                                                                                            SQLAlterTableTruncatePartition item2 = new SQLAlterTableTruncatePartition();
                                                                                                                                                                            if (this.lexer.token() == Token.ALL) {
                                                                                                                                                                                item2.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                                                                                                                                                this.lexer.nextToken();
                                                                                                                                                                            } else {
                                                                                                                                                                                this.exprParser.names(item2.getPartitions(), item2);
                                                                                                                                                                            }
                                                                                                                                                                            stmt.addItem(item2);
                                                                                                                                                                            break block74;
                                                                                                                                                                        }
                                                                                                                                                                        if (!this.lexer.identifierEquals("ADD")) break block77;
                                                                                                                                                                        this.lexer.nextToken();
                                                                                                                                                                        if (this.lexer.token() != Token.COLUMN) break block78;
                                                                                                                                                                        this.lexer.nextToken();
                                                                                                                                                                        this.parseAlterTableAddColumn(stmt);
                                                                                                                                                                        break block74;
                                                                                                                                                                    }
                                                                                                                                                                    if (this.lexer.token() != Token.INDEX && this.lexer.token() != Token.FULLTEXT && !this.lexer.identifierEquals(FnvHash.Constants.SPATIAL)) break block79;
                                                                                                                                                                    SQLAlterTableAddIndex item3 = this.parseAlterTableAddIndex();
                                                                                                                                                                    item3.setParent(stmt);
                                                                                                                                                                    stmt.addItem(item3);
                                                                                                                                                                    break block74;
                                                                                                                                                                }
                                                                                                                                                                if (this.lexer.token() != Token.UNIQUE) break block80;
                                                                                                                                                                SQLAlterTableAddIndex item4 = this.parseAlterTableAddIndex();
                                                                                                                                                                item4.setParent(stmt);
                                                                                                                                                                stmt.addItem(item4);
                                                                                                                                                                break block74;
                                                                                                                                                            }
                                                                                                                                                            if (this.lexer.token() != Token.PRIMARY) break block81;
                                                                                                                                                            SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
                                                                                                                                                            SQLAlterTableAddConstraint sQLAlterTableAddConstraint = new SQLAlterTableAddConstraint(primaryKey);
                                                                                                                                                            stmt.addItem(sQLAlterTableAddConstraint);
                                                                                                                                                            break block74;
                                                                                                                                                        }
                                                                                                                                                        if (this.lexer.token() != Token.KEY) break block82;
                                                                                                                                                        SQLAlterTableAddIndex item5 = this.parseAlterTableAddIndex();
                                                                                                                                                        item5.setParent(stmt);
                                                                                                                                                        stmt.addItem(item5);
                                                                                                                                                        break block74;
                                                                                                                                                    }
                                                                                                                                                    if (this.lexer.token() != Token.FOREIGN) break block83;
                                                                                                                                                    MysqlForeignKey fk = this.getExprParser().parseForeignKey();
                                                                                                                                                    SQLAlterTableAddConstraint sQLAlterTableAddConstraint = new SQLAlterTableAddConstraint(fk);
                                                                                                                                                    stmt.addItem(sQLAlterTableAddConstraint);
                                                                                                                                                    break block74;
                                                                                                                                                }
                                                                                                                                                if (this.lexer.token() != Token.CONSTRAINT) break block84;
                                                                                                                                                this.lexer.nextToken();
                                                                                                                                                if (this.lexer.token() != Token.PRIMARY) break block85;
                                                                                                                                                MySqlPrimaryKey primaryKey = ((MySqlExprParser)this.exprParser).parsePrimaryKey();
                                                                                                                                                SQLAlterTableAddConstraint sQLAlterTableAddConstraint = new SQLAlterTableAddConstraint(primaryKey);
                                                                                                                                                sQLAlterTableAddConstraint.setParent(stmt);
                                                                                                                                                stmt.addItem(sQLAlterTableAddConstraint);
                                                                                                                                                break block74;
                                                                                                                                            }
                                                                                                                                            if (this.lexer.token() != Token.FOREIGN) break block86;
                                                                                                                                            MysqlForeignKey fk = this.getExprParser().parseForeignKey();
                                                                                                                                            fk.setHasConstraint(true);
                                                                                                                                            SQLAlterTableAddConstraint sQLAlterTableAddConstraint = new SQLAlterTableAddConstraint(fk);
                                                                                                                                            stmt.addItem(sQLAlterTableAddConstraint);
                                                                                                                                            break block74;
                                                                                                                                        }
                                                                                                                                        if (this.lexer.token() != Token.UNIQUE) break block87;
                                                                                                                                        SQLUnique unique = this.exprParser.parseUnique();
                                                                                                                                        SQLAlterTableAddConstraint sQLAlterTableAddConstraint = new SQLAlterTableAddConstraint(unique);
                                                                                                                                        stmt.addItem(sQLAlterTableAddConstraint);
                                                                                                                                        break block74;
                                                                                                                                    }
                                                                                                                                    SQLName constraintName = this.exprParser.name();
                                                                                                                                    if (this.lexer.token() == Token.PRIMARY) {
                                                                                                                                        MySqlPrimaryKey mySqlPrimaryKey = ((MySqlExprParser)this.exprParser).parsePrimaryKey();
                                                                                                                                        mySqlPrimaryKey.setName(constraintName);
                                                                                                                                        item = new SQLAlterTableAddConstraint(mySqlPrimaryKey);
                                                                                                                                        item.setParent(stmt);
                                                                                                                                        stmt.addItem((SQLAlterTableItem)((Object)item));
                                                                                                                                        break block74;
                                                                                                                                    } else if (this.lexer.token() == Token.FOREIGN) {
                                                                                                                                        MysqlForeignKey mysqlForeignKey = this.getExprParser().parseForeignKey();
                                                                                                                                        mysqlForeignKey.setName(constraintName);
                                                                                                                                        mysqlForeignKey.setHasConstraint(true);
                                                                                                                                        item = new SQLAlterTableAddConstraint(mysqlForeignKey);
                                                                                                                                        stmt.addItem((SQLAlterTableItem)((Object)item));
                                                                                                                                        break block74;
                                                                                                                                    } else {
                                                                                                                                        if (this.lexer.token() != Token.UNIQUE) {
                                                                                                                                            throw new ParserException("TODO " + this.lexer.info());
                                                                                                                                        }
                                                                                                                                        SQLUnique sQLUnique = this.exprParser.parseUnique();
                                                                                                                                        item = new SQLAlterTableAddConstraint(sQLUnique);
                                                                                                                                        stmt.addItem((SQLAlterTableItem)((Object)item));
                                                                                                                                    }
                                                                                                                                    break block74;
                                                                                                                                }
                                                                                                                                if (this.lexer.token() == Token.PARTITION) {
                                                                                                                                    this.lexer.nextToken();
                                                                                                                                    SQLAlterTableAddPartition item6 = new SQLAlterTableAddPartition();
                                                                                                                                    if (this.lexer.identifierEquals(PARTITIONS)) {
                                                                                                                                        this.lexer.nextToken();
                                                                                                                                        item6.setPartitionCount(this.exprParser.integerExpr());
                                                                                                                                    }
                                                                                                                                    if (this.lexer.token() == Token.LPAREN) {
                                                                                                                                        this.lexer.nextToken();
                                                                                                                                        SQLPartition sQLPartition = this.getExprParser().parsePartition();
                                                                                                                                        this.accept(Token.RPAREN);
                                                                                                                                        item6.addPartition(sQLPartition);
                                                                                                                                    }
                                                                                                                                    stmt.addItem(item6);
                                                                                                                                    break block74;
                                                                                                                                } else {
                                                                                                                                    this.parseAlterTableAddColumn(stmt);
                                                                                                                                }
                                                                                                                                break block74;
                                                                                                                            }
                                                                                                                            if (this.lexer.token() != Token.ALTER) break block88;
                                                                                                                            this.lexer.nextToken();
                                                                                                                            if (this.lexer.token() == Token.COLUMN) {
                                                                                                                                this.lexer.nextToken();
                                                                                                                            }
                                                                                                                            MySqlAlterTableAlterColumn alterColumn = new MySqlAlterTableAlterColumn();
                                                                                                                            alterColumn.setColumn(this.exprParser.name());
                                                                                                                            if (this.lexer.token() == Token.SET) {
                                                                                                                                this.lexer.nextToken();
                                                                                                                                this.accept(Token.DEFAULT);
                                                                                                                                alterColumn.setDefaultExpr(this.exprParser.expr());
                                                                                                                            } else {
                                                                                                                                this.accept(Token.DROP);
                                                                                                                                this.accept(Token.DEFAULT);
                                                                                                                                alterColumn.setDropDefault(true);
                                                                                                                            }
                                                                                                                            stmt.addItem(alterColumn);
                                                                                                                            break block74;
                                                                                                                        }
                                                                                                                        if (!this.lexer.identifierEquals("CHANGE")) break block89;
                                                                                                                        this.lexer.nextToken();
                                                                                                                        if (this.lexer.token() == Token.COLUMN) {
                                                                                                                            this.lexer.nextToken();
                                                                                                                        }
                                                                                                                        MySqlAlterTableChangeColumn item7 = new MySqlAlterTableChangeColumn();
                                                                                                                        item7.setColumnName(this.exprParser.name());
                                                                                                                        item7.setNewColumnDefinition(this.exprParser.parseColumn());
                                                                                                                        if (this.lexer.identifierEquals("AFTER")) {
                                                                                                                            this.lexer.nextToken();
                                                                                                                            item7.setAfterColumn(this.exprParser.name());
                                                                                                                        } else if (this.lexer.identifierEquals("FIRST")) {
                                                                                                                            this.lexer.nextToken();
                                                                                                                            if (this.lexer.token() == Token.IDENTIFIER) {
                                                                                                                                item7.setFirstColumn(this.exprParser.name());
                                                                                                                            } else {
                                                                                                                                item7.setFirst(true);
                                                                                                                            }
                                                                                                                        }
                                                                                                                        stmt.addItem(item7);
                                                                                                                        break block74;
                                                                                                                    }
                                                                                                                    if (!this.lexer.identifierEquals("MODIFY")) break block90;
                                                                                                                    this.lexer.nextToken();
                                                                                                                    if (this.lexer.token() == Token.COLUMN) {
                                                                                                                        this.lexer.nextToken();
                                                                                                                    }
                                                                                                                    paren = false;
                                                                                                                    if (this.lexer.token() == Token.LPAREN) {
                                                                                                                        paren = true;
                                                                                                                        this.lexer.nextToken();
                                                                                                                    }
                                                                                                                    break block91;
                                                                                                                }
                                                                                                                if (this.lexer.token() != Token.DISABLE) break block92;
                                                                                                                this.lexer.nextToken();
                                                                                                                if (this.lexer.token() == Token.CONSTRAINT) {
                                                                                                                    this.lexer.nextToken();
                                                                                                                    SQLAlterTableDisableConstraint item8 = new SQLAlterTableDisableConstraint();
                                                                                                                    item8.setConstraintName(this.exprParser.name());
                                                                                                                    stmt.addItem(item8);
                                                                                                                    break block74;
                                                                                                                } else {
                                                                                                                    this.acceptIdentifier("KEYS");
                                                                                                                    SQLAlterTableDisableKeys item9 = new SQLAlterTableDisableKeys();
                                                                                                                    stmt.addItem(item9);
                                                                                                                }
                                                                                                                break block74;
                                                                                                            }
                                                                                                            if (this.lexer.token() != Token.ENABLE) break block93;
                                                                                                            this.lexer.nextToken();
                                                                                                            if (this.lexer.token() == Token.CONSTRAINT) {
                                                                                                                this.lexer.nextToken();
                                                                                                                SQLAlterTableEnableConstraint item10 = new SQLAlterTableEnableConstraint();
                                                                                                                item10.setConstraintName(this.exprParser.name());
                                                                                                                stmt.addItem(item10);
                                                                                                                break block74;
                                                                                                            } else {
                                                                                                                this.acceptIdentifier("KEYS");
                                                                                                                SQLAlterTableEnableKeys item11 = new SQLAlterTableEnableKeys();
                                                                                                                stmt.addItem(item11);
                                                                                                            }
                                                                                                            break block74;
                                                                                                        }
                                                                                                        if (!this.lexer.identifierEquals("RENAME")) break block94;
                                                                                                        this.lexer.nextToken();
                                                                                                        if (this.lexer.token() == Token.INDEX) {
                                                                                                            this.lexer.nextToken();
                                                                                                            SQLName name = this.exprParser.name();
                                                                                                            this.accept(Token.TO);
                                                                                                            SQLName sQLName = this.exprParser.name();
                                                                                                            item = new SQLAlterTableRenameIndex(name, sQLName);
                                                                                                            stmt.addItem((SQLAlterTableItem)((Object)item));
                                                                                                            continue;
                                                                                                        }
                                                                                                        if (this.lexer.token() == Token.TO || this.lexer.token() == Token.AS) {
                                                                                                            this.lexer.nextToken();
                                                                                                        }
                                                                                                        if (stmt.getItems().size() <= 0) {
                                                                                                            MySqlRenameTableStatement renameStmt = new MySqlRenameTableStatement();
                                                                                                            MySqlRenameTableStatement.Item item12 = new MySqlRenameTableStatement.Item();
                                                                                                            item12.setName((SQLName)stmt.getTableSource().getExpr());
                                                                                                            item12.setTo(this.exprParser.name());
                                                                                                            renameStmt.addItem(item12);
                                                                                                            return renameStmt;
                                                                                                        }
                                                                                                        SQLAlterTableRename item13 = new SQLAlterTableRename();
                                                                                                        SQLName sQLName = this.exprParser.name();
                                                                                                        item13.setTo(sQLName);
                                                                                                        stmt.addItem(item13);
                                                                                                        break block74;
                                                                                                    }
                                                                                                    if (this.lexer.token() == Token.ORDER) {
                                                                                                        throw new ParserException("TODO " + this.lexer.info());
                                                                                                    }
                                                                                                    if (!this.lexer.identifierEquals("CONVERT")) break block95;
                                                                                                    this.lexer.nextToken();
                                                                                                    this.accept(Token.TO);
                                                                                                    this.acceptIdentifier("CHARACTER");
                                                                                                    this.accept(Token.SET);
                                                                                                    SQLAlterTableConvertCharSet item = new SQLAlterTableConvertCharSet();
                                                                                                    SQLExpr sQLExpr = this.exprParser.primary();
                                                                                                    item.setCharset(sQLExpr);
                                                                                                    if (this.lexer.identifierEquals(COLLATE2)) {
                                                                                                        this.lexer.nextToken();
                                                                                                        SQLExpr collate = this.exprParser.primary();
                                                                                                        item.setCollate(collate);
                                                                                                    }
                                                                                                    stmt.addItem(item);
                                                                                                    break block74;
                                                                                                }
                                                                                                if (this.lexer.token() != Token.DEFAULT) break block96;
                                                                                                this.lexer.nextToken();
                                                                                                if (!this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
                                                                                                    throw new ParserException("TODO " + this.lexer.info());
                                                                                                }
                                                                                                SQLAlterCharacter item = this.alterTableCharacter();
                                                                                                stmt.addItem(item);
                                                                                                break block74;
                                                                                            }
                                                                                            if (!this.lexer.identifierEquals("DISCARD")) break block97;
                                                                                            this.lexer.nextToken();
                                                                                            if (this.lexer.token() == Token.PARTITION) {
                                                                                                this.lexer.nextToken();
                                                                                                SQLAlterTableDiscardPartition item = new SQLAlterTableDiscardPartition();
                                                                                                if (this.lexer.token() == Token.ALL) {
                                                                                                    this.lexer.nextToken();
                                                                                                    item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                                                                } else {
                                                                                                    this.exprParser.names(item.getPartitions(), item);
                                                                                                }
                                                                                                if (this.lexer.token() == Token.TABLESPACE) {
                                                                                                    this.lexer.nextToken();
                                                                                                    item.setTablespace(true);
                                                                                                }
                                                                                                stmt.addItem(item);
                                                                                                break block74;
                                                                                            } else {
                                                                                                this.accept(Token.TABLESPACE);
                                                                                                MySqlAlterTableDiscardTablespace item = new MySqlAlterTableDiscardTablespace();
                                                                                                stmt.addItem(item);
                                                                                            }
                                                                                            break block74;
                                                                                        }
                                                                                        if (this.lexer.token() != Token.CHECK) break block98;
                                                                                        this.lexer.nextToken();
                                                                                        this.accept(Token.PARTITION);
                                                                                        SQLAlterTableCheckPartition item = new SQLAlterTableCheckPartition();
                                                                                        if (this.lexer.token() == Token.ALL) {
                                                                                            this.lexer.nextToken();
                                                                                            item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                                                        } else {
                                                                                            this.exprParser.names(item.getPartitions(), item);
                                                                                        }
                                                                                        stmt.addItem(item);
                                                                                        break block74;
                                                                                    }
                                                                                    if (!this.lexer.identifierEquals("IMPORT")) break block99;
                                                                                    this.lexer.nextToken();
                                                                                    if (this.lexer.token() == Token.PARTITION) {
                                                                                        this.lexer.nextToken();
                                                                                        SQLAlterTableImportPartition item = new SQLAlterTableImportPartition();
                                                                                        if (this.lexer.token() == Token.ALL) {
                                                                                            this.lexer.nextToken();
                                                                                            item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                                                        } else {
                                                                                            this.exprParser.names(item.getPartitions(), item);
                                                                                        }
                                                                                        stmt.addItem(item);
                                                                                        break block74;
                                                                                    } else {
                                                                                        this.accept(Token.TABLESPACE);
                                                                                        MySqlAlterTableImportTablespace item = new MySqlAlterTableImportTablespace();
                                                                                        stmt.addItem(item);
                                                                                    }
                                                                                    break block74;
                                                                                }
                                                                                if (this.lexer.token() != Token.ANALYZE) break block100;
                                                                                this.lexer.nextToken();
                                                                                this.accept(Token.PARTITION);
                                                                                SQLAlterTableAnalyzePartition item = new SQLAlterTableAnalyzePartition();
                                                                                if (this.lexer.token() == Token.ALL) {
                                                                                    this.lexer.nextToken();
                                                                                    item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                                                } else {
                                                                                    this.exprParser.names(item.getPartitions(), item);
                                                                                }
                                                                                stmt.addItem(item);
                                                                                break block74;
                                                                            }
                                                                            if (this.lexer.identifierEquals("FORCE")) {
                                                                                throw new ParserException("TODO " + this.lexer.info());
                                                                            }
                                                                            if (!this.lexer.identifierEquals("COALESCE")) break block101;
                                                                            this.lexer.nextToken();
                                                                            this.accept(Token.PARTITION);
                                                                            SQLAlterTableCoalescePartition item = new SQLAlterTableCoalescePartition();
                                                                            SQLIntegerExpr sQLIntegerExpr = this.exprParser.integerExpr();
                                                                            item.setCount(sQLIntegerExpr);
                                                                            stmt.addItem(item);
                                                                            break block74;
                                                                        }
                                                                        if (!this.lexer.identifierEquals("REORGANIZE")) break block102;
                                                                        this.lexer.nextToken();
                                                                        this.accept(Token.PARTITION);
                                                                        SQLAlterTableReOrganizePartition item = new SQLAlterTableReOrganizePartition();
                                                                        this.exprParser.names(item.getNames(), item);
                                                                        this.accept(Token.INTO);
                                                                        this.accept(Token.LPAREN);
                                                                        while (true) {
                                                                            SQLPartition sQLPartition = this.getExprParser().parsePartition();
                                                                            item.addPartition(sQLPartition);
                                                                            if (this.lexer.token() != Token.COMMA) break;
                                                                            this.lexer.nextToken();
                                                                        }
                                                                        this.accept(Token.RPAREN);
                                                                        stmt.addItem(item);
                                                                        break block74;
                                                                    }
                                                                    if (!this.lexer.identifierEquals("EXCHANGE")) break block103;
                                                                    this.lexer.nextToken();
                                                                    this.accept(Token.PARTITION);
                                                                    SQLAlterTableExchangePartition item = new SQLAlterTableExchangePartition();
                                                                    SQLName sQLName = this.exprParser.name();
                                                                    item.setPartition(sQLName);
                                                                    this.accept(Token.WITH);
                                                                    this.accept(Token.TABLE);
                                                                    SQLName table = this.exprParser.name();
                                                                    item.setTable(table);
                                                                    if (this.lexer.token() == Token.WITH) {
                                                                        this.lexer.nextToken();
                                                                        this.acceptIdentifier("VALIDATION");
                                                                        item.setValidation(true);
                                                                    } else if (this.lexer.identifierEquals(FnvHash.Constants.WITHOUT)) {
                                                                        this.lexer.nextToken();
                                                                        this.acceptIdentifier("VALIDATION");
                                                                        item.setValidation(false);
                                                                    }
                                                                    stmt.addItem(item);
                                                                    break block74;
                                                                }
                                                                if (this.lexer.token() != Token.OPTIMIZE) break block104;
                                                                this.lexer.nextToken();
                                                                this.accept(Token.PARTITION);
                                                                SQLAlterTableOptimizePartition item = new SQLAlterTableOptimizePartition();
                                                                if (this.lexer.token() == Token.ALL) {
                                                                    this.lexer.nextToken();
                                                                    item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                                } else {
                                                                    this.exprParser.names(item.getPartitions(), item);
                                                                }
                                                                stmt.addItem(item);
                                                                break block74;
                                                            }
                                                            if (!this.lexer.identifierEquals("REBUILD")) break block105;
                                                            this.lexer.nextToken();
                                                            this.accept(Token.PARTITION);
                                                            SQLAlterTableRebuildPartition item = new SQLAlterTableRebuildPartition();
                                                            if (this.lexer.token() == Token.ALL) {
                                                                this.lexer.nextToken();
                                                                item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                            } else {
                                                                this.exprParser.names(item.getPartitions(), item);
                                                            }
                                                            stmt.addItem(item);
                                                            break block74;
                                                        }
                                                        if (!this.lexer.identifierEquals("REPAIR")) break block106;
                                                        this.lexer.nextToken();
                                                        this.accept(Token.PARTITION);
                                                        SQLAlterTableRepairPartition item = new SQLAlterTableRepairPartition();
                                                        if (this.lexer.token() == Token.ALL) {
                                                            this.lexer.nextToken();
                                                            item.getPartitions().add(new SQLIdentifierExpr("ALL"));
                                                        } else {
                                                            this.exprParser.names(item.getPartitions(), item);
                                                        }
                                                        stmt.addItem(item);
                                                        break block74;
                                                    }
                                                    if (!this.lexer.identifierEquals("REMOVE")) break block107;
                                                    this.lexer.nextToken();
                                                    this.acceptIdentifier("PARTITIONING");
                                                    stmt.setRemovePatiting(true);
                                                    break block74;
                                                }
                                                if (!this.lexer.identifierEquals("UPGRADE")) break block108;
                                                this.lexer.nextToken();
                                                this.acceptIdentifier("PARTITIONING");
                                                stmt.setUpgradePatiting(true);
                                                break block74;
                                            }
                                            if (!this.lexer.identifierEquals("ALGORITHM")) break block109;
                                            this.lexer.nextToken();
                                            this.accept(Token.EQ);
                                            stmt.addItem(new MySqlAlterTableOption("ALGORITHM", this.lexer.stringVal()));
                                            this.lexer.nextToken();
                                            break block74;
                                        }
                                        if (!this.lexer.identifierEquals(ENGINE)) break block110;
                                        this.lexer.nextToken();
                                        this.accept(Token.EQ);
                                        stmt.addItem(new MySqlAlterTableOption(ENGINE, this.lexer.stringVal()));
                                        this.lexer.nextToken();
                                        break block74;
                                    }
                                    if (!this.lexer.identifierEquals(AUTO_INCREMENT)) break block111;
                                    this.lexer.nextToken();
                                    this.accept(Token.EQ);
                                    stmt.addItem(new MySqlAlterTableOption(AUTO_INCREMENT, new SQLIntegerExpr(this.lexer.integerValue())));
                                    this.lexer.nextToken();
                                    break block74;
                                }
                                if (!this.lexer.identifierEquals(COLLATE2)) break block112;
                                this.lexer.nextToken();
                                this.accept(Token.EQ);
                                stmt.addItem(new MySqlAlterTableOption(COLLATE2, this.lexer.stringVal()));
                                this.lexer.nextToken();
                                break block74;
                            }
                            if (!this.lexer.identifierEquals("PACK_KEYS")) break block113;
                            this.lexer.nextToken();
                            this.accept(Token.EQ);
                            if (this.lexer.identifierEquals("PACK")) {
                                this.lexer.nextToken();
                                this.accept(Token.ALL);
                                stmt.addItem(new MySqlAlterTableOption("PACK_KEYS", "PACK ALL"));
                                break block74;
                            } else {
                                stmt.addItem(new MySqlAlterTableOption("PACK_KEYS", this.lexer.stringVal()));
                                this.lexer.nextToken();
                            }
                            break block74;
                        }
                        if (!this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) break block114;
                        SQLAlterCharacter item = this.alterTableCharacter();
                        stmt.addItem(item);
                        break block74;
                    }
                    if (this.lexer.token() == Token.COMMENT) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.EQ) {
                            this.accept(Token.EQ);
                        }
                        stmt.addItem(new MySqlAlterTableOption("COMMENT", '\'' + this.lexer.stringVal() + '\''));
                        this.lexer.nextToken();
                        break block74;
                    } else if (this.lexer.token() == Token.UNION) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.EQ) {
                            this.lexer.nextToken();
                        }
                        this.accept(Token.LPAREN);
                        SQLTableSource tableSrc = this.createSQLSelectParser().parseTableSource();
                        stmt.getTableOptions().put("UNION", tableSrc);
                        this.accept(Token.RPAREN);
                        break block74;
                    } else {
                        if (!this.lexer.identifierEquals("ROW_FORMAT")) break;
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.EQ) {
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() != Token.DEFAULT && this.lexer.token() != Token.IDENTIFIER) {
                            throw new ParserException("illegal syntax. " + this.lexer.info());
                        }
                        SQLIdentifierExpr rowFormat = new SQLIdentifierExpr(this.lexer.stringVal());
                        this.lexer.nextToken();
                        stmt.getTableOptions().put("ROW_FORMAT", rowFormat);
                    }
                    break block74;
                }
                while (true) {
                    MySqlAlterTableModifyColumn mySqlAlterTableModifyColumn = new MySqlAlterTableModifyColumn();
                    mySqlAlterTableModifyColumn.setNewColumnDefinition(this.exprParser.parseColumn());
                    if (this.lexer.identifierEquals("AFTER")) {
                        this.lexer.nextToken();
                        mySqlAlterTableModifyColumn.setAfterColumn(this.exprParser.name());
                    } else if (this.lexer.identifierEquals("FIRST")) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.IDENTIFIER) {
                            mySqlAlterTableModifyColumn.setFirstColumn(this.exprParser.name());
                        } else {
                            mySqlAlterTableModifyColumn.setFirst(true);
                        }
                    }
                    stmt.addItem(mySqlAlterTableModifyColumn);
                    if (!paren || this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                if (paren) {
                    this.accept(Token.RPAREN);
                }
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    private SQLAlterCharacter alterTableCharacter() {
        this.lexer.nextToken();
        this.accept(Token.SET);
        this.accept(Token.EQ);
        SQLAlterCharacter item = new SQLAlterCharacter();
        item.setCharacterSet(this.exprParser.primary());
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            this.acceptIdentifier(COLLATE2);
            this.accept(Token.EQ);
            item.setCollate(this.exprParser.primary());
        }
        return item;
    }

    protected void parseAlterTableAddColumn(SQLAlterTableStatement stmt) {
        boolean parenFlag = false;
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            parenFlag = true;
        }
        SQLAlterTableAddColumn item = new SQLAlterTableAddColumn();
        while (true) {
            SQLColumnDefinition columnDef = this.exprParser.parseColumn();
            item.addColumn(columnDef);
            if (this.lexer.identifierEquals("AFTER")) {
                this.lexer.nextToken();
                item.setAfterColumn(this.exprParser.name());
            } else if (this.lexer.identifierEquals("FIRST")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.IDENTIFIER) {
                    item.setFirstColumn(this.exprParser.name());
                } else {
                    item.setFirst(true);
                }
            }
            if (!parenFlag || this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        stmt.addItem(item);
        if (parenFlag) {
            this.accept(Token.RPAREN);
        }
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropIndex item = new SQLAlterTableDropIndex();
            item.setIndexName(indexName);
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.FOREIGN) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropForeignKey item = new SQLAlterTableDropForeignKey();
            item.setIndexName(indexName);
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            SQLName keyName = this.exprParser.name();
            SQLAlterTableDropKey item = new SQLAlterTableDropKey();
            item.setKeyName(keyName);
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.PRIMARY) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            SQLAlterTableDropPrimaryKey item = new SQLAlterTableDropPrimaryKey();
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            item.setConstraintName(this.exprParser.name());
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            SQLName name = this.exprParser.name();
            name.setParent(item);
            item.addColumn(name);
            while (this.lexer.token() == Token.COMMA) {
                char markChar = this.lexer.current();
                int markBp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("CHANGE")) {
                    this.lexer.reset(markBp, markChar, Token.COMMA);
                    break;
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    if ("ADD".equalsIgnoreCase(this.lexer.stringVal())) {
                        this.lexer.reset(markBp, markChar, Token.COMMA);
                        break;
                    }
                    name = this.exprParser.name();
                    name.setParent(item);
                    continue;
                }
                this.lexer.reset(markBp, markChar, Token.COMMA);
                break;
            }
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.PARTITION) {
            SQLAlterTableDropPartition dropPartition = this.parseAlterTableDropPartition(false);
            stmt.addItem(dropPartition);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            SQLName name = this.exprParser.name();
            item.addColumn(name);
            stmt.addItem(item);
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.DROP) {
                this.parseAlterDrop(stmt);
            }
        } else {
            super.parseAlterDrop(stmt);
        }
    }

    @Override
    public SQLStatement parseRename() {
        MySqlRenameTableStatement stmt = new MySqlRenameTableStatement();
        this.acceptIdentifier("RENAME");
        this.accept(Token.TABLE);
        while (true) {
            MySqlRenameTableStatement.Item item = new MySqlRenameTableStatement.Item();
            item.setName(this.exprParser.name());
            this.accept(Token.TO);
            item.setTo(this.exprParser.name());
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateDatabase() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement("mysql");
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.HINT) {
            stmt.setHints(this.exprParser.parseHints());
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
        }
        while (true) {
            String charset;
            if (this.lexer.identifierEquals("CHARACTER")) {
                this.lexer.nextToken();
                this.accept(Token.SET);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                charset = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                stmt.setCharacterSet(charset);
                continue;
            }
            if (this.lexer.identifierEquals("CHARSET")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                charset = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                stmt.setCharacterSet(charset);
                continue;
            }
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                continue;
            }
            if (!this.lexer.identifierEquals(COLLATE2)) break;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            String collate = this.lexer.stringVal();
            this.accept(Token.IDENTIFIER);
            stmt.setCollate(collate);
        }
        return stmt;
    }

    @Override
    protected void parseUpdateSet(SQLUpdateStatement update) {
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            update.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLStatement parseAlterDatabase() {
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        SQLAlterDatabaseStatement stmt = new SQLAlterDatabaseStatement(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.identifierEquals("UPGRADE")) {
            this.lexer.nextToken();
            this.acceptIdentifier("DATA");
            this.acceptIdentifier("DIRECTORY");
            this.acceptIdentifier("NAME");
            stmt.setUpgradeDataDirectoryName(true);
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) throw new ParserException("TODO " + this.lexer.info());
            SQLAlterCharacter item = this.alterTableCharacter();
            stmt.setCharacter(item);
            return stmt;
        } else {
            if (!this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) return stmt;
            SQLAlterCharacter item = this.alterTableCharacter();
            stmt.setCharacter(item);
        }
        return stmt;
    }

    public MySqlAlterUserStatement parseAlterUser() {
        this.accept(Token.USER);
        MySqlAlterUserStatement stmt = new MySqlAlterUserStatement();
        while (true) {
            SQLExpr user = this.exprParser.expr();
            this.acceptIdentifier("PASSWORD");
            this.acceptIdentifier("EXPIRE");
            stmt.addUser(user);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public MySqlExprParser getExprParser() {
        return (MySqlExprParser)this.exprParser;
    }

    @Override
    public SQLCreateFunctionStatement parseCreateFunction() {
        SQLCreateFunctionStatement stmt = new SQLCreateFunctionStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OR) {
                this.lexer.nextToken();
                this.accept(Token.REPLACE);
                stmt.setOrReplace(true);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = this.getExprParser().userName();
            stmt.setDefiner(definer);
        }
        this.accept(Token.FUNCTION);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.parserParameters(stmt.getParameters(), stmt);
            this.accept(Token.RPAREN);
        }
        this.acceptIdentifier("RETURNS");
        SQLDataType dataType = this.exprParser.parseDataType();
        stmt.setReturnDataType(dataType);
        while (this.lexer.identifierEquals("DETERMINISTIC")) {
            this.lexer.nextToken();
            stmt.setDeterministic(true);
        }
        SQLStatement block = this.lexer.token() == Token.BEGIN ? this.parseBlock() : this.parseStatement();
        stmt.setBlock(block);
        return stmt;
    }

    @Override
    public SQLCreateProcedureStatement parseCreateProcedure() {
        SQLCreateProcedureStatement stmt = new SQLCreateProcedureStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OR) {
                this.lexer.nextToken();
                this.accept(Token.REPLACE);
                stmt.setOrReplace(true);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = this.getExprParser().userName();
            stmt.setDefiner(definer);
        }
        this.accept(Token.PROCEDURE);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.parserParameters(stmt.getParameters(), stmt);
            this.accept(Token.RPAREN);
        }
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.DETERMINISTIC)) {
                this.lexer.nextToken();
                stmt.setDeterministic(true);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.CONTAINS) && this.lexer.token() != Token.CONTAINS) break;
            this.lexer.nextToken();
            this.acceptIdentifier("SQL");
            stmt.setContainsSql(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
            this.lexer.nextToken();
            this.acceptIdentifier("SECURITY");
            SQLName authid = this.exprParser.name();
            stmt.setAuthid(authid);
        }
        SQLStatement block = this.lexer.token() == Token.BEGIN ? this.parseBlock() : this.parseStatement();
        stmt.setBlock(block);
        return stmt;
    }

    private void parserParameters(List<SQLParameter> parameters, SQLObject parent) {
        if (this.lexer.token() == Token.RPAREN) {
            return;
        }
        do {
            SQLParameter parameter = new SQLParameter();
            if (this.lexer.token() == Token.CURSOR) {
                this.lexer.nextToken();
                parameter.setName(this.exprParser.name());
                this.accept(Token.IS);
                SQLSelect select = this.createSQLSelectParser().select();
                SQLDataTypeImpl dataType = new SQLDataTypeImpl();
                dataType.setName("CURSOR");
                parameter.setDataType(dataType);
                parameter.setDefaultValue(new SQLQueryExpr(select));
            } else if (this.lexer.token() == Token.IN || this.lexer.token() == Token.OUT || this.lexer.token() == Token.INOUT) {
                if (this.lexer.token() == Token.IN) {
                    parameter.setParamType(SQLParameter.ParameterType.IN);
                } else if (this.lexer.token() == Token.OUT) {
                    parameter.setParamType(SQLParameter.ParameterType.OUT);
                } else if (this.lexer.token() == Token.INOUT) {
                    parameter.setParamType(SQLParameter.ParameterType.INOUT);
                }
                this.lexer.nextToken();
                parameter.setName(this.exprParser.name());
                parameter.setDataType(this.exprParser.parseDataType());
            } else {
                parameter.setParamType(SQLParameter.ParameterType.DEFAULT);
                parameter.setName(this.exprParser.name());
                parameter.setDataType(this.exprParser.parseDataType());
                if (this.lexer.token() == Token.COLONEQ) {
                    this.lexer.nextToken();
                    parameter.setDefaultValue(this.exprParser.expr());
                }
            }
            parameters.add(parameter);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.SEMI) continue;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.RPAREN);
    }

    private void parseProcedureStatementList(List<SQLStatement> statementList) {
        this.parseProcedureStatementList(statementList, -1);
    }

    private void parseProcedureStatementList(List<SQLStatement> statementList, int max) {
        block35: {
            int bp;
            char ch;
            while (true) {
                if (max != -1 && statementList.size() >= max) {
                    return;
                }
                if (this.lexer.token() == Token.EOF) {
                    return;
                }
                if (this.lexer.token() == Token.END) {
                    return;
                }
                if (this.lexer.token() == Token.ELSE) {
                    return;
                }
                if (this.lexer.token() == Token.SEMI) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token() == Token.WHEN) {
                    return;
                }
                if (this.lexer.token() == Token.UNTIL) {
                    return;
                }
                if (this.lexer.token() == Token.SELECT) {
                    statementList.add(this.parseSelectInto());
                    continue;
                }
                if (this.lexer.token() == Token.UPDATE) {
                    statementList.add(this.parseUpdateStatement());
                    continue;
                }
                if (this.lexer.token() == Token.CREATE) {
                    statementList.add(this.parseCreate());
                    continue;
                }
                if (this.lexer.token() == Token.INSERT) {
                    SQLInsertStatement stmt = this.parseInsert();
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.DELETE) {
                    statementList.add(this.parseDeleteStatement());
                    continue;
                }
                if (this.lexer.token() == Token.LBRACE || this.lexer.identifierEquals("CALL")) {
                    statementList.add(this.parseCall());
                    continue;
                }
                if (this.lexer.token() == Token.BEGIN) {
                    statementList.add(this.parseBlock());
                    continue;
                }
                if (this.lexer.token() == Token.VARIANT) {
                    SQLBinaryOpExpr binaryOpExpr;
                    SQLExpr variant = this.exprParser.primary();
                    if (variant instanceof SQLBinaryOpExpr && (binaryOpExpr = (SQLBinaryOpExpr)variant).getOperator() == SQLBinaryOperator.Assignment) {
                        SQLSetStatement stmt = new SQLSetStatement(binaryOpExpr.getLeft(), binaryOpExpr.getRight(), this.getDbType());
                        statementList.add(stmt);
                        continue;
                    }
                    this.accept(Token.COLONEQ);
                    SQLExpr value = this.exprParser.expr();
                    SQLSetStatement stmt = new SQLSetStatement(variant, value, this.getDbType());
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.LPAREN) {
                    char ch2 = this.lexer.current();
                    int bp2 = this.lexer.bp();
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.SELECT) {
                        this.lexer.reset(bp2, ch2, Token.LPAREN);
                        statementList.add(this.parseSelect());
                        continue;
                    }
                    throw new ParserException("TODO. " + this.lexer.info());
                }
                if (this.lexer.token() == Token.SET) {
                    statementList.add(this.parseAssign());
                    continue;
                }
                if (this.lexer.token() == Token.WHILE) {
                    SQLWhileStatement stmt = this.parseWhile();
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.LOOP) {
                    statementList.add(this.parseLoop());
                    continue;
                }
                if (this.lexer.token() == Token.IF) {
                    statementList.add(this.parseIf());
                    continue;
                }
                if (this.lexer.token() == Token.CASE) {
                    statementList.add(this.parseCase());
                    continue;
                }
                if (this.lexer.token() == Token.DECLARE) {
                    SQLStatement stmt = this.parseDeclare();
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.LEAVE) {
                    statementList.add(this.parseLeave());
                    continue;
                }
                if (this.lexer.token() == Token.ITERATE) {
                    statementList.add(this.parseIterate());
                    continue;
                }
                if (this.lexer.token() == Token.REPEAT) {
                    statementList.add(this.parseRepeat());
                    continue;
                }
                if (this.lexer.token() == Token.OPEN) {
                    statementList.add(this.parseOpen());
                    continue;
                }
                if (this.lexer.token() == Token.CLOSE) {
                    statementList.add(this.parseClose());
                    continue;
                }
                if (this.lexer.token() == Token.FETCH) {
                    statementList.add(this.parseFetch());
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.CHECKSUM)) {
                    statementList.add(this.parseChecksum());
                    continue;
                }
                if (this.lexer.token() != Token.IDENTIFIER) break block35;
                String label = this.lexer.stringVal();
                ch = this.lexer.current();
                bp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.token() != Token.VARIANT || !this.lexer.stringVal().equals(":")) break;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LOOP) {
                    statementList.add(this.parseLoop(label));
                    continue;
                }
                if (this.lexer.token() == Token.WHILE) {
                    statementList.add(this.parseWhile(label));
                    continue;
                }
                if (this.lexer.token() == Token.BEGIN) {
                    statementList.add(this.parseBlock(label));
                    continue;
                }
                if (this.lexer.token() != Token.REPEAT) continue;
                statementList.add(this.parseRepeat(label));
            }
            this.lexer.reset(bp, ch, Token.IDENTIFIER);
        }
        throw new ParserException("TODO, " + this.lexer.info());
    }

    public MySqlChecksumTableStatement parseChecksum() {
        MySqlChecksumTableStatement stmt = new MySqlChecksumTableStatement();
        if (!this.lexer.identifierEquals(FnvHash.Constants.CHECKSUM)) {
            throw new ParserException("TODO " + this.lexer.info());
        }
        this.lexer.nextToken();
        while (true) {
            SQLExprTableSource table = (SQLExprTableSource)this.createSQLSelectParser().parseTableSource();
            stmt.addTable(table);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLIfStatement parseIf() {
        this.accept(Token.IF);
        SQLIfStatement stmt = new SQLIfStatement();
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.THEN);
        this.parseStatementList(stmt.getStatements(), -1, stmt);
        while (this.lexer.token() == Token.ELSE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                SQLIfStatement.ElseIf elseIf = new SQLIfStatement.ElseIf();
                elseIf.setCondition(this.exprParser.expr());
                elseIf.setParent(stmt);
                this.accept(Token.THEN);
                this.parseStatementList(elseIf.getStatements(), -1, elseIf);
                stmt.getElseIfList().add(elseIf);
                continue;
            }
            SQLIfStatement.Else elseItem = new SQLIfStatement.Else();
            this.parseStatementList(elseItem.getStatements(), -1, elseItem);
            stmt.setElseItem(elseItem);
            break;
        }
        this.accept(Token.END);
        this.accept(Token.IF);
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    @Override
    public SQLWhileStatement parseWhile() {
        this.accept(Token.WHILE);
        SQLWhileStatement stmt = new SQLWhileStatement();
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.DO);
        this.parseStatementList(stmt.getStatements(), -1, stmt);
        this.accept(Token.END);
        this.accept(Token.WHILE);
        this.accept(Token.SEMI);
        return stmt;
    }

    public SQLWhileStatement parseWhile(String label) {
        this.accept(Token.WHILE);
        SQLWhileStatement stmt = new SQLWhileStatement();
        stmt.setLabelName(label);
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.DO);
        this.parseStatementList(stmt.getStatements(), -1, stmt);
        this.accept(Token.END);
        this.accept(Token.WHILE);
        this.acceptIdentifier(label);
        this.accept(Token.SEMI);
        return stmt;
    }

    @Override
    public MySqlCaseStatement parseCase() {
        MySqlCaseStatement stmt = new MySqlCaseStatement();
        this.accept(Token.CASE);
        if (this.lexer.token() == Token.WHEN) {
            while (this.lexer.token() == Token.WHEN) {
                MySqlCaseStatement.MySqlWhenStatement when = new MySqlCaseStatement.MySqlWhenStatement();
                when.setCondition(this.exprParser.expr());
                this.accept(Token.THEN);
                this.parseStatementList(when.getStatements(), -1, when);
                stmt.addWhenStatement(when);
            }
            if (this.lexer.token() == Token.ELSE) {
                SQLIfStatement.Else elseStmt = new SQLIfStatement.Else();
                this.parseStatementList(elseStmt.getStatements(), -1, elseStmt);
                stmt.setElseItem(elseStmt);
            }
        } else {
            stmt.setCondition(this.exprParser.expr());
            while (this.lexer.token() == Token.WHEN) {
                this.accept(Token.WHEN);
                MySqlCaseStatement.MySqlWhenStatement when = new MySqlCaseStatement.MySqlWhenStatement();
                when.setCondition(this.exprParser.expr());
                this.accept(Token.THEN);
                this.parseStatementList(when.getStatements(), -1, when);
                stmt.addWhenStatement(when);
            }
            if (this.lexer.token() == Token.ELSE) {
                this.accept(Token.ELSE);
                SQLIfStatement.Else elseStmt = new SQLIfStatement.Else();
                this.parseStatementList(elseStmt.getStatements(), -1, elseStmt);
                stmt.setElseItem(elseStmt);
            }
        }
        this.accept(Token.END);
        this.accept(Token.CASE);
        this.accept(Token.SEMI);
        return stmt;
    }

    @Override
    public SQLStatement parseDeclare() {
        SQLDeclareItem item;
        char markChar = this.lexer.current();
        int markBp = this.lexer.bp();
        this.lexer.nextToken();
        if (this.lexer.token() == Token.CONTINUE) {
            this.lexer.reset(markBp, markChar, Token.DECLARE);
            return this.parseDeclareHandler();
        }
        this.lexer.nextToken();
        if (this.lexer.token() == Token.CURSOR) {
            this.lexer.reset(markBp, markChar, Token.DECLARE);
            return this.parseCursorDeclare();
        }
        if (this.lexer.identifierEquals("HANDLER")) {
            this.lexer.reset(markBp, markChar, Token.DECLARE);
            return this.parseDeclareHandler();
        }
        if (this.lexer.token() == Token.CONDITION) {
            this.lexer.reset(markBp, markChar, Token.DECLARE);
            return this.parseDeclareCondition();
        }
        this.lexer.reset(markBp, markChar, Token.DECLARE);
        MySqlDeclareStatement stmt = new MySqlDeclareStatement();
        this.accept(Token.DECLARE);
        while (true) {
            item = new SQLDeclareItem();
            item.setName(this.exprParser.name());
            stmt.addVar(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
            stmt.setAfterSemi(true);
        }
        if (this.lexer.token() != Token.EOF) {
            item.setDataType(this.exprParser.parseDataType());
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                SQLExpr defaultValue = this.exprParser.primary();
                item.setValue(defaultValue);
            }
        } else {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        return stmt;
    }

    public SQLSetStatement parseAssign() {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    public MySqlSelectIntoStatement parseSelectInto() {
        MySqlSelectIntoParser parse = new MySqlSelectIntoParser(this.exprParser);
        return parse.parseSelectInto();
    }

    public SQLLoopStatement parseLoop() {
        SQLLoopStatement loopStmt = new SQLLoopStatement();
        this.accept(Token.LOOP);
        this.parseStatementList(loopStmt.getStatements(), -1, loopStmt);
        this.accept(Token.END);
        this.accept(Token.LOOP);
        this.accept(Token.SEMI);
        loopStmt.setAfterSemi(true);
        return loopStmt;
    }

    public SQLLoopStatement parseLoop(String label) {
        SQLLoopStatement loopStmt = new SQLLoopStatement();
        loopStmt.setLabelName(label);
        this.accept(Token.LOOP);
        this.parseStatementList(loopStmt.getStatements(), -1, loopStmt);
        this.accept(Token.END);
        this.accept(Token.LOOP);
        if (this.lexer.token() != Token.SEMI) {
            this.acceptIdentifier(label);
        }
        this.accept(Token.SEMI);
        loopStmt.setAfterSemi(true);
        return loopStmt;
    }

    public SQLBlockStatement parseBlock(String label) {
        SQLBlockStatement block = new SQLBlockStatement();
        block.setLabelName(label);
        this.accept(Token.BEGIN);
        this.parseStatementList(block.getStatementList(), -1, block);
        this.accept(Token.END);
        this.acceptIdentifier(label);
        return block;
    }

    @Override
    public MySqlLeaveStatement parseLeave() {
        this.accept(Token.LEAVE);
        MySqlLeaveStatement leaveStmt = new MySqlLeaveStatement();
        leaveStmt.setLabelName(this.exprParser.name().getSimpleName());
        this.accept(Token.SEMI);
        return leaveStmt;
    }

    public MySqlIterateStatement parseIterate() {
        this.accept(Token.ITERATE);
        MySqlIterateStatement iterateStmt = new MySqlIterateStatement();
        iterateStmt.setLabelName(this.exprParser.name().getSimpleName());
        this.accept(Token.SEMI);
        return iterateStmt;
    }

    @Override
    public MySqlRepeatStatement parseRepeat() {
        MySqlRepeatStatement stmt = new MySqlRepeatStatement();
        this.accept(Token.REPEAT);
        this.parseStatementList(stmt.getStatements(), -1, stmt);
        this.accept(Token.UNTIL);
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.END);
        this.accept(Token.REPEAT);
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public MySqlRepeatStatement parseRepeat(String label) {
        MySqlRepeatStatement repeatStmt = new MySqlRepeatStatement();
        repeatStmt.setLabelName(label);
        this.accept(Token.REPEAT);
        this.parseStatementList(repeatStmt.getStatements(), -1, repeatStmt);
        this.accept(Token.UNTIL);
        repeatStmt.setCondition(this.exprParser.expr());
        this.accept(Token.END);
        this.accept(Token.REPEAT);
        this.acceptIdentifier(label);
        this.accept(Token.SEMI);
        return repeatStmt;
    }

    public MySqlCursorDeclareStatement parseCursorDeclare() {
        MySqlCursorDeclareStatement stmt = new MySqlCursorDeclareStatement();
        this.accept(Token.DECLARE);
        stmt.setCursorName(this.exprParser.name());
        this.accept(Token.CURSOR);
        this.accept(Token.FOR);
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setSelect(select);
        this.accept(Token.SEMI);
        return stmt;
    }

    public SQLStatement parseSpStatement() {
        if (this.lexer.token() == Token.UPDATE) {
            return this.parseUpdateStatement();
        }
        if (this.lexer.token() == Token.CREATE) {
            return this.parseCreate();
        }
        if (this.lexer.token() == Token.INSERT) {
            return this.parseInsert();
        }
        if (this.lexer.token() == Token.DELETE) {
            return this.parseDeleteStatement();
        }
        if (this.lexer.token() == Token.BEGIN) {
            return this.parseBlock();
        }
        if (this.lexer.token() == Token.LPAREN) {
            char ch = this.lexer.current();
            int bp = this.lexer.bp();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                this.lexer.reset(bp, ch, Token.LPAREN);
                return this.parseSelect();
            }
            throw new ParserException("TODO. " + this.lexer.info());
        }
        if (this.lexer.token() == Token.SET) {
            return this.parseAssign();
        }
        throw new ParserException("error sp_statement. " + this.lexer.info());
    }

    public MySqlDeclareHandlerStatement parseDeclareHandler() {
        MySqlDeclareHandlerStatement stmt = new MySqlDeclareHandlerStatement();
        this.accept(Token.DECLARE);
        if (this.lexer.token() == Token.CONTINUE) {
            stmt.setHandleType(MySqlHandlerType.CONTINUE);
        } else if (this.lexer.token() == Token.EXIT) {
            stmt.setHandleType(MySqlHandlerType.CONTINUE);
        } else if (this.lexer.token() == Token.UNDO) {
            stmt.setHandleType(MySqlHandlerType.CONTINUE);
        } else {
            throw new ParserException("unkown handle type. " + this.lexer.info());
        }
        this.lexer.nextToken();
        this.acceptIdentifier("HANDLER");
        this.accept(Token.FOR);
        while (true) {
            String tokenName = this.lexer.stringVal();
            ConditionValue condition = new ConditionValue();
            if (tokenName.equalsIgnoreCase("NOT")) {
                this.lexer.nextToken();
                this.acceptIdentifier("FOUND");
                condition.setType(ConditionValue.ConditionType.SYSTEM);
                condition.setValue("NOT FOUND");
            } else if (tokenName.equalsIgnoreCase("SQLSTATE")) {
                condition.setType(ConditionValue.ConditionType.SQLSTATE);
                this.lexer.nextToken();
                condition.setValue(this.exprParser.name().toString());
            } else if (this.lexer.identifierEquals("SQLEXCEPTION")) {
                condition.setType(ConditionValue.ConditionType.SYSTEM);
                condition.setValue(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("SQLWARNING")) {
                condition.setType(ConditionValue.ConditionType.SYSTEM);
                condition.setValue(this.lexer.stringVal());
                this.lexer.nextToken();
            } else {
                if (this.lexer.token() == Token.LITERAL_INT) {
                    condition.setType(ConditionValue.ConditionType.MYSQL_ERROR_CODE);
                    condition.setValue(this.lexer.integerValue().toString());
                } else {
                    condition.setType(ConditionValue.ConditionType.SELF);
                    condition.setValue(tokenName);
                }
                this.lexer.nextToken();
            }
            stmt.getConditionValues().add(condition);
            if (this.lexer.token() != Token.COMMA) break;
            this.accept(Token.COMMA);
        }
        if (this.lexer.token() == Token.EOF) {
            throw new ParserException("declare handle not eof");
        }
        stmt.setSpStatement(this.parseSpStatement());
        if (!(stmt.getSpStatement() instanceof SQLBlockStatement)) {
            this.accept(Token.SEMI);
        }
        return stmt;
    }

    public MySqlDeclareConditionStatement parseDeclareCondition() {
        MySqlDeclareConditionStatement stmt = new MySqlDeclareConditionStatement();
        this.accept(Token.DECLARE);
        stmt.setConditionName(this.exprParser.name().toString());
        this.accept(Token.CONDITION);
        this.accept(Token.FOR);
        String tokenName = this.lexer.stringVal();
        ConditionValue condition = new ConditionValue();
        if (tokenName.equalsIgnoreCase("SQLSTATE")) {
            condition.setType(ConditionValue.ConditionType.SQLSTATE);
            this.lexer.nextToken();
            condition.setValue(this.exprParser.name().toString());
        } else if (this.lexer.token() == Token.LITERAL_INT) {
            condition.setType(ConditionValue.ConditionType.MYSQL_ERROR_CODE);
            condition.setValue(this.lexer.integerValue().toString());
            this.lexer.nextToken();
        } else {
            throw new ParserException("declare condition grammer error. " + this.lexer.info());
        }
        stmt.setConditionValue(condition);
        this.accept(Token.SEMI);
        return stmt;
    }
}

