/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLDDLParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class SQLCreateTableParser
extends SQLDDLParser {
    public SQLCreateTableParser(String sql) {
        super(sql);
    }

    public SQLCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public SQLCreateTableStatement parseCrateTable() {
        return this.parseCrateTable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLCreateTableStatement parseCrateTable(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateTableStatement createTable = this.newCreateStatement();
        if (this.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error");
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() != Token.LPAREN) return createTable;
        this.lexer.nextToken();
        do {
            SQLColumnDefinition column;
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS) {
                column = this.exprParser.parseColumn();
                createTable.getTableElementList().add(column);
            } else if (this.lexer.token == Token.PRIMARY || this.lexer.token == Token.UNIQUE || this.lexer.token == Token.CHECK || this.lexer.token == Token.CONSTRAINT) {
                SQLConstraint constraint = this.exprParser.parseConstaint();
                constraint.setParent(createTable);
                createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
            } else {
                if (this.lexer.token() == Token.TABLESPACE) {
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
                }
                column = this.exprParser.parseColumn();
                createTable.getTableElementList().add(column);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.RPAREN);
        this.accept(Token.RPAREN);
        return createTable;
    }

    protected SQLCreateTableStatement newCreateStatement() {
        return new SQLCreateTableStatement();
    }
}

