/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.datasource.converter;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class SentinelConverter<T>
implements Converter<String, Collection<Object>> {
    private static final Logger log = LoggerFactory.getLogger(SentinelConverter.class);
    private final ObjectMapper objectMapper;
    private final Class<T> ruleClass;

    public SentinelConverter(ObjectMapper objectMapper, Class<T> ruleClass) {
        this.objectMapper = objectMapper;
        this.ruleClass = ruleClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<Object> convert(String source) {
        AbstractCollection ruleCollection = this.ruleClass == FlowRule.class || this.ruleClass == DegradeRule.class || this.ruleClass == SystemRule.class || this.ruleClass == AuthorityRule.class || this.ruleClass == ParamFlowRule.class ? new ArrayList<Object>() : new HashSet();
        if (StringUtils.isEmpty((Object)source)) {
            log.warn("converter can not convert rules because source is empty");
            return ruleCollection;
        }
        try {
            List sourceArray = (List)this.objectMapper.readValue(source, (TypeReference)new TypeReference<List<HashMap>>(){});
            for (Object obj : sourceArray) {
                String item = null;
                try {
                    item = this.objectMapper.writeValueAsString(obj);
                    Optional.ofNullable(this.convertRule(item)).ifPresent(convertRule -> ruleCollection.add(convertRule));
                }
                catch (IOException e) {
                    log.error("sentinel rule convert error: " + e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("sentinel rule convert error: " + e.getMessage(), e);
                    return ruleCollection;
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException("convert error: " + e.getMessage(), e);
            throw (RuntimeException)e;
        }
    }

    private Object convertRule(String ruleStr) throws IOException {
        return this.objectMapper.readValue(ruleStr, this.ruleClass);
    }
}

