/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.push.model.PushModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SMS
implements PushModel {
    private final String content;
    private final int delay_time;

    private SMS(String content, int delay_time) {
        this.content = content;
        this.delay_time = delay_time;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static SMS content(String content, int delayTime) {
        return new Builder().setContent(content).setDelayTime(delayTime).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("content", this.content);
        json.addProperty("delay_time", (Number)this.delay_time);
        return json;
    }

    public static class Builder {
        private String content;
        private int delay_time;

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setDelayTime(int delayTime) {
            this.delay_time = delayTime;
            return this;
        }

        public SMS build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.content), (Object)"The content must not be empty.");
            Preconditions.checkArgument((this.delay_time >= 0 ? 1 : 0) != 0, (Object)"The delay time must be greater than or equal to 0");
            return new SMS(this.content, this.delay_time);
        }
    }
}

