/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetDetector {
    private static final Charset[] DEFAULT_CHARSETS;

    public static Charset detect(File file, Charset ... charsets) {
        return CharsetDetector.detect(FileUtil.getInputStream(file), charsets);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(InputStream in, Charset ... charsets) {
        if (ArrayUtil.isEmpty(charsets)) {
            charsets = DEFAULT_CHARSETS;
        }
        byte[] buffer = new byte[512];
        try {
            block6: while (true) {
                if (in.read(buffer) <= -1) return null;
                Charset[] charsetArray = charsets;
                int n = charsetArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block6;
                    Charset charset = charsetArray[n2];
                    CharsetDecoder decoder = charset.newDecoder();
                    if (CharsetDetector.identify(buffer, decoder)) {
                        Charset charset2 = charset;
                        return charset2;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    private static Charset detectCharset(InputStream in, Charset charset) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        byte[] buffer = new byte[512];
        while (in.read(buffer) > -1) {
            if (!CharsetDetector.identify(buffer, decoder)) continue;
            return charset;
        }
        return null;
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    static {
        String[] names = new String[]{"UTF-8", "GBK", "GB2312", "GB18030", "UTF-16BE", "UTF-16LE", "UTF-16", "BIG5", "UNICODE", "US-ASCII"};
        DEFAULT_CHARSETS = Convert.convert(Charset[].class, (Object)names);
    }
}

