/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean.copier;

import cn.hutool.core.bean.BeanException;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.DynaBean;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.bean.copier.provider.BeanValueProvider;
import cn.hutool.core.bean.copier.provider.DynaBeanValueProvider;
import cn.hutool.core.bean.copier.provider.MapValueProvider;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.copier.Copier;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;

public class BeanCopier<T>
implements Copier<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object source;
    private final T dest;
    private final Type destType;
    private final CopyOptions copyOptions;

    public static <T> BeanCopier<T> create(Object source, T dest, CopyOptions copyOptions) {
        return BeanCopier.create(source, dest, dest.getClass(), copyOptions);
    }

    public static <T> BeanCopier<T> create(Object source, T dest, Type destType, CopyOptions copyOptions) {
        return new BeanCopier<T>(source, dest, destType, copyOptions);
    }

    public BeanCopier(Object source, T dest, Type destType, CopyOptions copyOptions) {
        this.source = source;
        this.dest = dest;
        this.destType = destType;
        this.copyOptions = copyOptions;
    }

    @Override
    public T copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof DynaBean) {
                this.valueProviderToBean(new DynaBeanValueProvider((DynaBean)this.source, this.copyOptions.ignoreError), this.dest);
            } else if (this.source instanceof Map) {
                if (this.dest instanceof Map) {
                    this.mapToMap((Map)this.source, (Map)this.dest);
                } else {
                    this.mapToBean((Map)this.source, this.dest);
                }
            } else if (this.dest instanceof Map) {
                this.beanToMap(this.source, (Map)this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object providerBean, Object destBean) {
        this.valueProviderToBean(new BeanValueProvider(providerBean, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), destBean);
    }

    private void mapToBean(Map<?, ?> map, Object bean) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), bean);
    }

    private void mapToMap(Map source, Map dest) {
        if (null != dest && null != source) {
            dest.putAll(source);
        }
    }

    private void beanToMap(Object bean, Map targetMap) {
        HashSet<String> ignoreSet = null != this.copyOptions.ignoreProperties ? CollUtil.newHashSet(this.copyOptions.ignoreProperties) : null;
        CopyOptions copyOptions = this.copyOptions;
        BeanUtil.descForEach(bean.getClass(), prop -> {
            Object value;
            if (!prop.isReadable(copyOptions.isTransientSupport())) {
                return;
            }
            String key = prop.getFieldName();
            if (CollUtil.contains(ignoreSet, key)) {
                return;
            }
            if (null == (key = copyOptions.editFieldName(copyOptions.getMappedFieldName(key, false)))) {
                return;
            }
            try {
                value = prop.getValue(bean);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) {
                    return;
                }
                throw new BeanException(e, "Get value of [{}] error!", prop.getFieldName());
            }
            if (null != copyOptions.propertiesFilter && !copyOptions.propertiesFilter.test(prop.getField(), value)) {
                return;
            }
            if (null == value && copyOptions.ignoreNullValue || bean == value) {
                return;
            }
            targetMap.put(key, value);
        });
    }

    private void valueProviderToBean(ValueProvider<String> valueProvider, Object bean) {
        if (null == valueProvider) {
            return;
        }
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = bean.getClass();
        if (null != copyOptions.editable) {
            if (!copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StrUtil.format("Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        HashSet<String> ignoreSet = null != copyOptions.ignoreProperties ? CollUtil.newHashSet(copyOptions.ignoreProperties) : null;
        BeanUtil.descForEach(actualEditable, prop -> {
            if (!prop.isWritable(this.copyOptions.isTransientSupport())) {
                return;
            }
            String fieldName = prop.getFieldName();
            if (CollUtil.contains(ignoreSet, fieldName)) {
                return;
            }
            String providerKey = copyOptions.editFieldName(copyOptions.getMappedFieldName(fieldName, true));
            if (null == providerKey) {
                return;
            }
            if (!valueProvider.containsKey(providerKey)) {
                return;
            }
            Type fieldType = TypeUtil.getActualType(this.destType, prop.getFieldType());
            Object value = valueProvider.value(providerKey, fieldType);
            if (null != copyOptions.propertiesFilter && !copyOptions.propertiesFilter.test(prop.getField(), value)) {
                return;
            }
            if (null == value && copyOptions.ignoreNullValue || bean == value) {
                return;
            }
            prop.setValue(bean, value, copyOptions.ignoreNullValue, copyOptions.ignoreError);
        });
    }
}

