/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.lang.VoidFunc;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.AbstractSqlRunner;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.sql.Wrapper;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;

public class Session
extends AbstractSqlRunner
implements Closeable {
    private static final Log log = LogFactory.get();
    private Connection conn = null;
    private Boolean isSupportTransaction = null;

    public static Session create() {
        return new Session(DSFactory.get());
    }

    public static Session create(String group) {
        return new Session(DSFactory.get(group));
    }

    public static Session create(DataSource ds) {
        return new Session(ds);
    }

    public static Session create(Connection conn) {
        return new Session(conn);
    }

    public Session(DataSource ds) {
        try {
            this.conn = ds.getConnection();
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Get connection error!", e);
        }
        this.runner = new SqlConnRunner(DialectFactory.newDialect(this.conn));
    }

    public Session(Connection conn) {
        this.conn = conn;
        this.runner = new SqlConnRunner(DialectFactory.newDialect(conn));
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    @Override
    public SqlConnRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }

    public boolean isSupportTransaction() throws DbRuntimeException {
        if (null == this.isSupportTransaction) {
            try {
                this.isSupportTransaction = this.conn.getMetaData().supportsTransactions();
            }
            catch (SQLException e) {
                throw new DbRuntimeException(e, "Because of SQLException [{}], We can not know transation support or not.", e.getMessage());
            }
        }
        return this.isSupportTransaction;
    }

    public void beginTransaction() throws SQLException {
        if (null == this.isSupportTransaction) {
            this.isSupportTransaction = this.conn.getMetaData().supportsTransactions();
        }
        if (!this.isSupportTransaction.booleanValue()) {
            throw new SQLException("Transaction not supported for current database!");
        }
        this.conn.setAutoCommit(false);
    }

    public void commit() throws SQLException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void rollback() throws SQLException {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quietRollback() {
        try {
            this.conn.rollback();
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quietRollback(Savepoint savepoint) throws SQLException {
        try {
            this.conn.rollback(savepoint);
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (!this.conn.getMetaData().supportsTransactionIsolationLevel(level)) {
            throw new SQLException(StrUtil.format((CharSequence)"Transaction isolation [{}] not support!", level));
        }
        this.conn.setTransactionIsolation(level);
    }

    public void trans(VoidFunc func) {
        try {
            this.beginTransaction();
            func.call();
            this.commit();
        }
        catch (Exception e) {
            this.quietRollback();
            throw new DbRuntimeException(e);
        }
    }

    @Override
    public Session setWrapper(Character wrapperChar) {
        return (Session)super.setWrapper(wrapperChar);
    }

    @Override
    public Session setWrapper(Wrapper wrapper) {
        return (Session)super.setWrapper(wrapper);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void closeConnection(Connection conn) {
    }

    @Override
    public void close() {
        DbUtil.close(this.conn);
    }
}

