/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.BaseAsymmetric;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class AsymmetricCrypto
extends BaseAsymmetric<AsymmetricCrypto> {
    protected Cipher clipher;

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm.getValue(), Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        super(algorithm, privateKeyBase64, publicKeyBase64);
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    @Override
    public AsymmetricCrypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.clipher = Cipher.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public byte[] encrypt(byte[] data, KeyType keyType) {
        this.lock.lock();
        try {
            this.clipher.init(1, this.getKeyByType(keyType));
            byte[] byArray = this.clipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data), keyType);
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        this.lock.lock();
        try {
            this.clipher.init(2, this.getKeyByType(keyType));
            byte[] byArray = this.clipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data), keyType);
    }

    public byte[] decryptFromHex(String hexStr, KeyType keyType) {
        return this.decrypt(HexUtil.decodeHex(hexStr), keyType);
    }

    public byte[] decryptFromBase64(String base64Str, KeyType keyType) {
        return this.decrypt(Base64.decode(base64Str, CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public Cipher getClipher() {
        return this.clipher;
    }
}

