/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.export.template;

import cn.afterturn.easypoi.cache.ExcelCache;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.params.ExcelForEachParams;
import cn.afterturn.easypoi.excel.export.base.ExcelExportBase;
import cn.afterturn.easypoi.excel.export.styler.IExcelExportStyler;
import cn.afterturn.easypoi.excel.export.template.TemplateSumHanlder;
import cn.afterturn.easypoi.excel.html.helper.MergedRegionHelper;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiSheetUtility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelExportOfTemplateUtil
extends ExcelExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportOfTemplateUtil.class);
    private Set<String> tempCreateCellSet = new HashSet<String>();
    private TemplateExportParams teplateParams;
    private MergedRegionHelper mergedRegionHelper;
    private TemplateSumHanlder templateSumHanlder;

    private void addDataToSheet(Class<?> pojoClass, Collection<?> dataSet, Sheet sheet, Workbook workbook) throws Exception {
        int index;
        if (workbook instanceof XSSFWorkbook) {
            this.type = ExcelType.XSSF;
        }
        Map<String, Integer> titlemap = this.getTitleMap(sheet);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.value();
        }
        ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
        this.getAllExcelField(null, targetId, fileds, excelParams, pojoClass, null);
        this.sortAndFilterExportField(excelParams, titlemap);
        short rowHeight = this.getRowHeight(excelParams);
        int titleHeight = index = this.teplateParams.getHeadingRows() + this.teplateParams.getHeadingStartRow();
        sheet.shiftRows(this.teplateParams.getHeadingRows() + this.teplateParams.getHeadingStartRow(), sheet.getLastRowNum(), this.getShiftRows(dataSet, excelParams), true, true);
        if (excelParams.size() == 0) {
            return;
        }
        for (Object t : dataSet) {
            index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
        }
        this.mergeCells(sheet, excelParams, titleHeight);
    }

    private int getShiftRows(Collection<?> dataSet, List<ExcelExportEntity> excelParams) throws Exception {
        int size = 0;
        for (Object t : dataSet) {
            size += this.getOneObjectSize(t, excelParams);
        }
        return size;
    }

    public int getOneObjectSize(Object t, List<ExcelExportEntity> excelParams) throws Exception {
        int maxHeight = 1;
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            Collection list;
            ExcelExportEntity entity = excelParams.get(k);
            if (entity.getList() == null || (list = (Collection)entity.getMethod().invoke(t, new Object[0])) == null || list.size() <= maxHeight) continue;
            maxHeight = list.size();
        }
        return maxHeight;
    }

    public Workbook createExcleByTemplate(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            int le;
            this.teplateParams = params;
            wb = this.getCloneWorkBook();
            this.setExcelExportStyler((IExcelExportStyler)this.teplateParams.getStyle().getConstructor(Workbook.class).newInstance(wb));
            int n = le = params.isScanAllsheet() ? wb.getNumberOfSheets() : params.getSheetNum().length;
            for (int i = 0; i < le; ++i) {
                if (params.getSheetName() != null && params.getSheetName().length > i && StringUtils.isNotEmpty((CharSequence)params.getSheetName()[i])) {
                    wb.setSheetName(i, params.getSheetName()[i]);
                }
                this.tempCreateCellSet.clear();
                this.parseTemplate(wb.getSheetAt(i), map, params.isColForEach());
            }
            if (dataSet != null) {
                this.dataHanlder = params.getDataHanlder();
                if (this.dataHanlder != null) {
                    this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
                }
                this.addDataToSheet(pojoClass, dataSet, wb.getSheetAt(params.getDataSheetNum()), wb);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }

    private Workbook getCloneWorkBook() throws Exception {
        return ExcelCache.getWorkbook(this.teplateParams.getTemplateUrl(), this.teplateParams.getSheetNum(), this.teplateParams.isScanAllsheet());
    }

    private Map<String, Integer> getTitleMap(Sheet sheet) {
        Row row = null;
        HashMap<String, Integer> titlemap = new HashMap<String, Integer>();
        for (int j = 0; j < this.teplateParams.getHeadingRows(); ++j) {
            row = sheet.getRow(j + this.teplateParams.getHeadingStartRow());
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    titlemap.put(value, i);
                }
                ++i;
            }
        }
        return titlemap;
    }

    private void parseTemplate(Sheet sheet, Map<String, Object> map, boolean colForeach) throws Exception {
        this.deleteCell(sheet, map);
        this.mergedRegionHelper = new MergedRegionHelper(sheet);
        this.templateSumHanlder = new TemplateSumHanlder(sheet);
        if (colForeach) {
            this.colForeach(sheet, map);
        }
        Row row = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                if (row.getCell(i) == null || this.tempCreateCellSet.contains(row.getRowNum() + "_" + row.getCell(i).getColumnIndex())) continue;
                this.setValueForCellByMap(row.getCell(i), map);
            }
        }
        this.hanlderSumCell(sheet);
    }

    private void hanlderSumCell(Sheet sheet) {
        for (TemplateSumHanlder.TemplateSumEntity sumEntity : this.templateSumHanlder.getDataList()) {
            Cell cell = sheet.getRow(sumEntity.getRow()).getCell(sumEntity.getCol());
            cell.setCellValue(cell.getStringCellValue().replace("sum:(" + sumEntity.getSumKey() + ")", sumEntity.getValue() + ""));
        }
    }

    private void colForeach(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellType() != 1 && cell.getCellType() != 0) continue;
                cell.setCellType(1);
                String text = cell.getStringCellValue();
                if (!text.contains("#fe:") && !text.contains("v_fe:")) continue;
                this.foreachCol(cell, map, text);
            }
        }
    }

    private void foreachCol(Cell cell, Map<String, Object> map, String name) throws Exception {
        boolean isCreate = name.contains("v_fe:");
        name = name.replace("v_fe:", "").replace("#fe:", "").replace("{{", "");
        String[] keys = name.replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        Object[] columnsInfo = this.getAllDataColumns(cell, name.replace(keys[0], ""), this.mergedRegionHelper);
        if (datas == null) {
            return;
        }
        Iterator its = datas.iterator();
        int rowspan = (Integer)columnsInfo[0];
        int colspan = (Integer)columnsInfo[1];
        List columns = (List)columnsInfo[2];
        while (its.hasNext()) {
            Object t = its.next();
            this.setForEeachRowCellValue(true, cell.getRow(), cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper);
            cell = cell.getRow().getCell(cell.getColumnIndex() + colspan);
        }
        if (isCreate) {
            cell = cell.getRow().getCell(cell.getColumnIndex() - 1);
            cell.setCellValue(cell.getStringCellValue() + "}}");
        }
    }

    private void deleteCell(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellType() != 1 && cell.getCellType() != 0) continue;
                cell.setCellType(1);
                String text = cell.getStringCellValue();
                if (!text.contains("!if:")) continue;
                if (Boolean.valueOf(PoiElUtil.eval(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")).trim(), map).toString()).booleanValue()) {
                    PoiSheetUtility.deleteColumn(sheet, i);
                }
                cell.setCellValue("");
            }
        }
    }

    private void setValueForCellByMap(Cell cell, Map<String, Object> map) throws Exception {
        int cellType = cell.getCellType();
        if (cellType != 1 && cellType != 0) {
            return;
        }
        cell.setCellType(1);
        String oldString = cell.getStringCellValue();
        if (oldString != null && oldString.indexOf("{{") != -1 && !oldString.contains("fe:")) {
            String params = null;
            boolean isNumber = false;
            if (this.isNumber(oldString)) {
                isNumber = true;
                oldString = oldString.replaceFirst("n:", "");
            }
            while (oldString.indexOf("{{") != -1) {
                params = oldString.substring(oldString.indexOf("{{") + 2, oldString.indexOf("}}"));
                oldString = oldString.replace("{{" + params + "}}", PoiElUtil.eval(params, map).toString());
            }
            if (isNumber && StringUtils.isNotBlank((CharSequence)oldString)) {
                cell.setCellValue(Double.parseDouble(oldString));
                cell.setCellType(0);
            } else {
                cell.setCellValue(oldString);
            }
        }
        if (oldString != null && oldString.contains("fe:")) {
            this.addListDataToExcel(cell, map, oldString.trim());
        }
    }

    private boolean isNumber(String text) {
        return text.startsWith("n:") || text.contains("{n:") || text.contains(" n:");
    }

    private void addListDataToExcel(Cell cell, Map<String, Object> map, String name) throws Exception {
        Object t;
        boolean isCreate = !name.contains("!fe:");
        boolean isShift = name.contains("$fe:");
        name = name.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "");
        String[] keys = name.replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        Object[] columnsInfo = this.getAllDataColumns(cell, name.replace(keys[0], ""), this.mergedRegionHelper);
        if (datas == null) {
            return;
        }
        Iterator its = datas.iterator();
        int rowspan = (Integer)columnsInfo[0];
        int colspan = (Integer)columnsInfo[1];
        List columns = (List)columnsInfo[2];
        Row row = null;
        int rowIndex = cell.getRow().getRowNum() + 1;
        if (its.hasNext()) {
            t = its.next();
            this.setForEeachRowCellValue(isCreate, cell.getRow(), cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper);
            rowIndex += rowspan - 1;
        }
        if (isShift && datas.size() * rowspan > 1 && cell.getRowIndex() + rowspan < cell.getRow().getSheet().getLastRowNum()) {
            this.createRowNoRow(cell.getRowIndex() + rowspan, cell.getRow().getSheet().getLastRowNum(), (datas.size() - 1) * rowspan);
            cell.getRow().getSheet().shiftRows(cell.getRowIndex() + rowspan, cell.getRow().getSheet().getLastRowNum(), (datas.size() - 1) * rowspan, true, true);
            this.templateSumHanlder.shiftRows(cell.getRowIndex(), (datas.size() - 1) * rowspan);
        }
        while (its.hasNext()) {
            t = its.next();
            row = this.createRow(rowIndex, cell.getSheet(), isCreate, rowspan);
            this.setForEeachRowCellValue(isCreate, row, cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper);
            rowIndex += rowspan;
        }
    }

    private void createRowNoRow(int startRow, int lastRowNum, int i1) {
    }

    private Row createRow(int rowIndex, Sheet sheet, boolean isCreate, int rows) {
        for (int i = 0; i < rows; ++i) {
            if (isCreate) {
                sheet.createRow(rowIndex++);
                continue;
            }
            if (sheet.getRow(rowIndex++) != null) continue;
            sheet.createRow(rowIndex - 1);
        }
        return sheet.getRow(rowIndex - rows);
    }

    private void setForEeachRowCellValue(boolean isCreate, Row row, int columnIndex, Object t, List<ExcelForEachParams> columns, Map<String, Object> map, int rowspan, int colspan, MergedRegionHelper mergedRegionHelper) throws Exception {
        for (int i = 0; i < rowspan; ++i) {
            int size = columns.size();
            int max = columnIndex + colspan;
            for (int j = columnIndex; j < max; ++j) {
                CellStyle style;
                if (row.getCell(j) != null) continue;
                row.createCell(j);
                CellStyle cellStyle = row.getRowNum() % 2 == 0 ? this.getStyles(false, size >= j - columnIndex ? null : columns.get(j - columnIndex)) : (style = this.getStyles(true, size >= j - columnIndex ? null : columns.get(j - columnIndex)));
                if (style == null) continue;
                row.getCell(j).setCellStyle(style);
            }
            if (i >= rowspan - 1) continue;
            row = row.getSheet().getRow(row.getRowNum() + 1);
        }
        row = row.getSheet().getRow(row.getRowNum() - rowspan + 1);
        for (int k = 0; k < rowspan; ++k) {
            int ci = columnIndex;
            row.setHeight(columns.get(0 * colspan).getHeight());
            for (int i = 0; i < colspan && i < columns.size(); ++i) {
                boolean isNumber = false;
                ExcelForEachParams params = columns.get(colspan * k + i);
                this.tempCreateCellSet.add(row.getRowNum() + "_" + ci);
                if (params == null) continue;
                if (StringUtils.isEmpty((CharSequence)params.getName()) && StringUtils.isEmpty((CharSequence)params.getConstValue())) {
                    row.getCell(ci).setCellStyle(columns.get(i).getCellStyle());
                    ci += columns.get(i).getColspan();
                    continue;
                }
                String val = null;
                if (StringUtils.isEmpty((CharSequence)params.getName())) {
                    val = params.getConstValue();
                } else {
                    String tempStr = new String(params.getName());
                    if (this.isNumber(tempStr)) {
                        isNumber = true;
                        tempStr = tempStr.replaceFirst("n:", "");
                    }
                    map.put(this.teplateParams.getTempParams(), t);
                    val = PoiElUtil.eval(tempStr, map).toString();
                }
                if (isNumber && StringUtils.isNotEmpty((CharSequence)val)) {
                    row.getCell(ci).setCellValue(Double.parseDouble(val));
                    row.getCell(ci).setCellType(0);
                } else {
                    try {
                        row.getCell(ci).setCellValue(val);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
                row.getCell(ci).setCellStyle(columns.get(i).getCellStyle());
                if (params.isNeedSum()) {
                    this.templateSumHanlder.addValueOfKey(params.getName(), val);
                }
                this.setMergedRegionStyle(row, ci, columns.get(i));
                if (!(params.getRowspan() == 1 && params.getColspan() == 1 || mergedRegionHelper.isMergedRegion(row.getRowNum() + 1, ci))) {
                    row.getSheet().addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + params.getRowspan() - 1, ci, ci + params.getColspan() - 1));
                }
                ci += params.getColspan();
            }
            row = row.getSheet().getRow(row.getRowNum() + 1);
        }
    }

    private CellStyle getStyles(boolean isSingle, ExcelForEachParams excelForEachParams) {
        return this.excelExportStyler.getTemplateStyles(isSingle, excelForEachParams);
    }

    private void setMergedRegionStyle(Row row, int ci, ExcelForEachParams params) {
        int i;
        for (i = 1; i < params.getColspan(); ++i) {
            row.getCell(ci + i).setCellStyle(params.getCellStyle());
        }
        for (i = 1; i < params.getRowspan(); ++i) {
            for (int j = 0; j < params.getColspan(); ++j) {
                row.getCell(ci + j).setCellStyle(params.getCellStyle());
            }
        }
    }

    private Object[] getAllDataColumns(Cell cell, String name, MergedRegionHelper mergedRegionHelper) {
        ArrayList<ExcelForEachParams> columns = new ArrayList<ExcelForEachParams>();
        cell.setCellValue("");
        columns.add(this.getExcelTemplateParams(name.replace("}}", ""), cell, mergedRegionHelper));
        int rowspan = 1;
        int colspan = 1;
        if (!name.contains("}}")) {
            int index = cell.getColumnIndex();
            int startIndex = cell.getColumnIndex();
            Row row = cell.getRow();
            while (true) {
                String cellStringString;
                int colSpan = columns.get(columns.size() - 1) != null ? ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan() : 1;
                index += colSpan;
                for (int i = 1; i < colSpan; ++i) {
                    columns.add(null);
                }
                cell = row.getCell(index);
                if (cell == null) {
                    columns.add(null);
                    continue;
                }
                try {
                    cellStringString = cell.getStringCellValue();
                    if (StringUtils.isBlank((CharSequence)cellStringString) && colspan + startIndex <= index) {
                        throw new ExcelExportException("for each \u5f53\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32,\u8bf7\u68c0\u67e5\u6a21\u677f");
                    }
                    if (StringUtils.isBlank((CharSequence)cellStringString) && colspan + startIndex > index) {
                        columns.add(new ExcelForEachParams(null, cell.getCellStyle(), 0));
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new ExcelExportException(ExcelExportEnum.TEMPLATE_ERROR, (Throwable)e);
                }
                cell.setCellValue("");
                if (cellStringString.contains("}}")) {
                    columns.add(this.getExcelTemplateParams(cellStringString.replace("}}", ""), cell, mergedRegionHelper));
                    break;
                }
                if (cellStringString.contains("]]")) {
                    columns.add(this.getExcelTemplateParams(cellStringString.replace("]]", ""), cell, mergedRegionHelper));
                    colspan = index - startIndex + 1;
                    index = startIndex - 1;
                    row = row.getSheet().getRow(row.getRowNum() + 1);
                    ++rowspan;
                    continue;
                }
                columns.add(this.getExcelTemplateParams(cellStringString.replace("]]", ""), cell, mergedRegionHelper));
            }
        }
        colspan = 0;
        for (int i = 0; i < columns.size(); ++i) {
            colspan += columns.get(i) != null ? ((ExcelForEachParams)columns.get(i)).getColspan() : 0;
        }
        return new Object[]{rowspan, colspan /= rowspan, columns};
    }

    private ExcelForEachParams getExcelTemplateParams(String name, Cell cell, MergedRegionHelper mergedRegionHelper) {
        name = name.trim();
        ExcelForEachParams params = new ExcelForEachParams(name, cell.getCellStyle(), cell.getRow().getHeight());
        if (name.startsWith("'") && name.endsWith("'")) {
            params.setName(null);
            params.setConstValue(name.substring(1, name.length() - 1));
        }
        if ("&NULL&".equals(name)) {
            params.setName(null);
            params.setConstValue("");
        }
        if (mergedRegionHelper.isMergedRegion(cell.getRowIndex() + 1, cell.getColumnIndex())) {
            Integer[] colAndrow = mergedRegionHelper.getRowAndColSpan(cell.getRowIndex() + 1, cell.getColumnIndex());
            params.setRowspan(colAndrow[0]);
            params.setColspan(colAndrow[1]);
        }
        params.setNeedSum(this.templateSumHanlder.isSumKey(params.getName()));
        return params;
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        for (int i = excelParams.size() - 1; i >= 0; --i) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                    continue;
                }
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            excelParams.remove(i);
        }
        this.sortAllParams(excelParams);
    }

    public Workbook createExcleByTemplate(TemplateExportParams params, Map<Integer, Map<String, Object>> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            int le;
            this.teplateParams = params;
            wb = this.getCloneWorkBook();
            int n = le = params.isScanAllsheet() ? wb.getNumberOfSheets() : params.getSheetNum().length;
            for (int i = 0; i < le; ++i) {
                if (params.getSheetName() != null && params.getSheetName().length > i && StringUtils.isNotEmpty((CharSequence)params.getSheetName()[i])) {
                    wb.setSheetName(i, params.getSheetName()[i]);
                }
                this.tempCreateCellSet.clear();
                this.parseTemplate(wb.getSheetAt(i), map.get(i), params.isColForEach());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }
}

