/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class ServiceHealth {
    @JsonProperty(value="Node")
    private Node node;
    @JsonProperty(value="Service")
    private Service service;
    @JsonProperty(value="Checks")
    private List<Check> checks;

    ServiceHealth(Node node, Service service, List<Check> checks) {
        this.node = node;
        this.service = service;
        this.checks = checks;
    }

    public static ServiceHealthBuilder builder() {
        return new ServiceHealthBuilder();
    }

    public Node getNode() {
        return this.node;
    }

    public Service getService() {
        return this.service;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public static class ServiceHealthBuilder {
        private Node node;
        private Service service;
        private List<Check> checks;

        ServiceHealthBuilder() {
        }

        public ServiceHealthBuilder node(Node node) {
            this.node = node;
            return this;
        }

        public ServiceHealthBuilder service(Service service) {
            this.service = service;
            return this;
        }

        public ServiceHealthBuilder checks(List<Check> checks) {
            this.checks = checks;
            return this;
        }

        public ServiceHealth build() {
            return new ServiceHealth(this.node, this.service, this.checks);
        }

        public String toString() {
            return "ServiceHealth.ServiceHealthBuilder(node=" + this.node + ", service=" + this.service + ", checks=" + this.checks + ")";
        }
    }

    public static class Check {
        @JsonProperty(value="Node")
        private String node;
        @JsonProperty(value="CheckID")
        private String checkID;
        @JsonProperty(value="Name")
        private String name;
        @JsonProperty(value="Status")
        private String status;

        Check(String node, String checkID, String name, String status) {
            this.node = node;
            this.checkID = checkID;
            this.name = name;
            this.status = status;
        }

        public static CheckBuilder builder() {
            return new CheckBuilder();
        }

        public String getNode() {
            return this.node;
        }

        public String getCheckID() {
            return this.checkID;
        }

        public String getName() {
            return this.name;
        }

        public String getStatus() {
            return this.status;
        }

        public static class CheckBuilder {
            private String node;
            private String checkID;
            private String name;
            private String status;

            CheckBuilder() {
            }

            public CheckBuilder node(String node) {
                this.node = node;
                return this;
            }

            public CheckBuilder checkID(String checkID) {
                this.checkID = checkID;
                return this;
            }

            public CheckBuilder name(String name) {
                this.name = name;
                return this;
            }

            public CheckBuilder status(String status) {
                this.status = status;
                return this;
            }

            public Check build() {
                return new Check(this.node, this.checkID, this.name, this.status);
            }

            public String toString() {
                return "ServiceHealth.Check.CheckBuilder(node=" + this.node + ", checkID=" + this.checkID + ", name=" + this.name + ", status=" + this.status + ")";
            }
        }
    }

    public static class Service {
        @JsonProperty(value="ID")
        private String id;
        @JsonProperty(value="Service")
        private String name;
        @JsonProperty(value="Tags")
        private List<String> tags;
        @JsonProperty(value="Address")
        private String address;
        @JsonProperty(value="Meta")
        private Map<String, String> meta;
        @JsonProperty(value="Port")
        private int port;

        Service(String id, String name, List<String> tags, String address, Map<String, String> meta, int port) {
            this.id = id;
            this.name = name;
            this.tags = tags;
            this.address = address;
            this.meta = meta;
            this.port = port;
        }

        public static ServiceBuilder builder() {
            return new ServiceBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String getAddress() {
            return this.address;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public int getPort() {
            return this.port;
        }

        public static class ServiceBuilder {
            private String id;
            private String name;
            private List<String> tags;
            private String address;
            private Map<String, String> meta;
            private int port;

            ServiceBuilder() {
            }

            public ServiceBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ServiceBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ServiceBuilder tags(List<String> tags) {
                this.tags = tags;
                return this;
            }

            public ServiceBuilder address(String address) {
                this.address = address;
                return this;
            }

            public ServiceBuilder meta(Map<String, String> meta) {
                this.meta = meta;
                return this;
            }

            public ServiceBuilder port(int port) {
                this.port = port;
                return this;
            }

            public Service build() {
                return new Service(this.id, this.name, this.tags, this.address, this.meta, this.port);
            }

            public String toString() {
                return "ServiceHealth.Service.ServiceBuilder(id=" + this.id + ", name=" + this.name + ", tags=" + this.tags + ", address=" + this.address + ", meta=" + this.meta + ", port=" + this.port + ")";
            }
        }
    }

    public static class Node {
        @JsonProperty(value="Node")
        private String name;
        @JsonProperty(value="Address")
        private String address;
        @JsonProperty(value="Meta")
        private Map<String, String> meta;

        Node(String name, String address, Map<String, String> meta) {
            this.name = name;
            this.address = address;
            this.meta = meta;
        }

        public static NodeBuilder builder() {
            return new NodeBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public static class NodeBuilder {
            private String name;
            private String address;
            private Map<String, String> meta;

            NodeBuilder() {
            }

            public NodeBuilder name(String name) {
                this.name = name;
                return this;
            }

            public NodeBuilder address(String address) {
                this.address = address;
                return this;
            }

            public NodeBuilder meta(Map<String, String> meta) {
                this.meta = meta;
                return this;
            }

            public Node build() {
                return new Node(this.name, this.address, this.meta);
            }

            public String toString() {
                return "ServiceHealth.Node.NodeBuilder(name=" + this.name + ", address=" + this.address + ", meta=" + this.meta + ")";
            }
        }
    }
}

