/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class Service {
    @JsonProperty(value="Address")
    private String address;
    @JsonProperty(value="Node")
    private String node;
    @JsonProperty(value="ServiceAddress")
    private String serviceAddress;
    @JsonProperty(value="ServiceName")
    private String serviceName;
    @JsonProperty(value="ServiceID")
    private String serviceID;
    @JsonProperty(value="ServicePort")
    private int servicePort;
    @JsonProperty(value="NodeMeta")
    private Map<String, String> nodeMeta;
    @JsonProperty(value="ServiceMeta")
    private Map<String, String> serviceMeta;
    @JsonProperty(value="ServiceTags")
    private List<String> serviceTags;

    Service(String address, String node, String serviceAddress, String serviceName, String serviceID, int servicePort, Map<String, String> nodeMeta, Map<String, String> serviceMeta, List<String> serviceTags) {
        this.address = address;
        this.node = node;
        this.serviceAddress = serviceAddress;
        this.serviceName = serviceName;
        this.serviceID = serviceID;
        this.servicePort = servicePort;
        this.nodeMeta = nodeMeta;
        this.serviceMeta = serviceMeta;
        this.serviceTags = serviceTags;
    }

    public static ServiceBuilder builder() {
        return new ServiceBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    public String getNode() {
        return this.node;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public Map<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    public Map<String, String> getServiceMeta() {
        return this.serviceMeta;
    }

    public List<String> getServiceTags() {
        return this.serviceTags;
    }

    public static class ServiceBuilder {
        private String address;
        private String node;
        private String serviceAddress;
        private String serviceName;
        private String serviceID;
        private int servicePort;
        private Map<String, String> nodeMeta;
        private Map<String, String> serviceMeta;
        private List<String> serviceTags;

        ServiceBuilder() {
        }

        public ServiceBuilder address(String address) {
            this.address = address;
            return this;
        }

        public ServiceBuilder node(String node) {
            this.node = node;
            return this;
        }

        public ServiceBuilder serviceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
            return this;
        }

        public ServiceBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceBuilder serviceID(String serviceID) {
            this.serviceID = serviceID;
            return this;
        }

        public ServiceBuilder servicePort(int servicePort) {
            this.servicePort = servicePort;
            return this;
        }

        public ServiceBuilder nodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = nodeMeta;
            return this;
        }

        public ServiceBuilder serviceMeta(Map<String, String> serviceMeta) {
            this.serviceMeta = serviceMeta;
            return this;
        }

        public ServiceBuilder serviceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
            return this;
        }

        public Service build() {
            return new Service(this.address, this.node, this.serviceAddress, this.serviceName, this.serviceID, this.servicePort, this.nodeMeta, this.serviceMeta, this.serviceTags);
        }

        public String toString() {
            return "Service.ServiceBuilder(address=" + this.address + ", node=" + this.node + ", serviceAddress=" + this.serviceAddress + ", serviceName=" + this.serviceName + ", serviceID=" + this.serviceID + ", servicePort=" + this.servicePort + ", nodeMeta=" + this.nodeMeta + ", serviceMeta=" + this.serviceMeta + ", serviceTags=" + this.serviceTags + ")";
        }
    }
}

