/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.mapper;

import at.twinformatics.eureka.adapter.consul.mapper.MetadataMapper;
import at.twinformatics.eureka.adapter.consul.model.Service;
import at.twinformatics.eureka.adapter.consul.model.ServiceHealth;
import com.netflix.appinfo.InstanceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InstanceInfoMapper {
    private static final List<String> NO_SERVICE_TAGS = new ArrayList<String>();
    @Value(value="${eurekaConsulAdapter.preferHostName:false}")
    private boolean preferHostName;
    private MetadataMapper metadataMapper;

    @Autowired
    public InstanceInfoMapper(MetadataMapper metadataMapper) {
        this.metadataMapper = metadataMapper;
    }

    public Service map(InstanceInfo instanceInfo) {
        String address = this.getAddress(instanceInfo);
        return Service.builder().address(address).serviceAddress(address).serviceName(instanceInfo.getAppName()).serviceID(instanceInfo.getId()).servicePort(this.getPort(instanceInfo)).node(instanceInfo.getAppName()).nodeMeta(this.metadataMapper.extractNodeMetadata(instanceInfo.getMetadata())).serviceMeta(this.metadataMapper.extractServiceMetadata(instanceInfo.getMetadata())).serviceTags(NO_SERVICE_TAGS).build();
    }

    public ServiceHealth mapToHealth(InstanceInfo instanceInfo) {
        String address = this.getAddress(instanceInfo);
        ServiceHealth.Node node = ServiceHealth.Node.builder().name(instanceInfo.getAppName()).address(address).meta(this.metadataMapper.extractNodeMetadata(instanceInfo.getMetadata())).build();
        ServiceHealth.Service service = ServiceHealth.Service.builder().id(instanceInfo.getId()).name(instanceInfo.getAppName()).tags(NO_SERVICE_TAGS).address(address).meta(this.metadataMapper.extractServiceMetadata(instanceInfo.getMetadata())).port(this.getPort(instanceInfo)).build();
        ServiceHealth.Check check = ServiceHealth.Check.builder().node(instanceInfo.getAppName()).checkID("service:" + instanceInfo.getId()).name("Service '" + instanceInfo.getId() + "' check").status(instanceInfo.getStatus().name()).build();
        return ServiceHealth.builder().node(node).service(service).checks(Collections.singletonList(check)).build();
    }

    private String getAddress(InstanceInfo instanceInfo) {
        if (this.preferHostName) {
            return instanceInfo.getHostName();
        }
        return instanceInfo.getIPAddr();
    }

    private int getPort(InstanceInfo instanceInfo) {
        if (instanceInfo.isPortEnabled(InstanceInfo.PortType.SECURE)) {
            return instanceInfo.getSecurePort();
        }
        return instanceInfo.getPort();
    }

    public void setPreferHostName(boolean preferHostName) {
        this.preferHostName = preferHostName;
    }

    public void setMetadataMapper(MetadataMapper metadataMapper) {
        this.metadataMapper = metadataMapper;
    }
}

