/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul;

import at.twinformatics.eureka.adapter.consul.controller.AgentController;
import at.twinformatics.eureka.adapter.consul.controller.ServiceController;
import at.twinformatics.eureka.adapter.consul.mapper.InstanceInfoMapper;
import at.twinformatics.eureka.adapter.consul.mapper.MetadataMapper;
import at.twinformatics.eureka.adapter.consul.mapper.NodeMetadataMapper;
import at.twinformatics.eureka.adapter.consul.mapper.ServiceMetadataMapper;
import at.twinformatics.eureka.adapter.consul.service.RegistrationEventInstanceRegistry;
import at.twinformatics.eureka.adapter.consul.service.RegistrationService;
import at.twinformatics.eureka.adapter.consul.service.ServiceChangeDetector;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.util.Assert;

@Configuration
@EnableAsync
public class EurekaConsulAdapterConfig {
    @Value(value="${eurekaConsulAdapter.useNodeMeta:false}")
    private boolean useNodeMeta;
    @Value(value="${eurekaConsulAdapter.nodeMetaPrefix:}")
    private String nodeMetaPrefix;

    @Bean
    @ConditionalOnMissingBean
    public AgentController agentController() {
        return new AgentController();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceController serviceController(RegistrationService registrationService, MetadataMapper metadataMapper) {
        return new ServiceController(registrationService, this.serviceMapper(metadataMapper));
    }

    @Bean
    @Primary
    public RegistrationEventInstanceRegistry registrationEventInstanceRegistry(ServerCodecs serverCodecs, EurekaServerConfig eurekaServerConfig, EurekaClient eurekaClient, EurekaClientConfig eurekaClientConfig, InstanceRegistryProperties instanceRegistryProperties, ServiceChangeDetector serviceChangeDetector) {
        eurekaClient.getApplications();
        return new RegistrationEventInstanceRegistry(eurekaServerConfig, eurekaClientConfig, serverCodecs, eurekaClient, instanceRegistryProperties.getExpectedNumberOfClientsSendingRenews(), instanceRegistryProperties.getDefaultOpenForTrafficCount(), serviceChangeDetector);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetadataMapper instanceMetadataMapper() {
        if (this.useNodeMeta) {
            return new NodeMetadataMapper(this.nodeMetaPrefix);
        }
        return new ServiceMetadataMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public InstanceInfoMapper serviceMapper(MetadataMapper metadataMapper) {
        return new InstanceInfoMapper(metadataMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public RegistrationService registrationService(PeerAwareInstanceRegistry peerAwareInstanceRegistry) {
        Assert.isTrue((boolean)(peerAwareInstanceRegistry instanceof RegistrationEventInstanceRegistry), (String)("Instance Registry must be of type" + RegistrationEventInstanceRegistry.class.getName()));
        return new RegistrationService(peerAwareInstanceRegistry, this.serviceChangeDetector());
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceChangeDetector serviceChangeDetector() {
        return new ServiceChangeDetector();
    }
}

